import React, { PureComponent } from "react";
import {
  Form,
  Input,
  Select,
  Timeline,
  Row,
  Col,
  Button,
  Radio,
  Steps,
  Checkbox,
  Icon,
  Table,
  InputNumber,
  TimePicker,
  Modal,
  message,
  Alert
} from "antd";
import { saveAttendAddress } from '../../../../services/api';
import PMap from "../../../../components/Pro/PMap";
const FormItem = Form.Item;

export const formItemLayout2 = {
  labelCol: {
    // xs: {span: 8},
    // sm: {span: 8}
    span: 4
  },
  wrapperCol: {
    span: 18
    // xs: {span: 12},
    // sm: {span: 12},
    // md: {span: 12}
  }
};
@Form.create()
export default class AddPlace extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      points: [],
      address: null,
      addressRange: 300,//默认范围300米
    };
  }
  areaChange = (points, address) => {
    this.setState({ points, address });
  };
  //保存驻勤点
  _saveAttendAddress(values) {
    saveAttendAddress(values).then(res => {
      if (res.retType == '0') {
        this.props.onHandleOk()
      }
    })
  }
  //必选框的标致
  mustLabel() {
    return (
      <span style={{ color: 'red' }}>*</span>
    )
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div>
        <Modal
          width="800px"
          title="添加地点"
          visible={this.props.visible}
          okText="确定"
          cancelText="取消"
          onOk={() => {
            if (!this.state.addressRange) {
              return message.warning("范围不能为空")
            } else if (!this.state.address) {
              return message.warning("请输入详细地址")
            } else if (this.state.points === []) {
              return message.warning("请在地图上选中位置")
            }
            const values = {
              comTempTaskId: this.props.comTempTaskId,
              address: this.state.address,
              addressLongitude: this.state.points[0],
              addressLatitude: this.state.points[1],
              addressRange: this.state.addressRange
            }
            this._saveAttendAddress(values)
          }}
          onCancel={() => {
            this.props.onChangeStatus(false)
          }}
        >
          <div className="item" style={{ display: 'flex', marginBottom: '10px' }}>
            <div className="label" style={{ width: '80px', lineHeight: '32px' }}>
              {this.mustLabel()}有效范围
            </div>
            <Input
              addonAfter="米"
              placeholder="请输入"
              style={{ width: 200 }}
              value={this.state.addressRange}
              onChange={(e) => {
                this.setState({
                  addressRange: e.target.value
                })
              }}
            />
          </div>
          <PMap
            areaChange={this.areaChange}
            // taskCityName={this.props.taskCityName} //添加当前驻勤城市名称，9-28
            taskCityName='' //添加当前驻勤城市名称，9-28
            ifProvince={false}
          />
        </Modal>

      </div>
    );
  }
}
