/**
 * 关联活动选择框
 */
import React, { Component } from "react";
import { Modal, Select, Alert, Button, Popconfirm } from "antd";
import { getActivityList } from '../../../../services/api';
const { Option } = Select;
export default class ActivityList extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      dataList: []
    };
  }

  componentWillReceiveProps(nextProps){
    console.log(nextProps)
    this.setState({
      value:nextProps.value
    })
  }
  componentDidMount() {
    this._getActivityList()
  }

  //获取活动列表
  _getActivityList() {
    getActivityList().then(res => {
      if (res.retType == '0') {
        this.setState({
          dataList: res.data
        })
      }
    })
  }
  render() {
    return (
      <Select
        placeholder="请选择关联的活动"
        style={{ width: 400 }}
        onChange={value => {
          const props = this.props || {};
          if ('onChange' in props) {
            this.props.onChange(value, this.state.type);
          }
        }}
      >
        {this.state.dataList.length !== 0 &&
          this.state.dataList.map((val, index) => {
            console.log(JSON.stringify(val))
            if(this.state.value===JSON.stringify(val)){
              console.log("1")
            }
            return (
              <Option value={JSON.stringify(val)} key={val.activityNo}> {val.activityNo}-{val.fullName}-{val.sponsor}</Option>
            )
          })
        }
      </Select>
    );
  }
}