import React, { Component } from "react";
import st from "styled-components";
import {
  Button,
  Alert,
} from "antd";
import SearchForm from './SearchForm';
import columnsFun from './columns';
import TaskInfo from '../commonComponents/TaskInfo';
import PTable from '../../../../components/Pro/PTable';
import $nModal from '../../../../utils/modal/nModal';
import { saveTempTask, cancelTempTask, endTempTask, syncTempTask } from '../../../../services/api';
const dateFomate = 'YYYY-MM-DD';
export default class Container extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // 表格业务逻辑相关状态
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: 10,
        pageNumber: 1,
      },
      searchDataReady: false, //筛选参数是否准备就绪
      /* 弹窗业务逻辑相关状态 */
    };
  }
  componentDidMount() {

  }

  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      }
    }, () => {
      if (!this.state.searchDataReady) {
        this.setState({
          searchDataReady: true
        });
      }
    });
  }
  //更新表格动作
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }

  //创建任务（或编辑）
  _createSubmit(values, close, comTempTaskId = '') {
    console.log(values)
    values.startDate = values.taskDate[0].format(dateFomate);
    values.endDate = values.taskDate[1].format(dateFomate);
    //合同
    values.comContractId = values.comContractList[0].comContractId;
    //任务经纬度
    values.addressLongitude = values.longitudeAndLatitude[0];
    values.addressLatitude = values.longitudeAndLatitude[1];
    //监管机构
    values.cityOrgId = values.cityOrg[0];
    values.districtOrgId = values.cityOrg[1];
    values.policeStationId = values.cityOrg[2];
    //任务地区
    values.province = values.taskLocation[0];
    values.city = values.taskLocation[1];
    values.area = values.taskLocation[2];
    //关联活动
    if (values.isRelationActivity === '1') {
      const activity = JSON.parse(values.activityNo)
      values.activityNo = activity.activityNo
      values.activityName = activity.fullName
      values.activityCom = activity.sponsor
    }
    //共享企业
    if (values.isShareTask == '1') {
      const comIds = []
      values.shareTaskList.forEach(item => {
        comIds.push(item.comId)
      })
      values.shareComIds = comIds.join(",")
    }
    console.log(values)
    if (comTempTaskId !== '') {
      values.comTempTaskId = comTempTaskId
    }
    saveTempTask(values).then(res => {
      if (res.retType === '0') {
        close();//把创建任务的模态框关掉
        this._updateTable()
      }
    })
  }

  //取消任务
  _cancelTempTask(comTempTaskId) {
    cancelTempTask({ comTempTaskId }).then(res => {
      if (res.retType === '0') {
        this._updateTable()
      }
    })
  }
  //结束任务
  _endTempTask(comTempTaskId) {
    endTempTask({ comTempTaskId }).then(res => {
      if (res.retType === '0') {
        this._updateTable()
      }
    })
  }
  //同步到承办方
  _syncTempTask(comTempTaskId) {
    syncTempTask({ comTempTaskId }).then(res => {
      if (res.retType === '0') {
        Modal.success({
          title: '已将该任务最新信息同步给承办方',
          content: '任务信息有更新时，请主动同步给承办方，已保证承办方的信息最新。',
        });
        this._updateTable()
      }
    })
  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <div>
        <Alert
          message={<div>
            <span>1、我司承保的临保任务：保安公司承接了大型活动而发布的临时安保任务，发起的保安公司可以将任务分享给其他保安公司，共享其他保安公司的保安员资源，共同执行临保任务。</span><br />
            <span>2、点击列表上的蓝色数值或操作按钮即可进行任务相关管理操作；</span><br />
            <span style={{ color: 'red' }}>3、若任务有关联活动，当任务信息、人员信息、排班信息、考勤点信息发生更新时，请点击【同步到承办方】按钮，以便承办方获取到最新的临保任务数据。</span><br />
          </div>}
          type="warning"
          showIcon
        />
        <SearchForm
          onSearch={this._search}
        />
        <Btns>
          <Button type="primary"
            onClick={() => {
              let appealForm = null;
              $nModal({
                width: 1000,
                title: '新建任务',
                content: (
                  <TaskInfo
                    onGetForm={(form) => {
                      appealForm = form;
                    }}
                  />
                ),
                onOk: ((close) => {
                  appealForm.validateFields((err, values) => {
                    // if (!err) {
                    this._createSubmit(values, close)
                    // }
                  })
                })
              });
            }}
          >
            创建临保任务
          </Button>
        </Btns>
        {
          this.state.searchDataReady &&
          <PTable
            style={{ marginTop: 10 }}
            columns={columns}
            url="getReleaseTempTaskList"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`
            }}
            scroll={{ x: '1500px' }}
          // dateChange={() => { }}
          />
        }
      </div>
    );
  }
}

const Btns = st.div`
  margin: 10px;
  >button{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;

