import st from "styled-components";
import $nModal from "../../../../utils/modal/nModal";
import PersonModal from "../commonComponents/PersonModal/index";
import TaskInfo from "../commonComponents/TaskInfo";
// import ContractInfo from "../commonComponents/ContranctInfo";
import PlaceInfo from "../commonComponents/PlaceInfo";
import { Popconfirm } from "antd";
const warnColor = "#F59A23";
const okColor = "#4B7902";
const errColor = "#D9001B";
export default function() {
  return [
    {
      title: "序号",
      dataIndex: "number",
      key: "number",
      fixed: "left",
      width: 80
      
    },
    {
      title: "任务名称",
      dataIndex: "taskName",
      key: "taskName"
    },
    {
      title: "任务状态",
      dataIndex: "taskStatusComment",
      key: "taskStatusComment",
      render: (value, record) => {
        return (
          <span
            style={{
              color:
                record.taskStatus === "7"
                  ? errColor
                  : record.taskStatus === "6" || record.taskStatus === "0"
                  ? warnColor
                  : record.taskStatus === "1"
                  ? okColor
                  : ""
            }}
          >
            {value || "-"}
          </span>
        );
      }
    },
    {
      title: "承保企业名称",
      dataIndex: "comName",
      key: "comName",
      render: value => value || "-"
    },
    {
      title: "活动名称",
      dataIndex: "activityName",
      key: "activityName",
      render: value => value || "-"
    },
    {
      title: "活动承办方",
      dataIndex: "activityCom",
      key: "activityCom",
      render: value => value || "-"
    },
    {
      title: "共保企业名称",
      dataIndex: "shareComList",
      key: "shareComList",
      render: (text, record) => {
        if (text.length > 0) {
          return (
            <span>
              {text.map(item => {
                return <p key={item.comId}>{item.comName}</p>;
              })}
            </span>
          );
        } else {
          return <span>-</span>;
        }
      }
    },
    {
      title: "任务时间",
      dataIndex: "date",
      key: "date",
      render: (text, record) => {
        return (
          <span>
            {record.startDate}~{record.endDate}
          </span>
        );
      }
    },
    {
      title: "任务人员",
      dataIndex: "rwrs",
      key: "rwrs",
      fixed: "right",
      width: 100,
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              onClick={() => {
                $nModal({
                  width: 1000,
                  title: record.taskName + "-人员管理",
                  content: (
                    <PersonModal
                      _updateTable={() => {
                        this._updateTable();
                      }}
                      comTempTaskId={record.comTempTaskId}
                      readOnly={record.taskStatus === "7"}
                    ></PersonModal>
                  ),
                  footer:null,
                  // onOk: close => {
                  //   close();
                  // }
                });
              }}
            >
              {text}人
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}人</span>;
          }
        }
      }
    },
    // {
    //   title: "关联合同",
    //   dataIndex: "glhts",
    //   key: "glhts",
    //   fixed: "right",
    //   width: 100,
    //   render: (text, record) => {
    //     if (record.taskStatusValue != 6) {
    //       return (
    //         <a
    //           onClick={() => {
    //             let appealForm = null;
    //             $nModal({
    //               width: 1000,
    //               title: "关联合同",
    //               content: (
    //                 <ContractInfo
    //                   onGetForm={form => {
    //                     appealForm = form;
    //                   }}
    //                   dataList={record.}
    //                 />
    //               ),
    //               onOk: close => {
    //                 // appealForm.validateFields((err, values) => {
    //                 //   if (!err) {
    //                 //     this._createSubmit();
    //                 //   }
    //                 // });
    //               }
    //             });
    //           }}
    //         >
    //           {text}份
    //         </a>
    //       );
    //     } else {
    //       if (text == "0") {
    //         return <span>-</span>;
    //       } else {
    //         return <span>{text}份</span>;
    //       }
    //     }
    //   }
    // },
    {
      title: "考勤点",
      dataIndex: "kqds",
      key: "kqds",
      fixed: "right",
      width: 100,
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              onClick={() => {
                // let appealForm = null;
                $nModal({
                  width: 1000,
                  title: record.taskName + "-考勤点",
                  content: (
                    <PlaceInfo
                      comTempTaskId={record.comTempTaskId}
                      _updateTable={() => this._updateTable()}
                      readOnly={record.taskStatus === "7"}
                    />
                  ),
                  footer:null,
                  // onOk: close => {
                  //   close();
                  // }
                });
              }}
            >
              {text}个
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}个</span>;
          }
        }
      }
    },
    {
      title: "操作",
      dataIndex: "operation",
      key: "operation",
      fixed: "right",
      width: 220,
      render: (text, record) => {
        //任务状态（0：未开始；1：进行中；2：已完成；3：已延迟；4：已取消；5：已暂停；6：未发布；7：已结束）
        return (
          <Oper>
            {/**
             * 已结束的任务只能查看
             * 其他状态可以编辑
             */
            record.taskStatus === "7" ? (
              <a
                onClick={() => {
                  $nModal({
                    width: 1000,
                    title: record.taskName + "-任务信息",
                    content: (
                      <TaskInfo taskId={record.comTempTaskId} readOnly />
                    ),
                    onOk: close => {
                      close();
                    }
                  });
                }}
              >
                查看
              </a>
            ) : (
              <a
                onClick={() => {
                  let appealForm = null;
                  $nModal({
                    width: 1000,
                    title: record.taskName + "-编辑任务",
                    content: (
                      <TaskInfo
                        onGetForm={form => {
                          appealForm = form;
                        }}
                        taskId={record.comTempTaskId}
                      />
                    ),
                    onOk: close => {
                      appealForm.validateFields((err, values) => {
                        if (!err) {
                          this._createSubmit(
                            values,
                            close,
                            record.comTempTaskId
                          );
                        }
                      });
                    }
                  });
                }}
              >
                编辑
              </a>
            )}

            {/**
             * 1、未开始的任务可以取消
             * 2、进行中的任务可以结束
             */
            record.taskStatus === "0" ? (
              <Popconfirm
                overlayClassName="change-clock-pop"
                title="确定取消?"
                onConfirm={() => {
                  this._cancelTempTask(record.comTempTaskId);
                }}
                okText="确定"
                cancelText="取消"
              >
                <a href="javascript:void(0)">取消</a>
              </Popconfirm>
            ) : record.taskStatus === "1" ? (
              <Popconfirm
                overlayClassName="change-clock-pop"
                title="确定结束?"
                onConfirm={() => {
                  this._endTempTask(record.comTempTaskId);
                }}
                okText="确定"
                cancelText="取消"
              >
                <a href="javascript:void(0)" style={{ color: errColor }}>
                  结束
                </a>
              </Popconfirm>
            ) : (
              ""
            )}

            <Popconfirm
              overlayClassName="change-clock-pop"
              title="确定同步到承办方?"
              onConfirm={() => {
                this._syncTempTask(record.comTempTaskId);
              }}
              okText="确定"
              cancelText="取消"
            >
              <a href="javascript:void(0)">同步到承办方</a>
            </Popconfirm>
          </Oper>
        );
      }
    }
  ];
}

const Oper = st.div`
  a{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
