import st from "styled-components";
import $nModal from "../../../../utils/modal/nModal";
import PersonModal from "../commonComponents/PersonModal/index";
import TaskInfo from "../commonComponents/TaskInfo";
import ContractInfo from "../commonComponents/ContranctInfo";
import PlaceInfo from "../commonComponents/PlaceInfo";
const warnColor = "#F59A23";
const okColor = "#4B7902";
const errColor = "#D9001B";
export default function() {
  return [
    {
      title: "序号",
      dataIndex: "number",
      key: "number",
      fixed: "left",
      width: 80
    },
    {
      title: "任务名称",
      dataIndex: "taskName",
      key: "taskName"
    },
    {
      title: "任务状态",
      dataIndex: "taskStatusComment",
      key: "taskStatusComment",
      render: (value, record) => {
        return (
          <span
            style={{
              color:
                record.taskStatus === "7"
                  ? errColor
                  : record.taskStatus === "6" || record.taskStatus === "0"
                  ? warnColor
                  : ""
            }}
          >
            {value || "-"}
          </span>
        );
      }
    },
    {
      title: "承保企业名称",
      dataIndex: "comName",
      key: "comName",
      render: value => value || "-"
    },
    {
      title: "活动名称",
      dataIndex: "activityName",
      key: "activityName",
      render: value => value || "-"
    },
    {
      title: "活动承办方",
      dataIndex: "activityCom",
      key: "activityCom",
      render: value => value || "-"
    },
    {
      title: "共保企业名称",
      dataIndex: "shareComList",
      key: "shareComList",
      render: (text, record) => {
        if (text.length > 0) {
          return (
            <span>
              {text.map(item => {
                return <p>{item.comName}</p>;
              })}
            </span>
          );
        } else {
          return <span>-</span>;
        }
      }
    },
    {
      title: "任务时间",
      dataIndex: "date",
      key: "date",
      render: (text, record) => {
        return (
          <span>
            {record.startDate}~{record.endDate}
          </span>
        );
      }
    },
    {
      title: "驻勤人数",
      dataIndex: "rwrs",
      key: "rwrs",
      fixed: "right",
      width: 100,
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              onClick={() => {
                $nModal({
                  width: 1000,
                  title: record.taskName + "-人员管理",
                  content: (
                    <PersonModal
                      _updateTable={() => {
                        this._updateTable();
                      }}
                      comTempTaskId={record.comTempTaskId}
                      readOnly={record.taskStatus === "7"}//已完成的状态，按钮不让编辑
                      noUpdate//共保页面的修改按钮一例不要
                    ></PersonModal>
                  ),
                  footer:null,
                  // onOk: close => {
                  //   close();
                  // }
                });
              }}
            >
              {text}人
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}人</span>;
          }
        }
      }
    },
    {
      title: "考勤点",
      dataIndex: "kqds",
      key: "kqds",
      fixed: "right",
      width: 100,
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              onClick={() => {
                $nModal({
                  width: 1000,
                  title: record.taskName + "-考勤点",
                  content: (
                    <PlaceInfo
                      comTempTaskId={record.comTempTaskId}
                      _updateTable={() => this._updateTable()}
                      readOnly
                    />
                  ),
                  footer:null,
                  // onOk: close => {
                  //   close();
                  // }
                });
              }}
            >
              {text}个
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}个</span>;
          }
        }
      }
    },
    {
      title: "操作",
      dataIndex: "operation",
      key: "operation",
      fixed: "right",
      width: 220,
      render: (text, record) => {
        return (
          <Oper>
            <a
              onClick={() => {
                $nModal({
                  width: 1000,
                  title: record.taskName + "-任务信息",
                  content: <TaskInfo taskId={record.comTempTaskId} readOnly />,
                  onOk: close => {
                    close();
                  }
                });
              }}
            >
              查看
            </a>
          </Oper>
        );
      }
    }
  ];
}

const Oper = st.div`
  a{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
