import React from 'react';
import store from 'store';
import { connect } from 'dva';
import {
  saveComSalarySyncInit,
  comSalarySyncInitCheckIsInit
} from '../../../services/api';
import { Button, Checkbox, Modal } from 'antd';
import b_wallet from '../../../assets/images/salary/salary.png';
import $pModal from '../../../utils/modal/pModal';
import st from './style.less';
@connect(state => ({
  global: state.global
}))
export default class StepOne extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      readed: false,
      url: '',
      openTipModal: false,
      showIframe: false,
      height: document.documentElement.clientHeight || document.body.clientHeight
    };
  }
  componentWillMount() {
    this.__init();
  }
  componentDidMount() {
    document.querySelector(".ant-layout-content").style.margin = "0px";
  }
  componentWillUnmount() {
    document.querySelector(".ant-layout-content").style.margin = "16px";
  }
  __init() {
    comSalarySyncInitCheckIsInit({}).then(res => {
      if (res.data == '1') {
        const { thirdSessionId } = store.get('saas');
        const salaryUrl = store.get('salaryUrl');
        this.setState({
          showIframe: true,
          url: salaryUrl + 'loginkey=' + thirdSessionId
        });
         // 隐藏左侧菜单
         this.props.dispatch({
          type: 'global/changeLMenu',
          payload: {
            lMenu: false
          }
        });
         // 隐藏底部
         this.props.dispatch({
          type: 'global/changeFooter',
          payload: {
            footer: false
          }
        });
        //隐藏顶部菜单
        // dispatch({
        //   type: 'global/changeTMenu',
        //   payload: {
        //     lMenu: false
        //   }
        // });
      } else {
         // 显示左侧菜单
         this.props.dispatch({
          type: 'global/changeLMenu',
          payload: {
            lMenu: true
          }
        });
        // 显示底部
        this.props.dispatch({
          type: 'global/changeLMenu',
          payload: {
            footer: true
          }
        });
        this.setState({
          showIframe: false
        });
      }
    });
  }
  render() {
    if (this.state.showIframe) {
      return (
        <iframe
          style={{minHeight: this.state.height - 72}}
          // style={{minHeight: 'calc(100vh -100px)'}}
          title="课程列表"
          src={this.state.url}
          width="100%"
          height="100%"
          frameBorder="0"
          allowFullScreen
          allowtransparency="true">
          您的浏览器不支持iframe，请升级
        </iframe>
      );
    }
    return (
      <div className={st.before_container}>
        <div className={st.financial_header}>
          <div className="img_box">
            {/* <img src={this.props.global.companyInfo.comCerUrl} alt=""/> */}
            <img src={b_wallet} alt="金融钱包" />
          </div>
          <div className={st.header_info} style={{ overflow: 'hidden' }}>
            <p className={st.title}>企业薪酬服务</p>
            <div>
              <Button disabled={!this.state.readed} type="primary"
                onClick={() => {
                  this.setState({
                    openTipModal: true
                  });
                }}
              >免费开通服务</Button>
            </div>
            <Checkbox
              style={{ marginTop: 10 }}
              onChange={e => {
                this.setState({
                  readed: e.target.checked
                });
              }}></Checkbox>
            <span style={{ color: '#FF6600', fontSize: 14, marginLeft: 5 }}>勾选则表示您已阅并同意</span>
            {/* <a style={{fontSize: 14}} href="/finance/agreement/wallet" target="_blank"> */}
            <a style={{ fontSize: 14 }}>
              《百保盾薪酬服务协议》
              </a>
            {/* <p className="tip">请联系在线客服，确定合作意向，完成服务签约后，即可在本页面在线开通。</p> */}
          </div>
        </div>

        <div className={st.question_info}>
          <h3>Q：什么是企业薪酬服务？</h3>
          <div>企业薪酬服务，是百保盾公共安全服务平台为企业用户提供的全套薪酬管理及薪资计算的免费服务。</div>
          <h3>Q：企业薪酬服务有哪些功能？</h3>
          <div>
            <p>
              企业薪酬服务支持人员核薪调薪、薪资档案、浮动工资、个税抵扣数据、在线计算工资、工资单管理、自定义薪资项目等功能，满足企业的薪酬计算。
            </p>
          </div>
        </div>

        <Modal
          title="服务开通提醒"
          okText="我已了解，继续开通"
          cancelText="取消"
          visible={this.state.openTipModal}
          onOk={() => {
            this.setState({
              openTipModal: false
            }, () => {
              saveComSalarySyncInit({}).then(() => {
                $pModal(
                  '薪酬服务开通成功',
                  '请刷新页面后进入薪酬服务',
                  [
                    {
                      text: '刷新页面',
                      type: 'primary',
                      promiseType: 'confirm'
                    }
                  ]
                ).then(res => {
                  if (res.type == 'confirm') {
                    this.__init();
                  }
                  res.close();
                });
              });
            });
          }}
          onCancel={() => { this.setState({ openTipModal: false }) }}
        >
          <span style={{ display: 'block' }}>1、系统即将为您免费开通企业薪酬服务；</span>
          <span style={{ display: 'block', color: 'red' }}>2、系统默认将您的系统主管理员作为薪酬服务的初始管理员，请先使用系统主管理员账号进行访问；</span>
          <span style={{ display: 'block' }}>3、若需要分配其他薪酬管理用户，请访问“薪酬服务-系统管理员-用户管理”页面，为企业人员分配薪酬角色；</span>
          <span style={{ display: 'block' }}>4、配置薪酬角色的员工才有权限访问薪酬服务页面，否则将拒绝访问。</span>
        </Modal>
      </div>
    );
  }
}