import React, { Component } from "react";
import moment from 'moment';
// import {
  
// } from '../../../services/api';
import {
  Button,
  Form,
  Select,
  DatePicker,
  Input
} from "antd";
const { RangePicker } = DatePicker;
const { Option } = Select;
// const formItemLayout = {
//   labelCol: {
//     xs: { span: 5 },
//     sm: { span: 5 },
//   },
//   wrapperCol: {
//     xs: { span: 18 },
//     sm: { span: 18 },
//   },
// };
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      month: [],
      mode: ['month', 'month']
    };
  }
  componentDidMount() {
    this.props.onSearch(this.props.form.getFieldsValue());
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 搜索的时候重置为第一页
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this.setState({
      month: []
    });
    const data = this.props.form.getFieldsValue();
    data.month = [];
    this.props.onSearch(data);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input placeholder="请输入关键词" />
          )}
        </Form.Item>
        <Form.Item label="类型">
          {getFieldDecorator('bizInvoiceType', {
            initialValue: '0'
          })(
            <Select style={{ width: 120 }}>
              <Option value="0">全部</Option>
              <Option value="1">我方应开</Option>
              <Option value="2">我方应收</Option>
            </Select>,
          )}
        </Form.Item>
        <Form.Item label="开票月份">
          {getFieldDecorator('month',{
            initialValue: this.state.month
          })(
            <RangePicker
              placeholder={['开始月份', '结束月份']}
              format="YYYY-MM"
              mode={this.state.mode}
              onPanelChange={(value, mode) => {
                this.setState({
                  month: value
                });
              }}
            />
          )}
          
        </Form.Item>
        <Form.Item label="开票方确认状态">
          {getFieldDecorator('drawerConfirm', {
            initialValue: ''
          })(
            <Select style={{ width: 120 }}>
              <Option value="">全部</Option>
              <Option value="0">未确认</Option>
              <Option value="1">已确认</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="收票方确认状态">
          {getFieldDecorator('receiverConfirm', {
            initialValue: ''
          })(
            <Select style={{ width: 120 }}>
              <Option value="">全部</Option>
              <Option value="0">未确认</Option>
              <Option value="1">已确认</Option>
            </Select>
          )}
        </Form.Item>
        {/* <Form.Item label="开票状态">
          {getFieldDecorator('makeStatus', {
            initialValue: ''
          })(
            <Select style={{ width: 120 }}>
              <Option value="">全部</Option>
              <Option value="0">未开票</Option>
              <Option value="1">已开票</Option>
              <Option value="2">开票中</Option>
            </Select>
          )}
        </Form.Item> */}
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
    
      </Form>
    );
  }
}
