import React, { Component } from "react";
import {
  host,
  uploadBizInvoice,
  applyEinvoice
} from '../../../services/api';
import { phone as phoneReg } from '../../../utils/regs';
// import $loading from '../../../utils/loading';
import {
  Button,
  Drawer,
  Form,
  Input,
  Upload,
  Icon,
  notification
} from "antd";
const formItemLayout = {
  labelCol: {
    xs: { span: 5 },
    sm: { span: 5 },
  },
  wrapperCol: {
    xs: { span: 18 },
    sm: { span: 18 },
  },
};
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      invoiceInfo: null,
      fileList: [],
      invoiceUrl: '',
    };
  }
  componentDidMount() {

  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const { invoiceInfo } = this.props;
    const uploadProps = {
      name: 'xfile',
      action: `${host}/public/common/file/upload-file`,
      headers: {
        authorization: 'authorization-text',
      },
      fileList: this.state.fileList,
      multiple: false,
      beforeUpload: file => {
        const isJpgOrPng = file.type === 'image/jpeg' || file.type === 'image/png' || file.type == 'application/pdf';
        if (!isJpgOrPng) {
          this.setState({
            fileList: []
          });
          notification.error({ message: '格式支持 jpg/png/pdf' });
        }
        const isLt10M = file.size / 1024 / 1024 < 10;
        if (!isLt10M) {
          notification.error({ message: '上传文件不大于10M' });
        }
        return isJpgOrPng && isLt10M;
      },
      onChange: async info => {
        if (info.file.status === 'uploading') {
          this.setState({
            fileList: [info.file]
          });
        }
        if (info.file.status === 'removed') {
          this.setState({
            fileList: []
          });
        }
        if (info.file.status === 'done') {
          const res = info.file.response;
          if (res.retType == 0) {
            this.setState({
              invoiceUrl: res.data
            });

          } else {
            notification.error({ message: res.msg });
          }

        } else if (info.file.status === 'error') {
          this.setState({
            fileList: []
          });
          notification.error({ message: `${info.file.name} 上传失败` });
        }
      },
    };
    return (
      <Drawer
        title="开票信息"
        width={600}
        visible={this.props.visible}
        onClose={this.props.onClose}
      >
        {
          invoiceInfo &&
          <Form style={{ marginBottom: 40 }}>
            <Form.Item {...formItemLayout} label='类型:'>
              {getFieldDecorator('bizInvoiceMakeType', {
                initialValue: invoiceInfo.bizInvoiceMakeTypeStr,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='发票抬头:'>
              {getFieldDecorator('title', {
                initialValue: invoiceInfo.title,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='纳税人识别号:'>
              {getFieldDecorator('taxRegCerNo', {
                initialValue: invoiceInfo.taxRegCerNo,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled maxLength={50} placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='开户银行:'>
              {getFieldDecorator('bank', {
                initialValue: invoiceInfo.bank,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='开户行账号:'>
              {getFieldDecorator('bankAccount', {
                initialValue: invoiceInfo.bankAccount,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' maxLength={50} />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='注册电话:'>
              {getFieldDecorator('regPhone', {
                initialValue: invoiceInfo.regPhone,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='注册地址:'>
              {getFieldDecorator('regAddress', {
                initialValue: invoiceInfo.regAddress,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='收票人姓名:'>
              {getFieldDecorator('receiver', {
                initialValue: invoiceInfo.receiver,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='收票人联系电话:'>
              {getFieldDecorator('receiverPhone', {
                initialValue: invoiceInfo.receiverPhone,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !phoneReg.test(value)) {
                        callback('请输入正确的手机号');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='寄送地址:'>
              {getFieldDecorator('receiverAddress', {
                initialValue: invoiceInfo.receiverAddress,
                rules: [
                  {
                    required: true,
                    message: '请输入'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input disabled placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='发票文件:'>
              {
                invoiceInfo.invoiceUrl ?
                  <a href={invoiceInfo.invoiceUrl} target="_blank">点击查看</a>
                  :
                  '开票方暂未上传'
              }

            </Form.Item>
            <Form.Item {...formItemLayout} label=' ' colon={false}>
              {
                invoiceInfo && invoiceInfo.isDrawer == 1 && invoiceInfo.makeStatus == 0 && invoiceInfo.invoiceUrl == '' &&
                <Upload style={{ display: 'inline' }} {...uploadProps}>
                  <Button size="small">
                    <Icon type="upload" />选择发票文件
                  </Button>
                  <span style={{marginLeft: 10}}>仅支持支持 jpg/png/pdf格式</span>
                </Upload>

              }
              {
                // 开票方 未开票 电子发票
                invoiceInfo && invoiceInfo.isDrawer == 1 && invoiceInfo.makeStatus == 0 && invoiceInfo.bizInvoiceMakeType == 3 &&
                <Button type="primary" size="small"
                  onClick={() => {
                    const { comBizInvoiceId } = this.props;
                    applyEinvoice({ comBizInvoiceId }).then(res => {
                      this.props.onClose();
                      this.props.reload();
                    });
                  }}
                >
                  在线开电子发票
                </Button>
              }
            </Form.Item>
          </Form>
        }
        {
          // this.props.confirmStatus? '':
          // this.props.bizInvoiceType == 1 &&
          invoiceInfo && invoiceInfo.isDrawer == 1 && invoiceInfo.makeStatus == 0 && invoiceInfo.invoiceUrl == '' &&
          // invoiceInfo && invoiceInfo.isDrawer == 1 && invoiceInfo.makeStatus == 0 &&
          <div
            style={{
              position: 'absolute',
              left: 0,
              bottom: 0,
              width: '100%',
              borderTop: '1px solid #e9e9e9',
              padding: '10px 16px',
              background: '#fff',
              textAlign: 'right',
            }}
          >
            <Button type="primary" style={{ marginRight: 8 }} onClick={
              async () => {
                const { invoiceUrl } = this.state;
                if (!invoiceUrl) {
                  return notification.error({ message: '请选择发票文件' });
                }
                const { comBizInvoiceId } = this.props;
                const uploadRes = await uploadBizInvoice({
                  comBizInvoiceId,
                  invoiceUrl
                });
                if (uploadRes.retType == 0) {
                  this.props.reload();
                  this.props.onClose();
                  this.setState({
                    fileList: []
                  });
                }
              }
            }>
              上传发票
            </Button>
          </div>
        }
      </Drawer>
    );
  }
}
