import React, { Component } from "react";
import { withRouter } from 'dva/router';
import {
  confirmBizInvoiceInfo,
  enterpriseCompanyComBaseInfoGetComBaseInfoById, //公司基础信息（信用代码，电话）comCerNo、telePhone
  selectComAdmin, //管理员信息 （管理员姓名）name
  getCompanyVnvoiceInfo, //发票信息（寄送地址）address
} from '../../../services/api';
import { phone as phoneReg } from  '../../../utils/regs';
import {
  // Button,
  Drawer,
  Form,
  Input,
  Radio
} from "antd";
const formItemLayout = {
  labelCol: {
    xs: { span: 5 },
    sm: { span: 5 },
  },
  wrapperCol: {
    xs: { span: 18 },
    sm: { span: 18 },
  },
};

@withRouter
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      invoiceInfo: null
    };
  }
  componentDidMount() {
    this.props.onOk(this._submit);
    this.__initInvoiceInfo();
  }
  async __initInvoiceInfo() {
    const invoiceInfoRes = await getCompanyVnvoiceInfo({});
    const invoiceInfo = invoiceInfoRes.data || {};
    const baseInfoRes = await enterpriseCompanyComBaseInfoGetComBaseInfoById({});
    const baseInfo = baseInfoRes.data || {};
    const adminInfoRes = await selectComAdmin({});
    let adminInfo = {};
    if(adminInfoRes) {
      adminInfo = adminInfoRes.data[0];
    }
    invoiceInfo.regAddress = baseInfo.regAddress;
    invoiceInfo.regPhone = baseInfo.telePhone;
    invoiceInfo.name = adminInfo.name;
    this.setState({ invoiceInfo });
  }
  _submit = (e, disableBtn ,cb) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if(err) {
        disableBtn && disableBtn(false);
        return;
      }
      values.comBizInvoiceId = this.props.comBizInvoiceId;
      confirmBizInvoiceInfo(values).then(res => {
        cb && cb();
      });
    });
  }
  _inputValidator = (rule, value, callback) => {
    if (value && !/^\S{0,100}$/.test(value)) {
      callback('最大长度为100的字符');
    } else {
      callback();
    }
  }
  render() {
    const { getFieldDecorator, getFieldValue } = this.props.form;
    const { invoiceInfo } = this.state;
    return (
      <Drawer
        title="填写开票信息"
        width={600}
        visible={this.props.visible}
        onClose={this.props.onClose}
      // {...this.props}
      >
        {
          invoiceInfo &&
          <Form onSubmit={this._submit} style={{marginBottom: 40}}>
            <Form.Item {...formItemLayout} label='发票类型:'>
              {getFieldDecorator('bizInvoiceMakeType', {
                initialValue: '1',
              })(
                <Radio.Group>
                  <Radio.Button value="1">纸质普票</Radio.Button>
                  <Radio.Button value="2">纸质专票</Radio.Button>
                  <Radio.Button value="3">电子发票</Radio.Button>
                </Radio.Group>
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label='发票抬头:'>
              {getFieldDecorator('title', {
                initialValue: invoiceInfo.comName,
                rules: [
                  {
                    required: true,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='纳税人识别号:'>
              {getFieldDecorator('taxRegCerNo', {
                initialValue: invoiceInfo.taxRegCerNo,
                rules: [
                  {
                    required: true,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input maxLength={50} placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='开户银行:'>
              {getFieldDecorator('bank', {
                initialValue: invoiceInfo.bank,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='开户行账号:'>
              {getFieldDecorator('bankAccount', {
                initialValue: invoiceInfo.bankAccount,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' maxLength={50} />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='注册电话:'>
              {getFieldDecorator('regPhone', {
                initialValue: invoiceInfo.regPhone,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='注册地址:'>
              {getFieldDecorator('regAddress', {
                initialValue: invoiceInfo.regAddress,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='收票人姓名:'>
              {getFieldDecorator('receiver', {
                initialValue: invoiceInfo.name,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2 || getFieldValue('bizInvoiceMakeType') == 1,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='收票人联系电话:'>
              {getFieldDecorator('receiverPhone', {
                initialValue: invoiceInfo.telephone,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2 || getFieldValue('bizInvoiceMakeType') == 1,
                    message: '此项必填'
                  },
                  {
                    validator: (rule, value, callback) => {
                      if (value && !phoneReg.test(value)) {
                        callback('此项必填正确的手机号');
                      } else {
                        callback();
                      }
                    }
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label='寄送地址:'>
              {getFieldDecorator('receiverAddress', {
                initialValue: invoiceInfo.address,
                rules: [
                  {
                    required: getFieldValue('bizInvoiceMakeType') == 2 || getFieldValue('bizInvoiceMakeType') == 1,
                    message: '此项必填'
                  },
                  {
                    validator: this._inputValidator
                  }
                ]
              })(<Input placeholder='请输入' />)}
            </Form.Item>
          </Form>
        }
        <div
          style={{
            position: 'absolute',
            left: 0,
            bottom: 0,
            width: '100%',
            borderTop: '1px solid #e9e9e9',
            padding: '10px 16px',
            background: '#fff',
            textAlign: 'right',
          }}
        >
          {this.props.children}
        </div>
      </Drawer>
    );
  }
}
