import React, { PureComponent } from 'react';
import { connect } from 'dva';
// import { routerRedux, Link } from 'dva/router';
import { Form, Button, Steps, Modal } from 'antd';
import './Enroll.less';
import EnterpriseRegisterIcon from '../../assets/images/enterprise_register.png';
import PersonalRegisterIcon from '../../assets/images/personal_register.png';
import IconS from '../../components/IconS';

const { Step } = Steps;

@connect(state => ({
  register: state.register
}))
@Form.create()
export default class Enroll extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      provinaces: [
        {
          name: '广西', 
          url: 'http://gx.baibaodun.cn//iframe/register.jsp'
        },
        {
          name: '陕西', 
          url: 'http://sn.baibaodun.cn//iframe/register.jsp'
        },
        {
          name: '宁夏', 
          url: 'http://222.75.71.181:11180//iframe/register.jsp'
        },
        {
          name: '北京', 
          url: 'http://1.202.89.254:8801/ars-web//iframe/register.jsp'
        }
      ],
      provincesShow: false
      // count: 0,
    };
  }
  /******************************生命周期******************************/

  componentDidMount = () => {};
  /******************************ajax请求******************************/

  /******************************相关事件******************************/

  /******************************render******************************/

  render() {
    return (
      <div className='Enroll'>
        <div className='enroll-header'>
          <div className='head-portrait'>
            <IconS type='logo-' />
            <span className='head-portrait-text'>
              <span style={{ fontSize: '18px' }}>百保盾</span>
              <br />
              <span style={{ fontSize: '12px' }}>改变工作 改变你</span>
            </span>
          </div>
          <div className='head-portrait-register'>
            <span
              style={{ cursor: 'pointer' }}
              onClick={() => this.props.history.push('LogOn')}
            >
              登录
            </span>
          </div>
        </div>
        <div
          className='enroll-main'
          style={{ minHeight: 'calc(100vh - 165px)' }}
        >
          <div className='enroll-content'>
            <div className='enroll-container'>
              <div className='enroll-category' style={{ width: '340px' }}>
                <dl className='enroll-dl'>
                  <dt className='enroll-text'>企业注册</dt>
                  <dd className='enroll-img'>
                    <img src={EnterpriseRegisterIcon} alt='' />
                  </dd>
                  <dd className='enroll-btn'>
                    <Button
                      onClick={() =>
                        this.props.history.push('EnterpriseRegistration')
                      }
                      type='primary'
                      size='large'
                    >
                      注册
                    </Button>
                    <p className="introduce">若您的企业已具有相关资质,无需再进行公安申报许可的,可直接注册使用本系统。</p>
                  </dd>
                </dl>
              </div>
              {/* 暂时隐藏个人注册，张烨要求，暂时个人注册未启用 */}
              <div className="enroll-category enroll-border">
                <dl className="enroll-dl">
                  <dt className="enroll-text">自然人注册</dt>
                  <dd className="enroll-img">
                    <img src={PersonalRegisterIcon} alt="" />
                  </dd>
                  <dd className="enroll-btn">
                    <Button
                      // onClick={() =>
                      //   this.props.history.push("PersonalRegistration")
                      // }
                      onClick={() =>
                        this.setState({
                          provincesShow: true
                        })
                      }
                      type="primary"
                      size="large"
                    >
                      注册
                    </Button>
                    <p className="introduce">若您的企业尚未进行备案许可申报许可,暂无相关行业资质的,请通过本通道,完成相关许可申请,申请通过后,系统会自动为您开通企业账号。</p>
                  </dd>
                </dl>
              </div>
            </div>
          </div>
        </div>
        <Modal
          className="choose_provinces_modal"
          title="请选择地区"
          onCancel={() => {
            // 恢复初始状态
            this.setState({
              provincesShow: false
            });
          }}
          visible={this.state.provincesShow}
        >
          {this.state.provinaces.map((item, index) => {
            return (
              <Button
                key={index}
                onClick={() => {
                  window.location.href = item.url;
                }}
                className="province_btn"
              >
                {item.name}
              </Button>
            );
          })}

<p className="tip">
                    注：仅限已落地开通的省份进行自然人申请开通服务，请准确选择您所属的省份。

若您所在省份不在以下列表中，请联系当地公安或在线客服进行咨询（400-662-9696）。
                  </p>
        </Modal>
      </div>
    );
  }
}
