import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";
import { connect } from 'dva';
const store = require("store");
import { enterpriseCompanyComBaseInfoGetComBaseInfoById, selectComAdmin, getCompanyVnvoiceInfo } from '../../../services/api';
const { TabPane } = Tabs;
import { originReg } from '../../../utils/regs';
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
export default class CoursesList extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      url: store.get("coursesListURL")["coursesListURL"],
      // url: 'http://localhost:8888/productdetail?tit=保安培训课程&systype=saas&sessionId=46FC13ED8E39C7DAFEEBD913176F1CAE7F0EDBA184424441FAA06ED0B312C34DFABC1FE0DC3013427B51F0A86F6849669F95E9DEE49499015936A1B1A6AD762B&areaCode=110100',
    };
  }
  componentDidMount = async () => {
    // 公司基础信息（信用代码，电话）comCerNo、telePhone
    const comBaseInfoRes = await enterpriseCompanyComBaseInfoGetComBaseInfoById({});
    const comBaseInfo = comBaseInfoRes.data || {};
    // 管理员信息 （管理员姓名）name
    const adminInfoRes = await selectComAdmin({});
    const adminInfo = adminInfoRes.data?adminInfoRes.data[0]: {};
    // 发票信息（寄送地址）address
    const invoiceRes = await getCompanyVnvoiceInfo({});
    const invoiceInfo = invoiceRes.data? invoiceRes.data: {};
    // enterpriseCompanyComBaseInfoGetComBaseInfoById({}).then(res => {

    //   const baseInfo = res.data;
    //   selectComAdmin({}).then(result => {

    //   });
    // });
    const baseInfo = {...comBaseInfo, ...adminInfo , invoiceInfo};
    let ifr = window.frames['coursesList'];
    const url = this.state.url;
    const origin = url.match(originReg)?url.match(originReg)[0]: null;
    // ifr.onload = ifr.onreadystatechange = function() {
    //   if (this.readyState && this.readyState == 'complete') {
    //     ifr.postMessage('ccc', '*');
    //   }
    // }

    let timer = null;
    // 监听是否收到消息
    window.addEventListener('message', e => {
      if(e.data == 'received') {
        clearInterval(timer);
      }
    }, false);
    // 发送消息
    timer = setInterval(() => {
      ifr && ifr.postMessage(JSON.stringify(baseInfo), origin);
      // ifr.postMessage(JSON.stringify(this.props.companyInfo), origin);
      // ifr.postMessage(JSON.stringify(this.props.companyInfo), '*');
    }, 500);
    
  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="课程列表" key="1" />
        </Tabs>
        {this.state.url ? (
          <div style={{ height: "inherit" }}>
            <iframe
              title="课程列表"
              name="coursesList"
              src={this.state.url}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
