
import AppealModal from './AppealModal';
import { qualify_applyAppeal, qualify_trainQualifyApplyCancel, qualify_appealApplyOnDutyCheck } from '../../../../../services/bkt/qualify';
import $modal from '../../../../../utils/modal';
import $nModal from '../../../../../utils/modal/nModal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      width: 150,
      // render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      width: 250,
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '部门',
      dataIndex: 'departName',
      key: 'departName',
      // width: 250,
      render: value => value || '-',
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
            break;
          case value == 3:
            text = '已撤销';
            color = errColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '背景筛查状态',
      dataIndex: 'backgroundStatus',
      key: 'backgroundStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '审核中';
            color = warnColor;
            break;
          case value == 1:
            text = '正常';
            color = okColor;
            break;
          case value == 2:
            color = errColor;
            text = '关注';
            break;
          case value == 3:
            color = okColor;
            text = '申诉通过';
            break;
          case value == 4:
            color = errColor;
            text = '申诉不通过';
            break;
          case value == 5:
            color = warnColor;
            text = '申诉中';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '报名时间',
      dataIndex: 'applyDate',
      key: 'applyDate',
      render: value => value || '-'
    },
    {
      title: '缴费时间',
      dataIndex: 'payDate',
      key: 'payDate',
      render: value => value || '-'
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 250,
      fixed: 'right',
      render: (text, record) => {
        const { personApplyId } = record;
        return (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.setState({
                  personApplyId
                });
              }}
            >
              查看
            </span>
            {/* 申诉 */}
            {_renderAppeal.call(this, record)}
            {/* 撤销 */}
            {_renderCancel.call(this, record)}
          </div>
        );
      }
    }
  ];
}
// 撤销
function _renderCancel(record) {
  const {
    personApplyId,
    applyStatus,
    backgroundStatus,
    fullName,
    examStatus,
  } = record;
  /* 背景筛查中、
             申诉中、
             已安排、
             已撤销、
             申报不通过、
             申报通过
             // 报名时间小于某个时间点
             ->不能撤销 
             */
  if (
    backgroundStatus == '0'
    || backgroundStatus == '5'
    || examStatus == '1'
    || applyStatus == '1'
    || applyStatus == '2'
    || applyStatus == '3'
    // || timeStp > applyDateStp
  ) {
    return '';
  } else {
    return (
      <span
        style={{
          color: '#D9001B',
          cursor: 'pointer'
        }}
        onClick={() => {
          $nModal({
            title: `即将撤销${fullName}的报名记录，是否继续？`,
            content: <div style={{ color: '#F04134' }}>
              <div>撤销须知：</div>
              <div>1、撤销后，该人员将无法继续学习课程。所学的课程学时不会删除，重新报名后，数据会自动关联。</div>
              <div>2、撤销成功后，已缴交的费用将会原路退回您的钱包账户。</div>
              </div>,
            onOk: close => {
              qualify_trainQualifyApplyCancel({ data: { personApplyId } }).then(res => {
                log(res);
                this.props.updateTable();
                close();
                if (res.msg) {
                  $modal(res.msg, '', null, 'success');
                } else {
                  $modal('撤销成功', '', null, 'success');
                }
              }).catch(err=>{
                if (err.retType == '-1') {
                  close();
                  $modal(err.msg, '', null, 'error');
                }
              });
            }
          });
        }}
      >
        撤销
      </span>
    );
  }
}
//申诉
function _renderAppeal(record) {
  // 1、申报状态为申报不通过 
  // 2、背景筛查状态为 关注
  const { applyStatus, backgroundStatus, personApplyId, fullName } = record
  if (applyStatus == '2' && backgroundStatus == '2') {
    return (
      <span
        style={{
          color: '#108EE9',
          cursor: 'pointer',
          marginRight: '15px'
        }}
        onClick={() => {
          qualify_appealApplyOnDutyCheck({ data: { personApplyId } }).then(() => {
            let appealForm = null;
            $nModal({
              width: 800,
              title: `${fullName}-背景筛查申诉`,
              content: <AppealModal
                personApplyId={personApplyId}
                onGetForm={(form) => {
                  appealForm = form;
                }}
              />,
              okText: '确定',
              cancelText: '取消',
              onOk: close => {
                appealForm.validateFields((err, values) => {
                  if (err) return;
                  const { appealContext, appealInfoArr } = values;
                  const appealInfo = appealInfoArr[appealInfoArr.length - 1];
                  const infos = appealInfo ? appealInfo.split(' ') : [];

                  // 没有选完整
                  if (infos[infos.length - 1] == 'false') {
                    return $modal(
                      '请选择具体的申诉机构',
                      ''
                    );
                  }

                  const appealOrgId = infos[0];
                  const appealOrgName = infos[1];
                  const appealOrgAreaCode = infos[2];

                  qualify_applyAppeal({ data: { personApplyId, appealContext, appealOrgId, appealOrgName, appealOrgAreaCode } }).then(res => {
                    this.props.updateTable();
                    close();
                    $modal('提交成功！', '请等待公安人员进行审核，审核状态可刷新页面查看。', null, 'success');
                  });
                });
              }
            });
          });
        }}
      >
        申诉
      </span>
    )
  } else {
    return ''
  }
}

