import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");
const { TabPane } = Tabs;

export default class ExamArrange extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // url: 'http://localhost:3000/#/exam/plan?systype=saas&sessionId=DBBC28EB7CF071B24A9C1EDCE5B3D1DE664224FAF27BE7A6220C0F550F42E02371E94A38B3E9554B382EA76443A62F559F8D52D66E604EAB74F7C3AD22C5712A&areaCode=110100'
    };
  }
  componentDidMount = () => {
  }
  render() {
    return (
      <Container>
        <Tabs defaultActiveKey="1">
          <TabPane tab="资格证考试安排" key="1" />
        </Tabs>
        {store.get("ExamArrangeURL") !== undefined ? (
          <div style={{ height: "inherit" }}>
            <iframe title="考试安排"
              src={store.get("ExamArrangeURL")["ExamArrangeURL"]}
              // src={this.state.url}
              width="100%"
              height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }
        {/*{store.get("ExamArrangeURL") !== undefined ? (
              <iframe title="考试安排" src={store.get("ExamArrangeURL")["ExamArrangeURL"]} width="100%" height="100%" frameBorder="0">
                您的浏览器不支持iframe，请升级
            </iframe>
            ) : ''
            }*/}
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
