
// import style from "styled-components";
import { Popover, Icon } from 'antd';
import { trainGradeCancelClass } from '../../../../services/bkt/apis';
// import $modal from '../../../../utils/modal';

const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-'
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      render: value => value || '-'
    },
    {
      title: '是否补考',
      dataIndex: 'isMakeUp',
      key: 'isMakeUp',
      render: value => value=='1'?'是' : '否'
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
            break;
          case value == 3:
            text = '已撤销';
            color = errColor;
            break;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '背景筛查状态',
      dataIndex: 'backgroundStatus',
      key: 'backgroundStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '审核中';
            color = warnColor;
            break;
          case value == 1:
            text = '正常';
            color = okColor;
            break;
          case value == 2:
            color = errColor;
            text = '关注';
            break;
          case value == 3:
            color = okColor;
            text = '申诉通过';
            break;
          case value == 4:
            color = errColor;
            text = '申诉不通过';
            break;
          case value == 5:
            color = warnColor;
            text = '申诉中';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    // {
    //   title: '缴费状态',
    //   dataIndex: 'orderStatus',
    //   key: 'orderStatus',
    //   render: (value) => {
    //     let text = '未缴费';
    //     let color = '';
    //     switch (true) {
    //       case value == 0:
    //         color = errColor;
    //         text = '未缴费';
    //         break;
    //       case value == 1:
    //         color = okColor;
    //         text = '已缴费';
    //     }
    //     return (
    //       <span style={{ color }}>{text}</span>
    //     );
    //   }
    // },
    {
      title: '材料核对状态',
      dataIndex: 'materialApproveStatus',
      key: 'materialApproveStatus',
      render: (value) => {
        let text = '未核对';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未核对';
            break;
          case value == 1:
            color = okColor;
            text = '核对通过';
            break;
          case value == 2:
            color = errColor;
            text = '核对不通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    }, 
    {
      title: '核对人',
      dataIndex: 'materialApprovePerName',
      key: 'materialApprovePerName',
      render: (value, record) => {
        let name = '-'
        if(record.materialApprovePerName){
          name = record.materialApprovePerName
          if(record.materialApprovePerIdCardNo){
            name+='('+record.materialApprovePerIdCardNo+')'
          }
        }
        return <span>{name}</span>
      }
    },
    {
      title: '核对时间',
      dataIndex: 'materialApproveDate',
      key: 'materialApproveDate',
      render: value => value || '-'
    },
    // {
    //   // title: '报名比对状态',
    //   title: (
    //     <Popover title={<div style={{
    //       padding: '5px 16px',
    //       margin: '-5px -16px',
    //       background: '#f5f5f5',
    //       fontSize: 15,
    //       fontWeight: 'bold'
    //     }}>状态说明</div>} content={
    //       <section style={{padding: 10}}>
    //         材料审核通过后公安将进行人员的报名比对。报名比对结果不影响等级证考试流程。有四种状态：
    //         <p style={{marginTop: 15}}>
    //           <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>待比对：</span>未比对的学员或比对后再提交修改的学员。</span><br />
    //           <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>可申请：</span>比对通过的学员。</span><br />
    //           <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>可修改：</span>比对不通过但部分信息可再修改重新比对，修改后状态变为待比对。</span><br />
    //           <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>不可申请：</span>比对不通过的学员。该状态的学员将不能申请补贴。培训学校需自行联系保安公司确认是否要撤销或缴交费用。</span><br />
    //         </p>
    //       </section>
    //     }>
    //       <span style={{cursor: 'pointer'}}>报名比对状态<Icon style={{marginLeft: 3}} type="question-circle" /></span>
    //     </Popover>
    //   ),
    //   dataIndex: 'compareStatus',
    //   key: 'compareStatus',
    //   render: (value, record) => {
    //     let text = '-';
    //     let color = '';
    //     switch (true) {
    //       case value == '0':
    //         color = warnColor;
    //         text = '待比对';
    //         break;
    //       case value == '1':
    //         color = okColor;
    //         text = '可申请';
    //         break;
    //       case value == '2':
    //         color = errColor;
    //         text = '不可申请';
    //         break;
    //       case value == '3':
    //         color = errColor;
    //         text = '可修改';
    //         break;
    //     }
    //     if (value == '2' && record) {
    //       return (
    //         <Popover placement="topLeft" content={
    //           <div style={{padding: 10}}>{record.compareFailReason}</div>
    //         }>
    //           <span style={{ color, cursor: 'pointer' }}>{text}</span>
    //         </Popover>
    //       );
    //     } else {
    //       return (
    //         <span style={{ color }}>{text}</span>
    //       );
    //     }
    //   }
    // },
    {
      // title: '补贴比对状态',
      title: (
        <Popover 
        title={<div style={{
          padding: '5px 16px',
          margin: '-5px -16px',
          background: '#f5f5f5',
          fontSize: 15,
          fontWeight: 'bold'
        }}>状态说明</div>}
         content={
          <section style={{padding: 10, cursor: 'pointer'}}>
            成绩确认后公安将进行人员的补贴比对。只有“可申请”的学员才能申请补贴。有四种状态：
            <p style={{padding: 10}}>
              <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>待比对：</span>未比对的学员或比对后信息再修改的学员。</span><br />
              <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>可申请：</span>比对通过的学员。</span><br />
              <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>可修改：</span>比对不通过但部分信息可再修改重新比对，修改后状态变为待比对。</span><br />
              <span><span style={{display:'inline-block', width: 72, textAlign: 'right'}}>不可申请：</span>比对不通过的学员。该状态的学员将不能申请补贴。</span><br />
            </p>
          </section>
        }>
          <span style={{cursor: 'pointer'}}>补贴比对状态<Icon style={{marginLeft: 3}} type="question-circle" /></span>
        </Popover>
      ),
      dataIndex: 'bonusCompareStatus',
      key: 'bonusCompareStatus',
      render: (value, record) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            color = warnColor;
            text = '待比对';
            break;
          case value == '1':
            color = okColor;
            text = '可申请';
            break;
          case value == '2':
            color = errColor;
            text = '不可申请';
            break;
          case value == '3':
            color = errColor;
            text = '可修改';
            break;
        }
        if (value == '2' && record) {
          return (
          <Popover placement="topLeft" content={<div style={{padding: 10}}>{record.bonusCompareFailReason}</div>}>
              <span style={{ color, cursor: 'pointer' }}>{text}</span>
            </Popover>
          );
        } else {
          return (
            <span style={{ color}}>{text}</span>
          );
        }
      }
    },
    {
      title: '开班状态',
      dataIndex: 'classOpenStatus',
      key: 'classOpenStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未开班';
            break;
          case value == 1:
            color = okColor;
            text = '已开班';
            break;
          default:
            text = '未开班';
            color = warnColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '结业考试状态',
      dataIndex: 'graduateTestState',
      key: 'graduateTestState',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未通过';
            break;
          case value == 1:
            color = okColor;
            text = '已通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '鉴定考试状态',
      dataIndex: 'identifyTestState',
      key: 'identifyTestState',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未通过';
            break;
          case value == 1:
            color = okColor;
            text = '已通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '理论学习进度',
      dataIndex: 'progress',
      key: 'progress',
      render: value => {
        if (value) {
          return value + '%';
        } else {
          return '0%'
        }
      }
    },
    {
      title: '实习状态',
      dataIndex: 'internStatus',
      key: 'internStatus',
      render: (value) => {
        let text = '未实习';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '实习中';
            break;
          case value == 1:
            color = okColor;
            text = '已完成';
            break;
          // case value == 2:
          //   color = okColor;
          //   text = '已完成';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '协会审查结果',
      dataIndex: 'checkStatus',
      key: 'checkStatus',
      render: (value) => {
        let text = '-';
        switch (true) {
          case value == '0':
            text = '未审核';
            break;
          case value == '1':
            text = '合格';
            break;
          case value == '2':
            text = '不合格';
            break;
          case value == '3':
            text = '已更新';
            break;
          case value == '4':
            text = '已审核';
            break;
        }
        return (
          <span>{text}</span>
        );
      }
    },
    {
      title: '报名保安公司',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    {
      title: '报名时间',
      dataIndex: 'applyDate',
      key: 'applyDate',
      render: value => value || '-'
    },
    {
      title: '培训机构名称',
      dataIndex: 'organName',
      key: 'organName',
      render: value => value || '-'
    },
    {
      title: '缴费时间',
      dataIndex: 'payDate',
      key: 'payDate',
      render: value => value || '-'
    },
    {
      title: '开班名称',
      dataIndex: 'className',
      key: 'className',
      render: value => value || '-'
    },
    {
      title: '实操培训开班时间',
      dataIndex: 'particeStartDate',
      key: 'particeStartDate',
      render: (value, record) => {
        const { practiceStartDate, practiceEndDate } = record;
        if (!!practiceStartDate) {
          return `${practiceStartDate}~${practiceEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '实习天数',
      dataIndex: 'internDayTotal',
      key: 'internDayTotal',
      render: value => value || '0'
    },
    {
      title: '实习时长',
      dataIndex: 'internHourTotal',
      key: 'internHourTotal',
      render: value => {
        if (value) {
          return (value / 1).toFixed(1);
        } else {
          return '0';
        }
      }
    },
    {
      title: '结业-理论成绩',
      dataIndex: 'graduateComputerScore',
      key: 'graduateComputerScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '结业-实操成绩',
      dataIndex: 'graduatePracticeScore',
      key: 'graduatePracticeScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },

    {
      title: '鉴定-理论成绩',
      dataIndex: 'identifyComputerScore',
      key: 'identifyComputerScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '鉴定-实操成绩',
      dataIndex: 'identifyPracticeScore',
      key: 'identifyPracticeScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    // {
    //   title: '手机号码',
    //   dataIndex: 'mobile',
    //   key: 'mobile',
    //   render: value => value || '-'
    // },
    // {
    //   title: '公安处理意见',
    //   dataIndex: 'policeResponse',
    //   key: 'policeResponse',
    //   render: value => {
    //     return value || '-';
    //   }
    // },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      fixed: 'right',
      width: 120,
      render: (text, record) => {
        const { materialApproveStatus, personApplyId } = record;
        return (
          <a onClick={() => {
            this.setState({
              personApplyId
            });
          }}>{materialApproveStatus == '0' ? '核对处理' : '查看'}</a>
          // <Container>
          //   {
          //     materialApproveStatus == '0' &&
          //     <a onClick={() => {
          //       this.setState({
          //         personApplyId
          //       });
          //     }}>核对处理</a>
          //   }
          //   {
          //     materialApproveStatus != '0' &&
          //     <a onClick={() => {
          //       this.setState({
          //         personApplyId
          //       });
          //     }}>查看</a>
          //   }

          // </Container>
        );
      }
    }
  ];
}

// const Container = style.div`
//   a{
//     margin-left: 10px;
//     &:first-child{
//       margin-left: 0;
//     }
//   }
// `;
