const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 60,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      // render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
    },
    {
      title: '现职企业',
      dataIndex: 'learnName',
      key: 'learnName',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '课程',
      dataIndex: 'trackName',
      key: 'trackName',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '认证章节',
      dataIndex: 'trackTitle',
      key: 'trackTitle',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '认证结果',
      dataIndex: 'authStatus',
      key: 'authStatus',
      render:(text,record)=>{
        let param ='-'
        let color =''
        switch (true) {
          case text == 0:
            color = warnColor;
            param = '认证失败';
            break;
          case text == 1:
            color = okColor;
            param = '认证成功';
        }
        return (
        <span style={{color}}>{param}</span>
        )
      }
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    {
      title: '认证时间',
      dataIndex: 'creationDate',
      key: 'creationDate',
      // render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
    },
    // {
    //   title: '操作',
    //   dataIndex: 'operation',
    //   key: 'operation',
    //   width: 130,
    //   fixed: 'right',
    //   render: (text, record) => {
    //     const { personApplyId, materialApproveStatus } = record;
    //     return (
    //       <div>
    //         <span
    //           style={{
    //             color: '#108EE9',
    //             cursor: 'pointer',
    //             marginRight: '20px'
    //           }}
    //           onClick={() => {
    //             this.setState({
    //               personApplyId
    //             });
    //           }}
    //         >
    //           {materialApproveStatus == '0' ? '核对处理' : '查看'}
    //           {/* 查看 */}
    //         </span>
    //       </div>
    //     );
    //   }
    // }
  ];
}