
import style from "styled-components";
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function() {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 100,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      render: value => value || '-'
    },
    {
      title: '所属公司',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      render: value => value || '-'
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      render: value => value || '-'
    },
    {
      title: '是否补考',
      dataIndex: 'isMakeUp',
      key: 'isMakeUp',
      render: value => value=='1'?'是' : '否'
    },
    {
      title: '课程学习进度',
      dataIndex: 'progress',
      key: 'progress',
      render: value => {
        return value + '%';
      }
    },
    {
      title: '实习状态',
      dataIndex: 'internStatus',
      key: 'internStatus',
      render: value => {
        let text = '未实习';
        let color = '';
        switch (true) {
          case value == '0':
            text = '实习中';
            color = warnColor;
            break;
          case value == '1':
            text = '实习完成';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    
    {
      title: '实习天数',
      dataIndex: 'internDayTotal',
      key: 'internDayTotal',
      render: value => value || '0'
    },
    {
      title: '实习时长',
      dataIndex: 'internHourTotal',
      key: 'internHourTotal',
      render: value => {
        if(value) {
          return (value/1).toFixed(1);
        }else {
          return '0';
        }
      }
    },
    {
      title: '实操培训通知',
      dataIndex: 'classNoticeState',
      key: 'classNoticeState',
      render: value => {
        let text = '未发送';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未发送';
            color = errColor;
            break;
          case value == '1':
            text = '已发送';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '结业考试通知',
      dataIndex: 'graduateNoticeState',
      key: 'graduateNoticeState',
      render: value => {
        let text = '未发送';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未发送';
            color = errColor;
            break;
          case value == '1':
            text = '已发送';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '鉴定考试通知',
      dataIndex: 'identifyNoticeState',
      key: 'identifyNoticeState',
      render: value => {
        let text = '未发送';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未发送';
            color = errColor;
            break;
          case value == '1':
            text = '已发送';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '结业考试结果',
      dataIndex: 'graduateTestState',
      key: 'graduateTestState',
      render: value => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            text = '不合格';
            color = errColor;
            break;
          case value == '1':
            text = '合格';
            color = okColor;
            break;
          default:
            text = '未考试';
            color = '';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '结业理论分数',
      dataIndex: 'graduateComputerScore',
      key: 'graduateComputerScore',
      render: value => {
        if(value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '结业实操分数',
      dataIndex: 'graduatePracticeScore',
      key: 'graduatePracticeScore',
      render: value => {
        if(value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '鉴定考试结果',
      dataIndex: 'identifyTestState',
      key: 'identifyTestState',
      render: value => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            text = '不合格';
            color = errColor;
            break;
          case value == '1':
            text = '合格';
            color = okColor;
            break;
          default:
            text = '未考试';
            color = '';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '鉴定理论分数',
      dataIndex: 'identifyComputerScore',
      key: 'identifyComputerScore',
      render: value => {
        if(value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '鉴定实操分数',
      dataIndex: 'identifyPracticeScore',
      key: 'identifyPracticeScore',
      render: value => {
        if(value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 100,
      fixed: 'right',
      render: (text, record) => {
        // 待审核 已确认
        if(
          this.props.classStatus == 0 || 
          this.props.scoreState == '1'
          ) {
          return <span style={{color: '#ddd'}}>编辑</span>;
        }
        return (
          <Btns>
            <a onClick={() => {
              this.setState({
                currentPernson: record
              });              
            }}>编辑</a>
          </Btns>
        );
      }
    }
  ];
}

const Btns = style.div`
  a{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
