import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
} from "antd";
import st from 'styled-components';
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props) {
    super(props);
    this.state = {
    }
  }
  componentDidMount() {
    this.props.onSearch(this.props.form.getFieldsValue());
  }

  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}> 
        {/* <FlexBox>
          <div>
        </div> */}
          <Form.Item style={{marginTop: 10}} label="关键词">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input style={{minWidth: 250}} placeholder="请输入学员名称/身份证号/手机号码" />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="报名保安公司">
          {getFieldDecorator('learnName', {
            initialValue: ''
          })(
            <Input style={{minWidth: 250}} placeholder="请输入报名保安公司" />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="是否补考">
          {getFieldDecorator('isMakeUp', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">否</Option>
              <Option value="1">是</Option>
            </Select>
          )}
        </Form.Item>
        {/* <Form.Item style={{marginTop: 10}} label="实习状态">
          {getFieldDecorator('internStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="-1">未实习</Option>
              <Option value="0">实习中</Option>
              <Option value="1">实习完成</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="课程学习状态">
          {getFieldDecorator('trackLearnStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="0">未完成</Option>
              <Option value="1">已完成</Option>
            </Select>
          )}
        </Form.Item> */}
        {/* <br /> */}
        <Form.Item style={{marginTop: 10}} label="结业考试结果">
          {getFieldDecorator('graduateTestState', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="-1">未考试</Option>
              <Option value="0">不合格</Option>
              <Option value="1">合格</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="鉴定考试结果">
          {getFieldDecorator('identifyTestState', {
            initialValue: ''
          })(
            <Select style={{minWidth: 150}} >
              <Option value="">全部</Option>
              <Option value="-1">未考试</Option>
              <Option value="0">不合格</Option>
              <Option value="1">合格</Option>
            </Select>
          )}
        </Form.Item>
          {/* btns */}
          <Form.Item style={{marginTop: 10}} label=" " colon={false}>
            <Button type="primary" onClick={this._search}>搜索</Button>
          </Form.Item>
          <Form.Item style={{marginTop: 10}} label=" " colon={false}>
            <Button onClick={this._reset}>重置</Button>
          </Form.Item>
        {/* <Btns>
        </Btns> */}
        {/* </FlexBox> */}
      </Form>
    );
  }
}
const FlexBox = st.div`
  margin-top: 10px;
  display: flex;
  justify-content: space-between;
  >div{
    margin-left: 15px;
    &:first-child{
      margin-left: 0;
    }
  }
`;

const Btns = st.div`
  flex-shrink: 0;
  align-self: flex-end;
`;
