
// import $modal from '../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: '实习日期',
      dataIndex: 'internDate',
      key: 'internDate',
      render: value => value || '-'
    },
    {
      title: '姓名',
      dataIndex: 'fullname',
      key: 'fullname',
      render: value => value || '-'
    },
    {
      title: '手机号码',
      dataIndex: 'mobile',
      key: 'mobile',
      render: value => value || '-'
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      render: value => value || '-'
    },
    {
      title: '实习单位',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    
    {
      title: '保安公司审核状态',
      dataIndex: 'approveStatus',
      key: 'approveStatus',
      render: (value) => {
        let text = '未审核';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未审核';
            break;
          case value == 1:
            color = okColor;
            text = '审核通过';
            break;
          case value == 2:
            color = errColor;
            text = '审核不通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '培训机构审核状态',
      dataIndex: 'trainApproveStatus',
      key: 'trainApproveStatus',
      render: (value) => {
        let text = '未审核';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未审核';
            break;
          case value == 1:
            color = okColor;
            text = '审核通过';
            break;
          case value == 2:
            color = errColor;
            text = '审核不通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    // {
    //   title: '实习记录状态',
    //   dataIndex: 'lineStatus',
    //   key: 'lineStatus',
    //   render: (value) => {
    //     let text = '';
    //     let color = '';
    //     switch (true) {
    //       case value == 0:
    //         color = warnColor;
    //         text = '审核中';
    //         break;
    //       case value == 1:
    //         color = okColor;
    //         text = '有效';
    //         break;
    //       case value == 2:
    //         color = errColor;
    //         text = '无效';
    //         break;
    //       case value == 3:
    //         color = errColor;
    //         text = '作废';
    //     }
    //     if(text) {
    //       return (
    //         <span style={{ color }}>{text}</span>
    //       );
    //     }else {
    //       return '-';
    //     }
    //   }
    // },
    
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      fixed: 'right',
      width: 120,
      render: (text, record) => {
        const { personInternLineId, approveStatus, trainApproveStatus } = record;
        return (
          <a onClick={() => {
            this.setState({
              personInternLineId
            });
          }}>{approveStatus == '1' && trainApproveStatus == '0'?'审核':'查看'}</a>

        );
      }
    }
  ];
}

