import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";

const store = require("store");

const { TabPane } = Tabs;

export default class Comparison extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // currentURL: "http://localhost:3000/#/course/manage",
    };
  }

  componentDidMount = () => {

  }
  render() {
    // const { currentURL } = this.state;
    return (
      <Container>
        <Tabs>
          <TabPane tab="等级证补贴比对人员名单" key="1">
          {store.get("comparison") !== undefined ? (
          <div className="frame_content">
            <iframe
              title="等级证人员比对名单"
              src={store.get("comparison")["comparison"]}
              // width="100%"
              // min-height="100%"
              frameBorder="0"
              // allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }
          </TabPane>
          <TabPane tab="等级证补贴可申请人员名单" key="2">
          {store.get("canComparison") !== undefined ? (
          <div className="frame_content">
            <iframe
              title="等级证人员比对名单"
              src={store.get("canComparison")["canComparison"]}
              // width="100%"
              // height="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true">
              您的浏览器不支持iframe，请升级
            </iframe>
          </div>
        ) : ''
        }
          </TabPane>
        </Tabs>
        
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
  
  .ant-tabs{
    height: 100%;
    // overflow: auto;
  }
  .ant-tabs-content{
    height: 100%;
  }
  .frame_content{
    height: 100%;
    iframe{
      width: 100%;
      height: 100%;
      padding-bottom: 50px;
      min-height: 100%;
      overflow: auto;
    }
  }
`;
