import React, { Component } from 'react';
import { Tabs, Alert, Table, Button, notification, Modal } from 'antd';
const TabPane = Tabs.TabPane;
import * as ajax from '../../../services/api';
import { connect } from 'dva';
import $perModal from '../../../utils/modal/perModal';
@connect(state => ({
  global: state.global
}))
export default class InsuranceDetails extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      listData: [],
      tableSelectedRows: [],
      tableSelectedRowKeys: []
    };
  }
  componentDidMount() {
    this._getList();
  }
  _getList() {
    ajax.comTrainSelectPrincipalByComId({ pageNumber: 1, pageSize: 10 }).then(res => {
      this.setState({
        listData: res.data.data,
        tableSelectedRows: [],
        tableSelectedRowKeys: []
      });
    });
  }
  _removeOfficer(perIds, callBack) {
    ajax.comTrainDelBatchPrincipal({ perIds }).then(res => {
      callBack && callBack(res);
    });
  }
  render() {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '手机号',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone'
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo'
      },
      {
        title: '部门',
        dataIndex: 'departName',
        key: 'departName',
        render: (text, record) => {
          if (record.departName != '') {
            return (<span>{record.departName}</span>);
          } else {
            return (<span>{this.props.global.companyInfo.comName}</span>);
          }
        }
      },
      {
        title: '操作',
        dataIndex: '4',
        render: (text, record) => {
          return (<a href="javascript: void(0);" onClick={() => {
            if (this.state.listData.length <= 1) {
              return notification.error({
                message: '保险负责人不能少于1人'
              });
            }
            Modal.confirm({
              title: `移除保险负责人`,
              content: `确定要移除${record.name}`,
              okText: "确定移除",
              cancelText: '取消',
              onOk: () => {
                const perIds = record.perId;
                this._removeOfficer(perIds, res => {
                  // notification.success({
                  //   message: res.msg
                  // });
                  this._getList();
                });
              }
            });
          }}>移除</a>);
        }
      }
    ];
    const rowSelection = {
      onChange: (tableSelectedRowKeys, tableSelectedRows) => {
        this.setState({
          tableSelectedRows,
          tableSelectedRowKeys
        });
      },
      selectedRowKeys: this.state.tableSelectedRowKeys
    };
    return (
      <Tabs defaultActiveKey="1" style={{ padding: '0 16px' }}>
        <TabPane tab="考培负责人" key="1">
          <Alert style={{ marginBottom: 20 }} message={<div>请您设置考培负责人，报名审核、考试变动、成绩等通知除了通知到具体学员，还将通知到考培负责人，目前仅限3人。<br />

若您需要考培负责人拥有培训模块的操作权限，请到【角色权限】中为其配置菜单权限。</div>} type="warning" showIcon />
          <div style={{ paddingBottom: 15 }}>
            <Button
              type="primary"
              onClick={() => {
                // this.setState({
                //   chargePerVisible: true
                // });
                const { listData } = this.state;
                $perModal({
                  // value: listData.map(({ perId, name }) => {
                  //   return {perId, name};
                  // }),
                  onOk: (values, close) => {
                    if(values.length + listData.length > 3) {
                      return notification.error({
                        message: '保险负责人不能大于3人'
                      });
                    }
                    const perIds = values.map(({perId}) => perId).join(',');
                    ajax.trainComTrainInsertBatchPrincipal({perIds}).then(res => {
                      close();
                      this._getList();
                    });
                  }
                });
              }}
            >添加负责人</Button>
            <Button
              style={{ marginLeft: 15, color: 'red' }}
              onClick={
                () => {
                  if (this.state.tableSelectedRows.length <= 0) {
                    return notification.error({
                      message: '请勾选要移除的人员'
                    });
                  }
                  if (this.state.listData.length - this.state.tableSelectedRows.length < 1) {
                    return notification.error({
                      message: '保险负责人不能少于1人'
                    });
                  }
                  Modal.confirm({
                    title: `移除保险负责人`,
                    content: `确定要删除选中的${this.state.tableSelectedRows.length}人`,
                    okText: "确定移除",
                    cancelText: '取消',
                    onOk: () => {
                      const perIds = this.state.tableSelectedRows.reduce((a, b) => {
                        return a + b.perId + ',';
                      }, '').slice(0, -1);
                      this._removeOfficer(perIds, res => {
                        // notification.success({
                        //   message: res.msg
                        // });
                        this._getList();
                      });
                    }
                  });
                }
              }
            >批量移除</Button>
          </div>
          <Table rowSelection={rowSelection} columns={columns} dataSource={this.state.listData} />

        </TabPane>
      </Tabs>
    );
  }
}
