import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Cascader,
  Select
} from "antd";
import {
  // taskTreeTaskType
} from '../../../services/api';
import PSelect from '../../../components/Pro/PSelect';
import PCascader from '../../../components/Pro/PCascader';
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // cascaderOptions: [], //驻勤级联数据
    };
  }
  componentDidMount() {
    // this.__taskTreeTaskType();
    this.props.onSearch(this.props.form.getFieldsValue());
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      this.props.onSearch(values);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
  }
  // __taskTreeTaskType = () => {
  //   taskTreeTaskType().then(
  //     ({ data = [] }) => {
  //       let newData = JSON.stringify(data);
  //       newData = newData.replace(/bigKey/g, 'key');
  //       newData = newData.replace(/bigValue/g, 'value');
  //       newData = newData.replace(/value/g, 'label');
  //       newData = newData.replace(/key/g, 'value');
  //       newData = JSON.parse(newData);
  //       this.setState({ cascaderOptions: newData });
  //     },
  //     err => {
  //       console.log(err);
  //     }
  //   );
  // };
  render() {
    const { getFieldDecorator } = this.props.form;
    // const { cascaderOptions } = this.state;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="驻勤名称">
          {getFieldDecorator('taskName', {
            initialValue: ''
          })(
            <Input placeholder="请输入" />
          )}
        </Form.Item>
        {/* <Form.Item label="驻勤状态">
          {getFieldDecorator('taskStatus')(
            <PSelect
              type='taskStatus'
              style={{
                width: 174
              }}
              addOption
            />
          )}
        </Form.Item> */}

        <Form.Item label="驻勤状态"> 
          {getFieldDecorator('taskEffect',{
            initialValue: ''
          })(
            <Select style={{minWidth: 200}} >
              <Option value="">全部</Option>
              <Option value="0">未生效</Option>
              <Option value="1">生效</Option>
              <Option value="2">终止</Option>
            </Select>
          )}
        </Form.Item>
        {/* <Form.Item label="驻勤点类型">
          {getFieldDecorator("taskStationType", {
            initialValue: '',
          })(
            <PSelect
              type='taskStationType'
              style={{
                width: 174
              }}
              addOption
            />
          )}
        </Form.Item> */}
        {/* <Form.Item label="驻勤类型">
          {getFieldDecorator('taskType')(
            <Cascader options={cascaderOptions} placeholder='请输入' />
          )}

        </Form.Item> */}
        <Form.Item label="驻勤地区">
          {getFieldDecorator('taskAddress')(
            <PCascader placeholder='请选择' />
          )}
        </Form.Item>
        <Form.Item label="是否关联合同"> 
          {getFieldDecorator('isRelationContract',{
            initialValue: ''
          })(
            <Select style={{minWidth: 200}} >
              <Option value="">全部</Option>
              <Option value="0">否</Option>
              <Option value="1">是</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label="到期预警"> 
          {getFieldDecorator('expiredMonth',{
            initialValue: ''
          })(
            <Select style={{ width: 240 }} >
              <Option value="">全部</Option>
              <Option value="1">近一个月到期</Option>
              <Option value="2">近两个月到期</Option>
              <Option value="3">近三个月到期</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>

      </Form>
    );
  }
}
