import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from "dva/router";
import PTable from "../../../components/Pro/PTable";
import SearchForm from "./SearchForm";
import columnsFun from "./columns";
import ExcelButtonOline from "../../../components/ExcelButtonOline";
import { Alert, Tabs, Popover } from "antd";
const { TabPane } = Tabs;
@connect((state) => ({
  global: state.global,
}))
@withRouter
export default class PersonSearch extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: {
        //任务列表请求参数
        pageSize: "10",
        pageNumber: "1",
      },
      paramsInit: false, //参数是否准备好
    };
  }

  componentWillReceiveProps(props) {}
  componentDidMount() {}
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values,
        departIds: values.departIds ? values.departIds : "",
      },
      paramsInit: true,
    });
  };

  _updateTable = () => {
    this.setState(
      {
        forceUpdate: true,
      },
      () => {
        this.setState({
          forceUpdate: false,
        });
      }
    );
  };
  render() {
    const columns = columnsFun.call(this);
    return (
      <div style={{ padding: "0 20px" }}>
        <Tabs>
          <TabPane tab="驻勤人员查询" key="1" />
        </Tabs>
        <Alert
          message={
            <div>
              <span>本页面可查询企业内所有人员实时安排驻勤点的情况。</span>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "15px" }}
        />
        <SearchForm style={{ marginLeft: 10 }} onSearch={this._search} />
        <Popover
          content={(() => {
            return <p style={{ padding: 10 }}>搜索后可导出搜索结果</p>;
          })()}
          title="温馨提示："
        >
          <ExcelButtonOline
            style={{ marginLeft: "15px" }}
            params={this.state.pageParm}
            apiurl={"/system/per-base-info/export-per-task-info"}
            downloadname={"驻勤人员信息"}
          >
            导出检索结果
          </ExcelButtonOline>
        </Popover>
        {this.state.paramsInit && (
          <PTable
            scroll={{ x: 1600 }}
            style={{ marginTop: 20 }}
            columns={columns}
            url="pagePerTaskInfo"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{ showTotal: (total) => `总共 ${total} 条` }}
          />
        )}
      </div>
    );
  }
}
