import React, {PureComponent} from 'react';
// import { connect } from 'dva';
import style from "styled-components";
import {Steps} from 'antd';
import Createtaskinformation from './CreateTask/CreateTaskInformation';//创建驻勤-基本信息
import CreateTaskAttendance from './CreateTask/CreateTaskAttendance';//创建驻勤-出勤设置
import SecondStep from './SecondStep';//创建驻勤-出勤设置
import CreatePublish from './CreateTask/CreatePublish';//创建驻勤-出勤设置
import {gup} from '../../utils/utils';
import {Breadcrumb} from 'antd';
import {Link} from "dva/router";
import bcx_utils from "../../common/bcx_utils";

const {Step} = Steps;

/**
 * 配置角色及权限
 */
export default class NewTask extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      cursor: 0,//当前显示页面位置
      comInfo: {comTaskId: ""},
    };

  }

  /******************************生命周期******************************/

  componentWillMount = () => {
    if (!gup("id")) {
      return;
    }
    this.getComInfo({comTaskId: gup("id")});
  }
  getComInfo = (comInfo) => {
    if (comInfo) {
      this.setState({comInfo});
    }
  }
  //切换步骤
  switchStep = (step = 0, comTaskId, taskStatus='') => {
    if (comTaskId) {
      const comInfo = this.state.comInfo;
      comInfo.comTaskId = comTaskId;
      if(taskStatus!==''){
        comInfo.taskStatus = taskStatus;
      }
      this.setState({comInfo});
    }
    this.setState(({cursor}) => ({
      cursor: cursor + step
    }));
  }
  /******************************ajax请求******************************/


  /******************************相关事件******************************/


  /******************************render******************************/

  render() {
    const {cursor, firstStepData, secondStepData, comInfo} = this.state;

    const Container = {
      0: Createtaskinformation,
      1: SecondStep,
      2: CreatePublish,
    };

    return (
      // 每次只加载一个模块
      <div>
        <Breadcrumb style={{margin: 20}}>
          <Breadcrumb.Item>
            <Link to="/taskmanager/tasklist">
              驻勤列表
            </Link>
          </Breadcrumb.Item>
          <Breadcrumb.Item>创建驻勤流程</Breadcrumb.Item>
        </Breadcrumb>
        {
          React.createElement(
            Container[cursor],
            // Container[2],
            {
              switchStep: this.switchStep,
              history: this.props.history,
              dataSource: comInfo,
            },
          )
        }
      </div>
    );
  }
}
