import React, { Component } from 'react';
import { connect } from 'dva';
import moment from 'moment';
import "moment/locale/zh-cn";
import {
  Form, Input, Timeline, Row, Button, Checkbox, Icon, Table, InputNumber, TimePicker, Modal
} from 'antd';
import Drawer from 'react-motion-drawer';

import { enterpriseCompanyComBaseInfoGetComBaseInfoById } from "../../services/api";

import './Task.less';

const FormItem = Form.Item;
const { confirm } = Modal;
const format = 'HH:mm';

const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 },
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 10 },
  },
};


@connect(state => ({
  profile: state.profile,
}))


@Form.create()

export default class CreateThiftManagement extends Component {

  state = {
    open3: false,//新增班次
    visible: false,//添加地点
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0,
    }
  }

  componentDidMount() {
    // window.initialize = this.initializeMap;
  }



  columns = [{
    title: '班次名称',
    dataIndex: 'a',
    key: '1',
  }, {
    title: '班次类型',
    dataIndex: 'b',
    key: '2',
  }, {
    title: '考勤时间安排',
    dataIndex: 'c',
    key: '3',
    render: (text) => {
      return <div>{text}</div>;
    }
  }, {
    title: '操作',
    dataIndex: 'd',
    key: '4',
    render: () => {
      return (<div style={{ color: "rgba(15,113,255,1)" }}>
        <span onClick={() => {
          confirm({
            content: <div>删除的班次不可恢复！确认删除和"<em style={{ color: "#F5222E" }}>班次名称</em>"</div>,
            onOk() {
              console.log('OK');
            },
            onCancel() {
              console.log('Cancel');
            },
          });
        }} style={{ marginRight: 8 }}>删除</span>
        <span onClick={() => {
          this.setState({ open3: true });
        }}>编辑</span>
      </div>);
    }
  }];
  dataSource = [{
    key: 1,
    a: '保安三班倒班次保安三班倒班次保',
    b: '驻勤班次',
    c: "09:00 - 11:00  |  12:00 - 14:00  |  15:00-18:00",
    d: '编辑|删除'
  }, {
    key: 2,
    a: '保安三班倒班次保安三班倒班次保',
    b: '驻勤班次',
    c: "09:00 - 11:00  |  12:00 - 14:00  |  15:00-18:00",
    d: '编辑|删除'
  }, {
    key: 3,
    a: '保安三班倒班次保安三班倒班次保',
    b: '驻勤班次',
    c: "09:00 - 11:00  |  12:00 - 14:00  |  15:00-18:00",
    d: '编辑|删除'
  }];


  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="CreateTask CreateThiftManagement">
        <div className="bz-title">驻勤班次管理</div>
        <Button onClick={() => {
          this.setState({ open3: true });
        }} className="new-btn" type="primary">新增班次</Button>
        <Table pagination={this.state.pagenav} dataSource={this.dataSource} columns={this.columns} />
        {/*  选择班次--新增班次 */}
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open3}
          noTouchClose
          width={600}
          className="drawer-box"
          zIndex={2}
          onChange={(open3) => {
            this.setState({ open3 });
          }}
        >
          <div className="drawer task-drawer">
            <div className="drawer-header">
              新增班次
            </div>
            <div className="drawer-content">
              <Form
                onSubmit={this.handleSubmit}
                style={{ marginTop: 24 }}
              >
                <FormItem
                  {...formItemLayout}
                  label="班次名称"
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Input />
                    )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="一天上下班冷饮数"
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Input addonAfter="次" />
                    )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  label="第一轮班次"
                  style={{ marginBottom: 0 }}
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Timeline>
                      <Timeline.Item color="green">上班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} /></Timeline.Item>
                      <Timeline.Item color="orange">下班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} /></Timeline.Item>
                    </Timeline>
                    )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  style={{ marginBottom: 0 }}
                  label="第二轮班次"
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Timeline>
                      <Timeline.Item color="green">上班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} /></Timeline.Item>
                      <Timeline.Item color="orange">下班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} /></Timeline.Item>
                    </Timeline>
                    )}
                </FormItem>
                <FormItem
                  {...formItemLayout}
                  style={{ marginBottom: 0 }}
                  label="第三轮班次"
                  help={<div className="help">合计工作时长<span>21</span>小时<span>00</span></div>}
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Timeline style={{ marginBottom: 0 }} >
                      <Timeline.Item color="green">上班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} /></Timeline.Item>
                      <Timeline.Item color="orange">下班：<TimePicker className="task-TimePicker" defaultValue={moment('12:08', format)} format={format} />
                        <span style={{ position: "absolute", right: 0, top: 4, marginRight: -40, color: "#F5222E" }}>次日</span></Timeline.Item>
                    </Timeline>
                    )}
                </FormItem>
                <div style={{ borderBottom: "1px solid#E9E9E9", margin: '24px' }} />
                <FormItem
                  {...{
                    labelCol: {
                      xs: { span: 24 },
                      sm: { span: 7 },
                    },
                    wrapperCol: {
                      xs: { span: 24 },
                      sm: { span: 12 },
                      md: { span: 16 },
                    },
                  }}
                  label="附加设置"
                >
                  {getFieldDecorator('address', {
                    rules: [{ required: true, message: '请输入' }],
                  })(
                    <Checkbox.Group onChange={(e) => {
                      console.log(e);
                    }}
                    >
                      <Row style={{ marginBottom: 24 }}> <Checkbox value="A">允许迟到</Checkbox><InputNumber style={{ width: 88 }} min={1} max={10} defaultValue={3} />分钟</Row>
                      <Row style={{ marginBottom: 24 }}> <Checkbox value="A">迟到超过</Checkbox><InputNumber style={{ width: 88 }} min={1} max={10} defaultValue={3} />分钟 <span style={{ color: "#FFAA00" }}>(视为严重迟到)</span></Row>
                      <Row style={{ marginBottom: 24 }}> <Checkbox value="A">迟到超过</Checkbox><InputNumber style={{ width: 88 }} min={1} max={10} defaultValue={3} />分钟<span style={{ color: "#F5222E" }}>(视为旷工)</span></Row>
                    </Checkbox.Group>
                    )}
                </FormItem>
              </Form>
            </div>
            <div className="drawer-footer">
              <Button onClick={() => {
                this.setState({ open3: false });
              }} >取消</Button>
              <Button onClick={() => {
                this.setState({ visible: true });
              }} type="primary">修改班次</Button>
            </div>
          </div>
        </Drawer >

        <Modal
          title="选择班次生效时间"
          visible={this.state.visible}
          okText="立即生效"
          cancelText="明日生效"
          onOk={() => { this.setState({ visible: false }); }}
          onCancel={() => { this.setState({ visible: false }); }}
          wrapClassName="thiftModal"
        >
          <Icon type="exclamation-circle" />若选择“立即生效”，今天相关的驻勤记录会重新核算！
        </Modal>

      </div >
    );
  }
}

