import React, { Component } from 'react';
import {
  Form,
  Input,
  Select,
  Timeline,
  Row,
  Col,
  Button,
  Radio,
  Steps,
  Checkbox,
  Icon,
  Table,
  InputNumber,
  TimePicker,
  Modal,
  message
} from 'antd';
import Drawer from 'react-motion-drawer';
import AddNewShift from '../AddNewShift';
import SetLocation from './SetLocation';
import bcx_utils from '../../../common/bcx_utils';
import '../Task.less';
import {
  formItemLayout,
  submitFormLayout,
  formItemLayout1,
  returnComTaskFixedDList
} from './Constants';
import PLoading from '../../../components/Pro/PLoading';
import PZhezhao from '../../../components/Pro/PZhezhao';
import DrawCircleForm from './DrawCircleForm';
import style from 'styled-components';

const FormItem = Form.Item;
const { Option } = Select;
const { Step } = Steps;
const format = 'HH:mm';

import {
  enterpriseCompanyComBaseInfoGetComBaseInfoById,
  taskGetStepTwoDetail,
  taskComShiftPage,
  taskSaveStepTwoDetail
} from '../../../services/api';

@Form.create()
export default class CreateTaskAttendance extends Component {
  state = {
    open: false, //  固定班次----添加班次
    open1: false, // 排班次----添加班次
    open2: false, // 排班次----添加排班周期
    open3: false, // 固定班次/排班次----新增班次
    visible: false, //添加地点

    gdbzDataSource: {
      returnComTaskFixedDList, //默认休息 初始化值
      returnComTaskAttendAddressList: []
    }, //固定班制 详情
    pbzDataSource: {
      comShifts: [], //出勤班次
      returnComTaskSchedulCycleList: [], //周期设置
      returnComTaskAttendAddressList: [] //地址列表
    }, //排班制 详情
    pbzDataSourceCache: {
      comShifts: [],
      returnComTaskSchedulCycleList: [],
      returnComTaskAttendAddressList: []
    },
    taskComShiftData: [], //所有班次信息

    cursor: 0, //选择要修改的出勤班次 游标位置

    addressRange: '0' //出勤范围
  };

  componentWillMount = () => {};
  componentDidMount() {
    this.props.form.setFieldsValue({ attendType: '1' });

    this.taskComShiftPage(); //请求所有班次
    this.init();
  }

  init = () => {
    console.log('-----------------进入修改模式-----------------');

    const { dataSource } = this.props;

    const { attendType = '1' } = dataSource;

    console.log(attendType);
    this.props.form.setFieldsValue({ attendType });

    const { PBZ, GDBZ } = dataSource;

    //设置排班制或者固定班制
    if (PBZ !== '') {
      this.setState({
        pbzDataSource: PBZ,
        pbzDataSourceCache: bcx_utils.jsoncopy(PBZ)
      });
    }
    if (GDBZ !== '') {
      this.setState({ gdbzDataSource: GDBZ });
    }
  };

  //获取班次分页查询O
  taskComShiftPage = () => {
    taskComShiftPage({ pageSize: 5000, pageNumber: 1 }).then(
      ({ data: { data = [] } }) => {
        console.log(data, 'taskComShiftPage-获取班次分页查询-response');
        this.setState({ taskComShiftData: data });
      },
      err => {
        console.log(err, 'taskComShiftPage-获取班次分页查询-err');
      }
    );
  };
  //页面提交信息
  handleSubmit = e => {
    e.preventDefault();
    const { attendType } = this.props.form.getFieldsValue();
    const { gdbzDataSource, pbzDataSource, addressRange } = this.state;
    const comTaskId = '425611535864299520';
    //批量修改 考勤范围
    const changeAddress = arr => {
      return arr.map(val => ({ ...val, ...{ addressRange } }));
    };
    //消息提示
    const messageTip = (title, resolve) => {
      message.error(title, 1.5, () => {
        window.setTimeout(() => {
          resolve();
        }, 500);
      });
    };

    if (parseInt(addressRange) <= 0) {
      bcx_utils.preventRA(resolve => {
        messageTip('出勤地点有效范围必须是大于0的数字', resolve);
      });
      return;
    }

    //固定班制
    if (attendType === '1') {
      if (gdbzDataSource.returnComTaskAttendAddressList.length === 0) {
        bcx_utils.preventRA(() => {
          messageTip('出勤地点不能为空', resolve);
        });
      }

      const {
        gdbzDataSource: {
          returnComTaskFixedDList,
          returnComTaskAttendAddressList
        }
      } = this.state;

      //（固定班制时必传）固定排班制列表Json化的String串
      const comTaskFixeds = returnComTaskFixedDList.map(
        ({ taskFixedId, weekDay, shiftId }) => ({
          taskFixedId,
          weekDay,
          shiftId
        })
      );
      const comTaskAttendAdresses = changeAddress(
        returnComTaskAttendAddressList
      );

      const ajaxPara = {
        comTaskId,
        attendType,
        comTaskFixeds: JSON.stringify(comTaskFixeds),
        comTaskAttendAdresses: JSON.stringify(comTaskAttendAdresses)
      };

      bcx_utils.preventRA(resolve => {
        this.props.taskSaveStepTwoDetail(ajaxPara, resolve);
      });
    }
    //排班制
    if (attendType === '2') {
      const {
        pbzDataSource: {
          returnComTaskAttendAddressList,
          returnComTaskSchedulCycleList,
          comShifts
        }
      } = this.state;

      if (comShifts.length === 0) {
        bcx_utils.preventRA(resolve => {
          messageTip('出勤班次不能为空', resolve);
        });
        return;
      }
      // 改为非必填，冠男
      // if (returnComTaskSchedulCycleList.length === 0) {
      //   bcx_utils.preventRA((resolve) => {
      //     messageTip("周期排班不能为空", resolve);
      //   });
      //   return;
      // }
      if (returnComTaskAttendAddressList.length === 0) {
        bcx_utils.preventRA(resolve => {
          messageTip('出勤地点不能为空', resolve);
        });
        return;
      }
      const comTaskAttendAdresses = changeAddress(
        returnComTaskAttendAddressList
      );

      //设置出勤班次
      const shiftIdJson = comShifts.map(val => ({ shiftId: val.shiftId }));
      //设置排班周期
      const comTaskSchedulCycleJson = returnComTaskSchedulCycleList.map(
        ({ cycleName, cycleDays, taskSchedulCycleId, comTaskCycleShift }) => {
          const shiftIdArrayUse = [];
          comTaskCycleShift.map(v => {
            if (v.shiftId === '') {
              shiftIdArrayUse.push('-1');
            } else {
              shiftIdArrayUse.push(v.shiftId);
            }
          });
          return {
            cycleName,
            cycleDays,
            taskSchedulCycleId,
            shiftIdArrayUse
          };
        }
      );

      const ajaxPara = {
        comTaskId,
        attendType,
        shiftIdJson: JSON.stringify(shiftIdJson),
        comTaskSchedulCycleJson: JSON.stringify(comTaskSchedulCycleJson),
        comTaskAttendAdresses: JSON.stringify(comTaskAttendAdresses)
      };

      console.log(ajaxPara);

      bcx_utils.preventRA(resolve => {
        this.props.taskSaveStepTwoDetail(ajaxPara, resolve);
      });
    }
  };

  //驻勤-出勤设置/编辑-第二步新增或修改
  taskSaveStepTwoDetail = (ajaxPara, resolve) => {
    // debugger
    console.log(ajaxPara);

    taskSaveStepTwoDetail(ajaxPara).then(
      data => {
        console.log(data);
        resolve();
      },
      err => {
        console.log(err);
        resolve();
      }
    );
  };

  //增加出勤地点
  addArea = (type, [addressLongitude, addressLatitude], address) => {
    const target = this.state[type];

    target.returnComTaskAttendAddressList.push({
      taskAttendAddressId: '',
      address,
      addressLongitude,
      addressLatitude,
      addressRange: ''
    });

    this.setState({ [type]: target });
  };
  //修改出勤范围
  addressRangeChange = addressRange => {
    this.setState({ addressRange });
  };
  //删除出勤地点
  deleteLocalItem = data => {
    console.log(data);
  };

  /* 固定班次----选择默认班次 */
  fixedShiftRender = () => {
    const { returnComTaskFixedDList = [] } = this.state.gdbzDataSource;

    if (returnComTaskFixedDList.length === 0) {
      return;
    }

    const dataSource = bcx_utils
      .jsoncopy(returnComTaskFixedDList)
      .map((val, key) => ({
        ...val,
        ...{ key }
      }));

    //选择班次信息
    const openDrawfixedShift = (cursor, text, record) => {
      this.setState(
        {
          open: true,
          cursor
        },
        () => {
          console.log(this.state.cursor);
        }
      );
    };

    const rest = index => {
      const gdbzDataSource = { ...this.state.gdbzDataSource };
      gdbzDataSource.returnComTaskFixedDList[index].shiftId = '-1';
      gdbzDataSource.returnComTaskFixedDList[index].shiftDetails = '休息';
      gdbzDataSource.returnComTaskFixedDList[index].isRest = '1';

      this.setState({ gdbzDataSource });
    };
    const columns = [
      {
        title: '工作日',
        dataIndex: 'weekDay',
        key: 'weekDay',
        render: (text, record) => {
          return bcx_utils.changeWeekData(record.weekDay);
        }
      },
      {
        title: '班次详情',
        dataIndex: 'shiftDetails',
        key: 'shiftDetails',
        width: 200,
        render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
      },
      {
        title: '操作',
        dataIndex: 'option',
        key: '4',
        render: (text, record, index) => (
          <div style={{ color: 'rgba(15,113,255,1)' }}>
            <span onClick={openDrawfixedShift.bind(this, index, text, record)}>
              选择班次
            </span>
            <span style={{ marginLeft: 10 }} onClick={rest.bind(this, index)}>
              休息
            </span>
          </div>
        )
      }
    ];

    return (
      <FormItem {...formItemLayout} label='设置出勤班次'>
        <div>
          <Button
            onClick={openDrawfixedShift}
            style={{ marginBottom: 16 }}
            type='primary'
            ghost
          >
            批量选择班次
          </Button>
          <Table
            size='middle'
            pagination={false}
            columns={columns}
            dataSource={dataSource}
          />
        </div>
      </FormItem>
    );
  };

  /* 固定班次--选择班次*/
  renderDrawFixedShift = () => {
    const { open } = this.state;

    //初始化 table 数据
    const taskComShiftData = bcx_utils
      .jsoncopy(this.state.taskComShiftData)
      .map(val => ({ ...val, ...{ key: val.shiftId } }));

    const columns = [
      {
        title: '班次名称',
        dataIndex: 'shiftName',
        key: 'shiftName'
      },
      {
        title: '出勤时间',
        dataIndex: 'shiftRuleTime',
        key: 'shiftRuleTime',
        render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
      }
    ];
    const pageInit = {
      defaultPageSize: 8,
      pageSizeOptions: ['8', '12', '16', '20', '25'],
      showSizeChanger: true
    };

    //单选按钮
    const rowSelectionRadio = {
      type: 'radio',
      onChange: (selectedRowKeys, selectedRows) => {
        const { cursor } = this.state;
        const gdbzDataSource = bcx_utils.jsoncopy(this.state.gdbzDataSource);

        gdbzDataSource.returnComTaskFixedDList[cursor].shiftId =
          selectedRows[0].shiftId;
        gdbzDataSource.returnComTaskFixedDList[cursor].shiftDetails =
          selectedRows[0].shiftName + ': ' + selectedRows[0].shiftRuleTime;

        this.gdbzDataSourceCache = gdbzDataSource;
      }
    };

    const confirm = () => {
      this.setState({
        gdbzDataSource: bcx_utils.jsoncopy(this.gdbzDataSourceCache),
        open: false
      });
    };
    const cancel = () => {
      this.setState({
        open: false
      });
      this.gdbzDataSourceCache = null;
    };

    return (
      <Drawer
        overlayColor='rgba(0, 0, 0,0)'
        right
        open={this.state.open}
        noTouchClose
        width={600}
        className='drawer-box'
        onChange={open => {
          this.setState({ open });
        }}
      >
        <div className='drawer'>
          <div className='drawer-header'>
            选择班次
            <Button
              type='primary'
              onClick={() => this.setState({ open3: true, open: false })}
              ghost
            >
              新增班次
            </Button>
          </div>
          <div className='drawer-content'>
            {open && (
              <Table
                pagination={pageInit}
                rowSelection={rowSelectionRadio}
                columns={columns}
                dataSource={taskComShiftData}
              />
            )}
          </div>
          <div className='drawer-footer'>
            <Button onClick={cancel}>取消</Button>
            <Button type='primary' onClick={confirm}>
              确定
            </Button>
          </div>
        </div>
      </Drawer>
    );
  };

  //周期性排班下拉
  renderSelect = () => {
    //加载下拉列表
    const taskComShiftData = [...this.state.taskComShiftData];

    console.log('加载下拉列表', taskComShiftData);

    return (
      <Select>
        {this.state.pbzDataSourceCache.comShifts.map((val, key) => (
          <Option
            value={`${val.shiftId}+${val.shiftName}`}
            key={`${val.shiftId}+${val.shiftName}`}
          >
            {val.shiftName + '-' + val.shiftRuleTime}
          </Option>
        ))}
      </Select>
    );
  };

  /* 排班制--出勤班次 */
  scheduleRender = () => {
    const { comShifts = [] } = this.state.pbzDataSource;

    const dataSource = bcx_utils.jsoncopy(comShifts).map((val, key) => ({
      ...val,
      ...{ key }
    }));

    //选择班次信息
    const openDrawfixedShift = (cursor, text, record) => {
      this.setState(
        {
          open: true,
          cursor
        },
        () => {
          console.log(this.state.cursor);
        }
      );
    };

    const columns = [
      {
        title: '班次名称',
        dataIndex: 'shiftName',
        key: 'shiftName'
      },
      {
        title: '时间安排',
        dataIndex: 'shiftRuleTime',
        render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
      }
    ];

    return (
      <FormItem {...formItemLayout} label='设置出勤班次'>
        <div>
          <Button
            onClick={openDrawfixedShift}
            style={{ marginBottom: 16 }}
            type='primary'
            ghost
          >
            选择默认班次
          </Button>
          <Table
            size='middle'
            pagination={false}
            columns={columns}
            dataSource={dataSource}
          />
        </div>
      </FormItem>
    );
  };

  /* 固定班次--选择班次*/
  renderDrawschedule = () => {
    const { open } = this.state;

    const taskComShiftData = bcx_utils
      .jsoncopy(this.state.taskComShiftData)
      .map(val => ({ ...val, ...{ key: val.shiftId } }));

    const columns = [
      {
        title: '班次名称',
        dataIndex: 'shiftName',
        key: 'shiftName'
      },
      {
        title: '出勤时间',
        dataIndex: 'shiftRuleTime',
        key: 'shiftRuleTime',
        render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
      }
    ];
    const pageInit = {
      defaultPageSize: 8,
      pageSizeOptions: ['8', '12', '16', '20', '25'],
      showSizeChanger: true
    };

    let selectedKeys = [...this.state.pbzDataSourceCache.comShifts].map(
      val => val.shiftId
    );

    const rowSelection = {
      selectedRowKeys: [...this.state.pbzDataSourceCache.comShifts].map(
        val => val.shiftId
      ),
      onChange: (selectedRowKeys, selectedRows) => {
        const { cursor } = this.state;

        const pbzDataSourceCache = bcx_utils.jsoncopy(
          this.state.pbzDataSourceCache
        );
        pbzDataSourceCache.comShifts = selectedRows.map(val => ({
          shiftId: val.shiftId,
          shiftName: val.shiftName,
          shiftRuleTime: val.shiftRuleTime
        }));
        this.setState({ pbzDataSourceCache });
      }
    };

    const confirm = () => {
      const pbzDataSourceCache = this.state.pbzDataSourceCache;
      pbzDataSourceCache.returnComTaskSchedulCycleList = [];

      this.setState({
        pbzDataSource: bcx_utils.jsoncopy(pbzDataSourceCache),
        pbzDataSourceCache,
        open: false
      });
    };
    const cancel = () => {
      this.setState({
        open: false
      });
      this.state.pbzDataSourceCache = bcx_utils.jsoncopy(
        this.state.pbzDataSource
      );
    };

    return (
      <Drawer
        overlayColor='rgba(0, 0, 0,0)'
        right
        open={this.state.open}
        noTouchClose
        width={600}
        className='drawer-box'
        onChange={open => {
          this.setState({ open });
        }}
      >
        <div className='drawer'>
          <div className='drawer-header'>
            选择班次
            <Button
              type='primary'
              onClick={() => this.setState({ open3: true, open: false })}
              ghost
            >
              新增班次
            </Button>
          </div>
          <div className='drawer-content'>
            {open && (
              <Table
                pagination={pageInit}
                rowSelection={rowSelection}
                columns={columns}
                dataSource={taskComShiftData}
              />
            )}
          </div>
          <div className='drawer-footer'>
            <Button onClick={cancel}>取消</Button>
            <Button type='primary' onClick={confirm}>
              确定
            </Button>
          </div>
        </div>
      </Drawer>
    );
  };

  /* 排班制--周期性排班 */
  periodicityRender = () => {
    const { getFieldDecorator } = this.props.form;

    /* 排班制----周期性排班设置 */
    const columns = [
      {
        title: '周期名称',
        dataIndex: 'cycleName',
        key: 'cycleName'
      },
      {
        title: '周期天数',
        dataIndex: 'cycleDays',
        key: 'cycleDays'
      },
      {
        title: '启用班次',
        dataIndex: 'shiftNameStr',
        key: 'shiftNameStr',
        render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
      },
      {
        title: '操作',
        key: 'update',
        render: (text, record, index) => (
          <div
            style={{ color: 'rgba(15,113,255,1)' }}
            onClick={updataItem.bind(this, index)}
          >
            修改
          </div>
        )
      }
    ];

    const dataSource = this.state.pbzDataSource.returnComTaskSchedulCycleList.map(
      val => ({ ...val, ...{ key: val.taskSchedulCycleId } })
    );

    //修改周期排班
    const updataItem = cursor => {
      this.setState({ open2: true, cursor });
    };

    //添加周期排班
    const addItem = cursor => {
      const pbzDataSourceCache = { ...this.state.pbzDataSourceCache };

      pbzDataSourceCache.returnComTaskSchedulCycleList.push({
        cycleName: '',
        cycleDays: '1',
        taskSchedulCycleId: '',
        comTaskCycleShift: []
      });
      const length =
        pbzDataSourceCache.returnComTaskSchedulCycleList.length - 1;

      this.setState({ cursor: length, pbzDataSourceCache }, () => {
        this.setState({ open2: true });
      });
    };

    return (
      <FormItem
        className='hidden-star'
        {...formItemLayout}
        label='周期性排班设置'
      >
        <div>
          <Button
            onClick={addItem}
            style={{ marginBottom: 16 }}
            type='primary'
            ghost
          >
            添加周期
          </Button>
          <Table
            size='middle'
            pagination={false}
            columns={columns}
            dataSource={dataSource}
          />
        </div>
      </FormItem>
    );
  };

  //设置周期性排班
  renderDrawCircle = () => {
    const { getFieldDecorator, getFieldValue } = this.props.form;

    const { open2, cursor, pbzDataSourceCache, pbzDataSource } = this.state;

    let cycleName = '',
      cycleDays = '1',
      comTaskCycleShift = [];

    //修改模式下，读取当前记录
    if (
      pbzDataSourceCache.returnComTaskSchedulCycleList.length !== 0 &&
      open2
    ) {
      const currentItem =
        pbzDataSourceCache.returnComTaskSchedulCycleList[cursor];
      cycleName = currentItem.cycleName;
      cycleDays = currentItem.cycleDays;
      comTaskCycleShift = currentItem.comTaskCycleShift;
    }

    const cancle = () => {
      //判断是创建模式，还是 修改模式
      const ifUpdate =
        pbzDataSource.returnComTaskSchedulCycleList.length ===
        pbzDataSourceCache.returnComTaskSchedulCycleList.length;

      this.setState(
        {
          open2: false
        },
        () => {
          this.setState({
            pbzDataSourceCache: bcx_utils.jsoncopy(this.state.pbzDataSource)
          });
        }
      );

      if (!ifUpdate) {
        this.setState({ cursor: cursor - 1 });
      }
    };

    const confirm = values => {
      console.log(pbzDataSource.returnComTaskSchedulCycleList);
      console.log(values);

      //转化数据类型
      const { cycleDays, cycleName } = values;
      const comTaskCycleShift = [];
      const shiftNameStrArr = [];
      Object.keys(values).map(val => {
        if (val.includes('returnComTaskSchedulCycleList')) {
          const [shiftId, shiftName] = values[val].split('+');
          comTaskCycleShift.push({ shiftName, shiftId });
          shiftNameStrArr.push(shiftName);
        }
      });

      console.log(cycleDays, cycleName, comTaskCycleShift);

      const { cursor, pbzDataSourceCache } = this.state;

      pbzDataSourceCache.returnComTaskSchedulCycleList[
        cursor
      ].cycleName = cycleName;
      pbzDataSourceCache.returnComTaskSchedulCycleList[
        cursor
      ].cycleDays = cycleDays;
      pbzDataSourceCache.returnComTaskSchedulCycleList[
        cursor
      ].comTaskCycleShift = comTaskCycleShift;
      pbzDataSourceCache.returnComTaskSchedulCycleList[
        cursor
      ].shiftNameStr = shiftNameStrArr.join(',');

      console.log(pbzDataSource.returnComTaskSchedulCycleList);

      this.setState({
        open2: false,
        pbzDataSourceCache,
        pbzDataSource: bcx_utils.jsoncopy(this.state.pbzDataSourceCache)
      });
    };

    //加载 班次列表
    const renderFormItems = (number, FormItem, getFieldDecorator) => {
      const items = [];
      if (!number) {
        return items;
      }
      for (let day = 1; day < number + 1; day++) {
        let initialProp = {};
        //判断
        if (
          pbzDataSourceCache.returnComTaskSchedulCycleList[cursor]
            .comTaskCycleShift[day - 1]
        ) {
          const {
            shiftId,
            shiftName
          } = pbzDataSourceCache.returnComTaskSchedulCycleList[
            cursor
          ].comTaskCycleShift[day - 1];
          initialProp = {
            initialValue: `${shiftId}+${shiftName}`
          };
        }

        if (
          pbzDataSourceCache.returnComTaskSchedulCycleList.length <=
          number + 1
        ) {
          items.push(
            <FormItem
              {...formItemLayout}
              label={`第${bcx_utils.changeIntData(day)}天班次`}
              key={day}
            >
              {getFieldDecorator(`returnComTaskSchedulCycleList${day}`, {
                ...initialProp,
                rules: [{ required: true, message: '请输入' }]
              })(this.renderSelect())}
            </FormItem>
          );
        } else {
          items.push(
            <FormItem
              {...formItemLayout}
              label={`第${bcx_utils.changeIntData(day)}天班次`}
              key={day}
            >
              {getFieldDecorator(`returnComTaskSchedulCycleList${day}`, {
                rules: [{ required: true, message: '请输入' }]
              })(this.renderSelect())}
            </FormItem>
          );
        }
      }
      return items;
    };

    return (
      <Drawer
        overlayColor='rgba(0, 0, 0,0)'
        zIndex={3}
        right
        open={this.state.open2}
        noTouchClose
        width={600}
        className='drawer-box'
        onChange={open2 => {
          this.setState({ open2 });
        }}
      >
        {open2 && (
          <DrawCircleForm
            cycleName={cycleName}
            cycleDays={cycleDays}
            renderFormItems={renderFormItems}
            cancle={cancle}
            confirm={confirm}
          />
        )}
      </Drawer>
    );
  };

  render() {
    const {
      getFieldDecorator,
      setFieldsValue,
      getFieldValue
    } = this.props.form;
    const attendType = getFieldValue('attendType');
    const { open, open1, open2, open3 } = this.state;
    return (
      <Container>
        <div className='CreateTask'>
          <div className='Steps'>
            <Steps current={1}>
              <Step title='基本信息' />
              <Step title='出勤设置' />
              <Step title='发布设置' />
            </Steps>
          </div>
          <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
            <FormItem {...formItemLayout} label='选择出勤类型'>
              {getFieldDecorator('attendType', {
                onChange: e => {
                  setFieldsValue({ attendType: e.target.value });
                }
              })(
                <Radio.Group>
                  <Radio className='radioStyle' value='1'>
                    固定班制（每天出勤时间一样）{' '}
                    <span className='exclamation'>
                      <Icon type='exclamation-circle' />
                      适用于：每天固定上下班的驻勤。
                    </span>
                  </Radio>
                  <Radio className='radioStyle' value='2'>
                    排班制（自定义设置出勤时间）
                    <span className='exclamation'>
                      <Icon type='exclamation-circle' />
                      适用于：每天多个班次进行轮流上岗的驻勤。
                    </span>
                  </Radio>
                  {/*<Radio disabled className="radioStyle" value="3">*/}
                  {/*自由班制（不设置班次，可随时打卡出勤，计算工时）*/}
                  {/*</Radio>*/}
                </Radio.Group>
              )}
            </FormItem>
            {/* 固定班次 */}
            {attendType === '1' && this.fixedShiftRender()}

            {attendType === '1' && this.renderDrawFixedShift()}

            {/*固定班次-设置地点*/}
            {attendType === '1' && (
              <SetLocation
                dataSource={
                  this.state.gdbzDataSource.returnComTaskAttendAddressList
                }
                deleteLocalItem={this.deleteLocalItem}
                addArea={this.addArea.bind(this, 'gdbzDataSource')}
                addressRangeChange={this.addressRangeChange}
              />
            )}

            {/* 排班次--出勤班次 */}
            {attendType === '2' && this.scheduleRender()}

            {attendType === '2' && this.renderDrawschedule()}

            {/* 排班次--周期性排班 */}
            {attendType === '2' &&
              this.state.pbzDataSource.comShifts.length != 0 &&
              this.periodicityRender()}

            {/*排班次-设置地点*/}
            {attendType === '2' && (
              <SetLocation
                dataSource={
                  this.state.pbzDataSource.returnComTaskAttendAddressList
                }
                deleteLocalItem={this.deleteLocalItem}
                addArea={this.addArea.bind(this, 'pbzDataSource')}
                addressRangeChange={this.addressRangeChange}
              />
            )}

            <FormItem {...submitFormLayout} style={{ marginTop: 32 }}>
              <Button onClick={() => this.props.switchStep(-1)}>上一步</Button>
              {/*<Button type="primary" style={{marginLeft: 8}} htmlType="submit" onClick={() => this.props.switchStep(1)}>
              下一步
            </Button>*/}
              <Button
                type='primary'
                style={{ marginLeft: 8 }}
                htmlType='submit'
              >
                下一步
              </Button>
            </FormItem>
          </Form>

          {attendType === '2' && this.renderDrawCircle()}

          {/*  选择班次--新增班次 */}
          <Drawer
            overlayColor='rgba(0, 0, 0,0)'
            right
            open={this.state.open3}
            noTouchClose
            width={600}
            className='drawer-box'
            zIndex={3}
            onChange={open3 => {
              this.setState({ open3 });
            }}
          >
            <AddNewShift />
          </Drawer>

          <Modal
            title='添加出勤WIFI'
            visible={this.state.visible1}
            okText='确认'
            cancelText='取消'
            onOk={this.handleOk}
            onCancel={this.handleCancel}
          >
            <Form onSubmit={this.handleSubmit}>
              <FormItem label='WIFI名称' {...formItemLayout1}>
                {getFieldDecorator('address', {
                  rules: [{ required: true, message: '请输入' }]
                })(<Input />)}
              </FormItem>
              <FormItem {...formItemLayout1} label='MAC地址'>
                {getFieldDecorator('address', {
                  rules: [{ required: true, message: '请输入' }]
                })(<Input />)}
              </FormItem>
            </Form>
          </Modal>
          {(open || open1 || open2 || open3) && <PZhezhao top={'72px'} />}
        </div>
      </Container>
    );
  }
}

const Container = style.div`
    .ant-form-item-label{
      >label:before{
       display: inline-block;
       margin-right: 4px;
       content: "*";
       font-family: SimSun;
       line-height: 1;
       font-size: 14px;
       color: #f5222d;
      }
    }
    .hidden-star{
      .ant-form-item-label{
        >label:before{
         content: "";
        }
      }
    }
`;
