import React, { PureComponent } from 'react';
import {
  Form,
  Input,
  Select,
  Timeline,
  Row,
  Col,
  Button,
  Radio,
  Steps,
  Checkbox,
  Icon,
  Table,
  InputNumber,
  TimePicker,
  Modal,
  message,
  Alert
} from 'antd';

import {
  formItemLayout,
  formItemLayout3,
  formItemLayout4,
  formItemLayout2
} from './Constants';
import PMap from '../../../components/Pro/PMap';
import bcx_utils from '../../../common/bcx_utils';

import './less/style.less';

const FormItem = Form.Item;

/**
 * 配置角色及权限
 */
export default class SetLocation extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      address: '',
      points: [],
      visible: false, //添加地点
      addressRange: '0' //考勤范围
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
    //初始化考勤范围
    // const { dataSource } = this.props;
    // if (dataSource.length !== 0) {
    //   this.setState({
    //     addressRange: dataSource[0].addressRange
    //   });
    //   this.props.addressRangeChange(dataSource[0].addressRange);
    // } else {
    //   this.props.addressRangeChange(0);
    // }
  };

  componentWillReceiveProps = (nextProps, newState) => { };

  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  //提交地点
  handleOk = e => {
    const { address, points } = this.state;
    if (address === '' || points.length === 0) {
      bcx_utils.preventRepeatAsync(callback =>
        callback(resolve => {
          message.warning('请选择地点', 1.5, () => {
            window.setTimeout(() => {
              resolve();
            }, 500);
          });
        })
      );
      return;
    }
    this.props.addArea(points, address);
    this.setState({
      visible: false
    });
  };
  //取消地点
  handleCancel = e => {
    this.setState({
      visible: false,
      address: '',
      points: []
    });
  };

  deleteItem = (index, record) => {
    this.props.deleteLocalItem(index, record);
  };

  areaChange = (points, address) => {
    this.setState({ points, address });
  };

  inputchange = e => {
    const addressRange = e.target.value.trim().replace(/[^0-9]/g, '');
    // this.setState({ addressRange });
    this.props.addressRangeChange(addressRange);
  };

  /******************************render******************************/

  render() {
    const { dataSource = [] } = this.props;
    const newDataSource = dataSource.map((val, key) => ({
      ...val,
      ...{ key }
    }));
    /* 考勤地点--drawer */
    let columns = [
      {
        key: 'address',
        title: '考勤地点',
        dataIndex: 'address'
      },
      {
        key: 'addressRange',
        title: '考勤范围(米)',
        dataIndex: 'addressRange'
      },
      {
        width: 60,
        title: '操作',
        dataIndex: 'b',
        render: (text, record, index) => (
          this.props.disabled? 
            <span>删除</span>
            :
          <span
            style={{ color: '#0F71FF' }}
            onClick={this.deleteItem.bind(this, index, record)}
          >
            删除
          </span>
        )
      }
    ];
    if(!this.props.text1) {
      columns.splice(1, 1);
    }
    return (
      <div>
        <Row span={24}>
          {
            this.props.upper &&
            <div>
              {
                this.props.text1 &&
                <FormItem style={{margin: 0, fontWeight: "bold"}} {...formItemLayout2} label={this.props.text1} >
                  请先设置有效范围，再点击添加地点即可。
                </FormItem>
              }
              <FormItem {...formItemLayout2} label="有效范围">
                <Input
                  addonAfter="米"
                  placeholder="请输入"
                  style={{width: 100}}
                  value={this.props.addressRange}
                  onChange={this.inputchange}
                />
              </FormItem>
              <FormItem
                {...formItemLayout}
                label=" "
                colon={false}
                className="small-tips"
                style={{ marginBottom: 0 }}
              >
                <Alert
                  message={
                    <div>
                      提示：有效范围请勿设置过小，手机定位会受信号等因素影响偏移，造成无法打卡。
                    </div>
                  }
                  type="warning"
                  showIcon
                />
              </FormItem>
              
              <FormItem {...formItemLayout2} label="设置出勤地点">
                <div>
                  <Button
                    disabled={this.props.disabled}
                    type="primary"
                    ghost
                    onClick={() => {
                      this.setState({ visible: true });
                    }}
                  >
                    添加地点
                    </Button>
                  <span className="exclamation">
                    <Icon type="exclamation-circle" />
                    可设置多个考勤地点
                    </span>
                </div>
              </FormItem>
            </div>
          }
          {
            !this.props.upper &&
            <Row className="resetant-row">
              <Col span={12}>
                <FormItem {...formItemLayout3} label="设置出勤地点">
                  <div>
                    <Button
                      type="primary"
                      ghost
                      onClick={() => {
                        this.setState({ visible: true });
                      }}
                    >
                      添加地点
                    </Button>
                    <span className="exclamation">
                      <Icon type="exclamation-circle" />
                      可设置多个考勤地点
                    </span>
                  </div>
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem {...formItemLayout4} label="有效范围">
                  <Input
                    addonAfter="米"
                    placeholder="请输入"
                    value={this.props.addressRange}
                    onChange={this.inputchange}
                    maxLength={10}
                  />
                </FormItem>
              </Col>
            </Row>
          }
          
          <FormItem
            {...formItemLayout}
            label=" "
            colon={false}
            className="small-tips"
            style={{ marginBottom: 0 }}
          >
            {
              !this.props.upper && 
              <Alert
                message={
                  <div>
                    提示：有效范围请勿设置过小，手机定位会受信号等因素影响偏移，造成无法打卡。
                  </div>
                }
                type="warning"
                showIcon
              />
            }
          </FormItem>
          {
            this.props.text2 &&
            <FormItem style={{margin: 0, fontWeight: "bold"}} {...formItemLayout2} label={this.props.text2}></FormItem>
          }
          <FormItem
            labelCol={{span: 6}}
            wrapperCol={{span: 11}}
            label=" "
            colon={false}
            required={false}
          >
            <Table
              style={{ marginTop: 16 }}
              size="middle"
              pagination={false}
              columns={columns}
              dataSource={newDataSource}
            />
          </FormItem>
        </Row>
        <Modal
          title="添加地点"
          visible={this.state.visible}
          okText="提交"
          cancelText="关闭"
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={800}
        >
          <PMap
            areaChange={this.areaChange}
            taskCityName={this.props.taskCityName} //添加当前驻勤城市名称，9-28
            ifProvince={false}
          />
        </Modal>
      </div>
    );
  }
}
