import React, { PureComponent } from 'react';
// import { connect } from 'dva';

import { Form, Input, Button } from 'antd';
import bcx_utils from '../../../common/bcx_utils';
import {
  taskComTaskPerShiftValidateScheduleCycle // 校验周期班次是否冲突
} from '../../../services/api';

const FormItem = Form.Item;

import { formItemLayout } from './Constants';

@Form.create()
export default class DrawCircleForm extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {};
  }

  /******************************生命周期******************************/

  componentDidMount = () => {};
  componentWillReceiveProps = () => {};
  /******************************ajax请求******************************/

  /******************************相关事件******************************/

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      let ajaxDataIDs = bcx_utils.jsoncopy(values);
      delete ajaxDataIDs.cycleDays;
      delete ajaxDataIDs.cycleName;

      ajaxDataIDs = Object.values(ajaxDataIDs).map(item => {
        return item.split('+')[0];
      });
      const ids = ajaxDataIDs.join(',');
      if (!err) {
        console.log('Received values of form: ', values);

        // 校验周期班次是否冲突
        taskComTaskPerShiftValidateScheduleCycle({ ids }).then(
          res => {
            console.log('res', res);
            this.props.confirm(values);
          },
          error => {
            console.log('err', error);
          }
        );
      }
    });
  };

  /******************************render******************************/

  render() {
    const { getFieldDecorator, getFieldValue } = this.props.form;
    const { cycleName, cycleDays, renderFormItems, cancle } = this.props;

    let number = parseInt(getFieldValue('cycleDays')) || 1; //总共几天班次
    if (number > 7) {
      number = 7;
    }

    return (
      // 每次只加载一个模块
      <div className='drawer'>
        <div className='drawer-header'>选择班次</div>
        <div className='drawer-content'>
          <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
            <FormItem {...formItemLayout} label='周期名称'>
              {getFieldDecorator('cycleName', {
                initialValue: cycleName,
                rules: [
                  {
                    required: true,
                    message: '请输入周期名称，限制15个字',
                    max: 15
                  }
                ]
              })(<Input />)}
            </FormItem>
            <FormItem {...formItemLayout} label='周期天数'>
              {getFieldDecorator('cycleDays', {
                initialValue: cycleDays,
                rules: [
                  { required: true, message: '请输入' },
                  { pattern: /^[1234567]$/g, message: '请输入1-7内的天数' }
                ]
              })(<Input addonAfter='天' />)}
              <span
                style={{
                  position: 'absolute',
                  width: '180px',
                  textIndent: '6px'
                }}
              >
                {`${number}天为一周期进行循环排班`}
              </span>
            </FormItem>
            {renderFormItems(number, FormItem, getFieldDecorator)}
          </Form>
        </div>
        <div className='drawer-footer'>
          <Button onClick={cancle}>取消</Button>
          <Button type='primary' htmlType='submit' onClick={this.handleSubmit}>
            确定
          </Button>
        </div>
      </div>
    );
  }
}
