import React, { Component } from "react";
import { connect } from "dva";
import moment from "moment";
import {
  Form,
  Input,
  Timeline,
  Row,
  Button,
  Checkbox,
  InputNumber,
  TimePicker
} from "antd";

import { enterpriseCompanyComBaseInfoGetComBaseInfoById } from "../../services/api";

import "./Task.less";

const FormItem = Form.Item;
const format = "HH:mm";

const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 7 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 12 },
    md: { span: 10 }
  }
};

@connect(state => ({
  profile: state.profile
}))
@Form.create()
export default class AddNewShift extends Component {
  state = {
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0
    }
  };

  componentDidMount() {}

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: "form/submitRegularForm",
          payload: values
        });
      }
    });
  };

  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="drawer task-drawer">
        <div className="drawer-header">新增班次</div>
        <div className="drawer-content">
          <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
            <FormItem {...formItemLayout} label="班次名称">
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(<Input />)}
            </FormItem>
            <FormItem {...formItemLayout} label="一天上下班冷饮数">
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(<Input addonAfter="次" />)}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="第一轮班次"
              style={{ marginBottom: 0 }}
            >
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(
                <Timeline>
                  <Timeline.Item color="green">
                    上班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                  </Timeline.Item>
                  <Timeline.Item color="orange">
                    下班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                  </Timeline.Item>
                </Timeline>
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              style={{ marginBottom: 0 }}
              label="第二轮班次"
            >
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(
                <Timeline>
                  <Timeline.Item color="green">
                    上班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                  </Timeline.Item>
                  <Timeline.Item color="orange">
                    下班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                  </Timeline.Item>
                </Timeline>
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              style={{ marginBottom: 0 }}
              label="第三轮班次"
              help={
                <div className="help">
                  合计工作时长<span>21</span>小时<span>00</span>
                </div>
              }
            >
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(
                <Timeline style={{ marginBottom: 0 }}>
                  <Timeline.Item color="green">
                    上班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                  </Timeline.Item>
                  <Timeline.Item color="orange">
                    下班：<TimePicker
                      className="task-TimePicker"
                      defaultValue={moment("12:08", format)}
                      format={format}
                    />
                    <span
                      style={{
                        position: "absolute",
                        right: 0,
                        top: 4,
                        marginRight: -40,
                        color: "#F5222E"
                      }}
                    >
                      次日
                    </span>
                  </Timeline.Item>
                </Timeline>
              )}
            </FormItem>
            <div style={{ borderBottom: "1px solid#E9E9E9", margin: "24px" }} />
            <FormItem
              {...{
                labelCol: {
                  xs: { span: 24 },
                  sm: { span: 7 }
                },
                wrapperCol: {
                  xs: { span: 24 },
                  sm: { span: 12 },
                  md: { span: 16 }
                }
              }}
              label="附加设置"
            >
              {getFieldDecorator("address", {
                rules: [{ required: true, message: "请输入" }]
              })(
                <Checkbox.Group
                  onChange={e => {
                    console.log(e);
                  }}
                >
                  <Row style={{ marginBottom: 24 }}>
                    {" "}
                    <Checkbox value="A">允许迟到</Checkbox>
                    <InputNumber
                      style={{ width: 88 }}
                      min={1}
                      max={10}
                      defaultValue={3}
                    />分钟
                  </Row>
                  <Row style={{ marginBottom: 24 }}>
                    {" "}
                    <Checkbox value="A">迟到超过</Checkbox>
                    <InputNumber
                      style={{ width: 88 }}
                      min={1}
                      max={10}
                      defaultValue={3}
                    />分钟{" "}
                    <span style={{ color: "#FFAA00" }}>(视为严重迟到)</span>
                  </Row>
                  <Row style={{ marginBottom: 24 }}>
                    {" "}
                    <Checkbox value="A">迟到超过</Checkbox>
                    <InputNumber
                      style={{ width: 88 }}
                      min={1}
                      max={10}
                      defaultValue={3}
                    />分钟<span style={{ color: "#F5222E" }}>(视为旷工)</span>
                  </Row>
                </Checkbox.Group>
              )}
            </FormItem>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button htmlType="submit" type="primary">
                确定
              </Button>
            </div>
          </Form>
        </div>
      </div>
    );
  }
}
