import React, { Component } from 'react';
import { connect } from 'dva';
import { Form, Input, Button, Icon, Select, Tag, Popover } from 'antd';
import './Task.less';


const FormItem = Form.Item;
const { Option } = Select;

@connect(state => ({ 
  profile: state.profile,
}))

@Form.create()


export default class TaskList extends Component {
  state = {
    expand: false,
  };

  componentDidMount() {
    // To disabled submit button at the beginning.
    this.props.form.validateFields();
  }
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values);
      }
    });
  }

  toggle = () => {
    const { expand } = this.state;
    this.setState({ expand: !expand });
  }


  render() {
    const { getFieldDecorator, getFieldError, isFieldTouched } = this.props.form;

    // Only show error after a field is touched.
    const userNameError = isFieldTouched('userName') && getFieldError('userName');
    return (
      <div className="Task">
        <Form layout="inline" onSubmit={this.handleSubmit}>
          <FormItem
            label="任务名称"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Input placeholder="Username" />
              )}
          </FormItem>
          <FormItem
            label="任务类型"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="Select a person"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            label="考勤方式"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="Select a person"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            label="任务状态"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Select
                style={{ width: 171 }}
                placeholder="Select a person"
                optionFilterProp="children"
              >
                <Option value="jack">Jack</Option>
                <Option value="lucy">Lucy</Option>
                <Option value="tom">Tom</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            label="任务地点"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Input placeholder="Username" />
              )}
          </FormItem>
          <FormItem
            label="任务性质"
            validateStatus={userNameError ? 'error' : ''}
            help={userNameError || ''}
          >
            {getFieldDecorator('userName', {
              rules: [{ required: true, message: 'Please input your username!' }],
            })(
              <Input placeholder="Username" />
              )}
          </FormItem>
          <a className="collape" onClick={this.toggle}>
            展开 <Icon type={this.state.expand ? 'up' : 'down'} />
          </a>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
            >
              搜索
            </Button>
          </FormItem>
        </Form>
        <div className="cartlist">
          <div className="cart-item cart-item-add">
            <Icon style={{ fontSize: 28 }} type="plus" />
            新增任务
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed">固定</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed">固定</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed jj">紧急</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed dfb">待发布</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed ls">临时</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed">固定</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="cart-item">
            <div className="cart-item-top">
              <div className="title">任务名称 <span className="type fixed">固定</span></div>
              <div className="tip">
                <Tag>人防</Tag>
                <Tag>押运</Tag>
                <Tag>技防</Tag>
                <Tag>随声护卫</Tag>
                <Tag>安全检查</Tag>
              </div>
              <div className="line"><span>类型：</span><p>任务类型名次</p></div>
              <div className="line"><span>地址：</span><p>任务类型名次</p></div>
              <div className="line"><span>内容：</span><p>任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次任务类型名次</p></div>
            </div>
            <div className="cart-item-footer">
              <span><em className="dot" />进行中</span> <span>2017-12-12~2018-12-12</span>
              <Popover placement="bottom" content={<div className="popcontent"> <div>关闭</div><div>取消</div><div>暂停</div></div>} trigger="click">
                <Icon style={{ fontSize: 20 }} type="ellipsis" />
              </Popover>
            </div>
          </div>
          <div className="more">加载更多</div>

        </div>
      </div>
    );
  }
}
