/**
 * 待发放页面
 */
import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  Input,
  DatePicker,
  Alert
} from 'antd';
import { getComWalletAccount } from '../../../../services/api';
import { withRouter } from 'dva/router';
import moment from 'moment';
import columnFun from './columns';
import tablePage from '../../../../utils/hoc/tablePage';

const { RangePicker } = DatePicker;
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@tablePage()
@withRouter
export default class NoDistribution extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      params: null,
      searchData: null,
      accountInfo:null,//企业钱包账户信息
    };
  }

  componentDidMount() {
    getComWalletAccount({}).then(res => {
      this.setState({
        accountInfo: res.data
      });
    });
  }
  componentWillMount() {

  }

  // 表格渲染
  __renderOrderList = () => {
    const columns = columnFun.call(this, this.state.accountInfo);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        renderDataParam='pageInfo'
        url="getDffSubsidyList"
        // scroll={{ x: '3200px' }}
        pagination={{ showTotal: total => `总共 ${total} 条` }}
        dateChange={(value) => {
          this.setState({
            searchData: value.dfMap
          })
        }}
        updateIssued={()=>{
          this.props.updateIssued()
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator, setFieldsValue } = this.props.form;
    const { searchData } = this.state
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>公安系统公示通过的补贴申请信息将显示在本页面；请根据待发放记录进行补贴在线发放；<br />
            补贴发放将使用企业钱包的可用金额，请先开通企业钱包并充值资金。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          arrange={values => {
            values.subsidyType = '2'
            const { date } = values;
            if (date.length == 2) {
              values.startTime = moment(date[0]).format('YYYY-MM-DD');
              values.endTime = moment(date[1]).format('YYYY-MM-DD');
            } else {
              values.startTime = '';
              values.endTime = '';
            }
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <Form>
            <Form.Item label="批次名称">
              {getFieldDecorator('batchName', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入批次名称" />
              )}
            </Form.Item>
            <Form.Item label="补贴对象名称">
              {getFieldDecorator('subsidyObject', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入补贴对象名称" />
              )}
            </Form.Item>
            <Form.Item label="申请时间">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  style={{ width: 240 }}
                  format={'YYYY-MM-DD'}
                />
              )}
            </Form.Item>
          </Form>
        </SearchForm>
        {
          searchData && <div style={{paddingTop:'10px'}}>
            搜索结果统计：
            <span>待发放总笔数：<Yellow>{searchData.count}</Yellow> | </span>待发放总金额（元）：<Yellow>{searchData.money}</Yellow>
          </div>
        }
        {/* 表格 */}
        {this.__renderOrderList()}
      </div >
    );
  }
}

const Yellow = st.span`
  color: orange
`;