import st from 'styled-components';
import { Input, message } from 'antd';
import $nModal from '../../../../utils/modal/nModal';
import $modal from '../../../../utils/modal';
const store = require("store");
import { getComWalletServiceOpenInfoFormOne, getComWalletAccountAmount, getBbdSubsidyPageUrl, grantBayzgzSubsidy, sendSubsidyVerificationCode } from '../../../../services/api';

export default function (accountInfo) {
  //解决相加减精度丢失问题
  Math.formatFloat = function (f, digit) {
    var m = Math.pow(10, digit);
    return parseInt(f * m, 10) / m;
  }
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: "申请时间",
      dataIndex: "applyTime",
      key: "applyTime",
      width: 200,
      fixed: "left",
      render: (value) => value || "-",
    },
    {
      title: "批次名称",
      dataIndex: "batchName",
      key: "batchName",
      render: (value) => value || "-",
    },
    {
      title: "补贴对象名称",
      dataIndex: "companyname",
      key: "companyname",
      render: (value) => value || "-",
    },
    {
      title: "批次人数",
      dataIndex: "perNum",
      key: "perNum",
      render: (value) => value || "-",
    },
    {
      title: "补贴总额(元)",
      dataIndex: "subsidyMoney",
      key: "subsidyMoney",
      render: (value) => value || "-",
    },
    {
      title: "状态",
      dataIndex: "grantState",
      key: "grantState",
      render: (value) => {
        if(value=='0'){
          return <span>待发放</span>
        }else if(value=='1'){
          return <span>已发放</span>
        }else{
          return <span>{value}</span>
         }
      },
    },
    {
      title: "操作",
      dataIndex: "operation",
      key: "operation",
      render: (text, record) => {
        return (
          <div>
            <Operation onClick={async () => {
              let url = null
              await getBbdSubsidyPageUrl().then(res => {
                if (res.data) {
                  url = `${res.data}?id=${record.id}&sid=${store.get("saas")["sessionId"]}`
                }
              })
              url && $nModal({
                title: record.batchName,
                footer: null,
                width: 800,
                content: (
                  <div style={{ height: '700px' }}>
                    <iframe
                      title="资格证补贴"
                      src={url}
                      width="100%"
                      height="100%"
                      frameBorder="0"
                    >
                      您的浏览器不支持iframe，请升级
                    </iframe>
                  </div>
                )
              });
            }}>补贴详情</Operation>
            <Operation onClick={async () => {
              /**
               * 校验钱包开通情况
               * 1、不传参数代表查找自己企业
               * 2、传comId查找对应的企业信息
               */
              let param = accountInfo
              let param2 = ''
              await getComWalletServiceOpenInfoFormOne({ comId: record.companyid }).then(res => {
                if (res.retType == '0') {
                  param2 = res.data.isCompleteOpen
                }
                //isCompleteOpen"是否完成开户",isAuthorize"是否授权服务"
              })
              if (param && param2 == '1') {
                //都开通
                $modal(
                  <span>即将向<RedSpan>{record.companyname}</RedSpan>发放补贴<RedSpan>{record.subsidyMoney}</RedSpan> 元，是否继续？</span>,
                  null,
                  [
                    {
                      text: '继续',
                      type: 'primary',
                      onPress: () => {
                        //校验钱包余额是否足够
                        getComWalletAccountAmount().then(data => {
                          if (Number(record.subsidyMoney) > Number(data.data.availableAmount)) {
                            //余额不足
                            $modal(
                              `您当前账户余额不足，请先充值！`,
                              <div>
                                <p>发放总额:<OrangeSpan>{record.subsidyMoney}</OrangeSpan></p>
                                <p>账户余额:<OrangeSpan>{data.data.availableAmount}</OrangeSpan></p>
                                <p>还需充值:<RedSpan>{
                                  Math.formatFloat(Number(record.subsidyMoney) - Number(data.data.availableAmount), 2)
                                }</RedSpan></p>
                              </div>,
                              [
                                {
                                  text: '去充值',
                                  type: 'primary',
                                  onPress: () => {
                                    this.props.history.push('/finance/business-wallet');
                                  }
                                },
                                {
                                  text: '返回',
                                }
                              ],
                              'error'
                            );
                          } else {
                            //余额充足
                            //向企业钱包绑定的手机号码获取验证码
                            sendSubsidyVerificationCode({
                              mobilePhone: accountInfo.mobilePhone
                            }).then(res => {
                              if (res.retType == '0') {
                                let codeValue = ''
                                $modal(
                                  `已向企业绑定手机号发送验证码！`,
                                  <div>
                                    <OrangeSpan>系统已向{accountInfo.mobilePhone}发送短信验证码，请将接收到的短信验证码输入下框并验证。</OrangeSpan>
                                    <Input style={{ width: 240 }} placeholder="请输入短信验证码" onChange={(e) => {
                                      codeValue = e.target.value
                                    }} />
                                  </div>,
                                  [
                                    {
                                      text: '继续',
                                      type: 'primary',
                                      onPress: () => {
                                        if (!codeValue) {
                                          message.warning("请输入验证码")
                                        } else {
                                          grantBayzgzSubsidy({
                                            mobilePhone: accountInfo.mobilePhone,
                                            activeCode: codeValue,
                                            amount: record.subsidyMoney, //金额
                                            lastschriftAmount: record.platSerFee, //划账金额
                                            batchNo: record.id,
                                            batchName: record.batchName,
                                            inId: record.companyid //企业id
                                          }).then(value => {
                                            if (value.retType == '0') {
                                              $modal(
                                                `补贴发放成功！`,
                                                null,
                                                [
                                                  {
                                                    text: '返回待发放列表',
                                                    type: 'primary',
                                                    onPress: () => {
                                                      this.props.updateIssued()
                                                      this.props.updateTable();
                                                    }
                                                  },
                                                ],
                                                'success'
                                              );
                                            }
                                          })
                                        }
                                      }
                                    },
                                    {
                                      text: '返回',
                                    }
                                  ]
                                );
                              }
                            })
                          }
                        })
                      }
                    },
                    {
                      text: '返回'
                    }
                  ]
                );
              } else if (param2 == '0') {
                //补贴对象未开通
                $modal(
                  <RedSpan>"{record.companyname}"未开通企业钱包，请联系该企业（补贴详情查看联系方式）开通企业钱包后再发放。</RedSpan>,
                  null,
                  [
                    {
                      text: '知道了',
                      type: 'primary',
                      onPress: () => {
                        console.log("1")
                      }
                    }
                  ]
                );
              } else if (param == null) {
                //本企业未开通
                $modal(
                  <RedSpan>您尚未开通企业钱包，无法在线发放补贴，请先开通并充值补贴资金。</RedSpan>,
                  null,
                  [
                    {
                      text: '去开通',
                      type: 'primary',
                      onPress: () => {
                        this.props.history.push('/finance/business-wallet');
                      }
                    },
                  ]
                );
              }
            }}>确认发放</Operation>
          </div>
        );
      },
    },
  ];
}

const Operation = st.span`
  color: #1890ff;
  cursor: pointer;
  margin-right: 10px
`;
const RedSpan = st.span`
  color: red;
`;
const OrangeSpan = st.span`
  color: orange;
`;