import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";
import { connect } from "dva";
import NoAuthority from '../../common/NoAuthority';
import declare from '../../utils/hoc/declare';

const store = require("store");
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile,
  perId: state.user.currentUser.perId
}))
@declare
export default class RegistrationFromBeijing extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
    };
  }

  componentDidMount = () => {

  }
  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab="保安员离京登记" key="1" />
        </Tabs>
        {store.get("RegistrationFromBeijingURL") !== undefined ? (
          <iframe title="保安员离京登记" src={store.get("RegistrationFromBeijingURL")["RegistrationFromBeijingURL"]+'&perId='+this.props.perId} width="100%" height="100%" frameBorder="0">
            您的浏览器不支持iframe，请升级
          </iframe>
        ) : (
            <NoAuthority></NoAuthority>
          )}
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
