import React, { PureComponent } from 'react';
import { Tabs, Select, Input, Button, Modal, Alert } from 'antd';
import style from 'styled-components';

import PTable from '../../components/Pro/PTable';

import {
  taskSalaryTempCopyComSalaryTemp, //复制企业薪酬模板
  taskSalaryTempDelComSalaryTemp //删除企业薪酬模板
} from '../../services/api';

const { TabPane } = Tabs;
// const dateFormat = 'YYYY-MM-DD';
const { Option } = Select;
const { confirm } = Modal;

export default class Template extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      name: '',
      effectStatus: '',
      forceUpdate: false,
      pageParm: {
        pageSize: '10',
        pageNumber: '1',
        name: '',
        effectStatus: ''
      }
    };
  }

  componentDidMount = () => {
    // this.taskComSalaryPageForPersalary();
    // this.taskSalaryTempPageComSalaryTemp();
  };

  /*********************Ajax请求********************* */
  //复制企业薪酬模板
  taskSalaryTempCopyComSalaryTemp = comSalaryTempId => {
    taskSalaryTempCopyComSalaryTemp({ comSalaryTempId }).then(
      res => {
        console.log(res, 'res');
        this.resetting();
      },
      err => {
        console.log('err', err);
      }
    );
  };

  //删除企业薪酬模板
  taskSalaryTempDelComSalaryTemp = comSalaryTempId => {
    taskSalaryTempDelComSalaryTemp({ comSalaryTempId }).then(
      res => {
        console.log(res, 'res');
        this.resetting();
      },
      err => {
        console.log('err', err);
      }
    );
  };

  //人员月度工资分页查询
  // taskComSalaryPageForPersalary = () => {
  //   taskComSalaryPageForPersalary({}).then(
  //     res => {
  //       console.log(res, 'res');
  //     },
  //     err => {
  //       console.log('err', err);
  //     }
  //   );
  // };

  //企业薪酬模板列表分页查询
  // taskSalaryTempPageComSalaryTemp = () => {
  //   taskSalaryTempPageComSalaryTemp({}).then(
  //     res => {
  //       console.log(res, 'res');
  //     },
  //     err => {
  //       console.log('err', err);
  //     }
  //   );
  // };

  //复制企业薪酬模板
  copyTemplate = comSalaryTempId => {
    this.taskSalaryTempCopyComSalaryTemp(comSalaryTempId);
  };

  //删除企业薪酬模板
  deleteTemplate = (comSalaryTempId, perNum) => {
    if (perNum > 0) {
      const self = this;
      confirm({
        title: '该模板有关联人员，确认要删除？',
        content: (
          <span style={{ color: 'red' }}>已生成的核算数据，不会被删除。</span>
        ),
        okText: '确认',
        cancelText: '取消',
        onOk() {
          console.log('OK');
          self.taskSalaryTempDelComSalaryTemp(comSalaryTempId);
        },
        onCancel() {
          console.log('Cancel');
        }
      });
    } else {
      this.taskSalaryTempDelComSalaryTemp(comSalaryTempId);
    }
  };

  //输入框的书写
  inputKeywordChange = e => {
    console.log(e.target.value.trim());
    this.setState({ name: e.target.value.trim() });
  };

  handleChangeEffectStatus = value => {
    console.log(`selected ${value}`);
    this.setState({
      effectStatus: value
    });
  };

  //点击搜索
  search = () => {
    const pageParm = { ...this.state.pageParm };
    pageParm.name = this.state.name;
    pageParm.effectStatus = this.state.effectStatus;
    this.setState({ pageParm });
  };

  //重置
  resetting = () => {
    this.setState(
      {
        name: '', //输入框的值
        effectStatus: '',
        forceUpdate: true
      },
      () => {
        this.search();
      }
    );
  };

  //表格渲染
  renderTable = () => {
    const columns = [
      {
        title: '模板名称',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '开始月份',
        dataIndex: 'startYears',
        key: 'startYears'
      },
      {
        title: '结束月份',
        dataIndex: 'endYears',
        key: 'endYears'
      },
      {
        title: '生效状态',
        dataIndex: 'effectStatus',
        key: 'effectStatus',
        render: (text, record) => (
          <span>
            {record.effectStatus === '未开始' && (
              <span style={{ color: '#ccc' }}>{record.effectStatus}</span>
            )}
            {record.effectStatus === '使用中' && (
              <span style={{ color: '#080' }}>{record.effectStatus}</span>
            )}
            {record.effectStatus === '已过期' && (
              <span style={{ color: '#f00' }}>{record.effectStatus}</span>
            )}
          </span>
        )
      },
      {
        title: '使用人员',
        dataIndex: 'perNum',
        key: 'perNum',
        render: (text, record) => <span> {record.perNum}人</span>
      },
      {
        title: '操作',
        dataIndex: 'operate',
        key: 'operate',
        render: (text, record) => (
          <div>
            <Opton
              onClick={() => {
                this.props.history.push(
                  `/salarymanagement/template/add/${record.comSalaryTempId}/1`
                );
              }}
            >
              编辑
            </Opton>
            <Opton
              onClick={this.copyTemplate.bind(this, record.comSalaryTempId)}
            >
              复制
            </Opton>
            <Opton
              onClick={this.deleteTemplate.bind(
                this,
                record.comSalaryTempId,
                record.perNum
              )}
            >
              删除
            </Opton>
          </div>
        )
      }
    ];
    return (
      <PTable
        style={{ marginTop: 20 }}
        columns={columns}
        url='taskSalaryTempPageComSalaryTemp'
        pageParm={this.state.pageParm}
        forceUpdate={this.state.forceUpdate}
        showTotal={total => `共搜素到${total}条记录`}
      />
    );
  };

  render() {
    return (
      <Container>
        <Tabs>
          <TabPane tab='薪酬模板管理' key='1' />
        </Tabs>
        <Alert
          message={
            <div style={{ color: '#f90' }}>
              <div>
                1、薪酬模板：需要为人员设置薪酬模板并设置相应的规则后，才可根据对应的考勤数据计算生成薪酬数据，相同月份范围内，一个人仅限归属一个薪酬模板；
              </div>
              <div>
                2、复制：系统自动复制已有薪酬模板设置的规则信息，复制后请调整薪酬模板名称及设置相应使用人员；
              </div>
              <div>
                3、删除：模板删除后，不会影响已生成的薪酬核算数据，但请尽快为相关人员设置新模板，以防无法生成新的核算数据。
              </div>
            </div>
          }
          type='warning'
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className='searchpanel'>
          <span>模板名称：</span>
          <Input
            style={{ marginBottom: '10px', width: '214px' }}
            onChange={this.inputKeywordChange}
            value={this.state.name}
            placeholder='请输入模板名称'
            maxLength={50}
          />
          <span className='post'>生效状态:</span>
          <Select
            value={this.state.effectStatus}
            style={{ width: '214px', marginRight: '17px' }}
            onChange={this.handleChangeEffectStatus}
            placeholder='请选择生效状态'
          >
            <Option value=''>全部</Option>
            <Option value='0'>未开始</Option>
            <Option value='1'>使用中</Option>
            <Option value='2'>已过期</Option>
          </Select>
          <Button
            style={{ marginRight: '17px', marginBottom: '16px' }}
            type='primary'
            onClick={this.search}
          >
            搜索
          </Button>
          <Button style={{ marginBottom: '16px' }} onClick={this.resetting}>
            重置
          </Button>
          <div className='btns'>
            <Button
              type='primary'
              onClick={() => {
                this.props.history.push(`/salarymanagement/template/add/00/1`);
              }}
            >
              新增模板
            </Button>
          </div>
        </div>
        {this.renderTable()}
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
  font-size: 14px;
  color: rgba(0,0,0,0.65);
  .searchpanel{
    margin-bottom:16px;
   .post{
     margin:0 8px 0 16px;
   }
 }
`;

const Opton = style.span`{
  font-size: 12px;
  color: #0F71FF;
  cursor:pointer;
  margin-right:8px;
}`;
