import React, { PureComponent } from 'react';
import {
  Tabs,
  Select,
  Input,
  Button,
  message,
  Modal,
  Icon,
  DatePicker,
  Table,
  List,
  Card
} from 'antd';
import moment from 'moment';
import "moment/locale/zh-cn";

import './salarymanagement.less';

const { MonthPicker } = DatePicker;
const monthFormat = 'YYYY-MM';
const { TabPane } = Tabs;
const dateFormat = 'YYYY-MM-DD';
const { Option } = Select;
const { confirm } = Modal;

export default class Accounting extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: true,
      title: this.props.title || '',
      isEditState: false //弹框薪资是否编辑
    };
  }

  componentDidMount = () => {};

  //输入框的书写
  inputKeywordChange = e => {
    console.log(e.target.value.trim());
    this.setState({ keyword: e.target.value.trim() });
  };

  handleChangeReleaseStatus = value => {
    console.log(`selected ${value}`);
    this.setState({
      releaseStatus: value
    });
  };

  // //打开弹框
  // openDetailModal = name => {
  //   console.log(name, 'name');
  //   this.setState({
  //     visible: true,
  //     title: name
  //   });
  // };

  // handleCancel = () => {
  //   this.setState({
  //     visible: false
  //   });
  // };

  //弹框编辑
  editSalary = () => {
    this.setState({
      isEditState: true
    });
  };

  //弹框保存
  saveSalary = () => {
    this.setState({
      isEditState: false
    });
  };

  render() {
    const data = [
      {
        title: 'Title 1',
        content: '呢发'
      },
      {
        title: 'Title 2',
        content: 'gf '
      },
      {
        title: 'Title 3',
        content: 'fds'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      },
      {
        title: 'Title 4',
        content: '呢gf发'
      }
    ];
    return (
      <div>
        <div className='personal-info'>
          <img
            src={require('../../assets/images/avatar.png')}
            alt='打卡人头像'
            width={50}
            height={50}
            style={{ borderRadius: '50%' }}
          />
          <div className='name-job'>
            <p>
              {this.props.title}|{this.props.title}|{this.props.title}
            </p>
            <p>{this.props.title}</p>
          </div>
        </div>
        <div className='work-table'>
          <List
            grid={{ gutter: 0, column: 6 }}
            dataSource={data}
            renderItem={item => (
              <List.Item>
                <Card className='salary-list' title={item.title}>
                  {item.content}
                </Card>
              </List.Item>
            )}
          />
          {/* 薪资状态 */}
          <div>
            <p>薪资状态 </p>
            <table
              style={{
                width: '100%',
                borderTop: '1px solid #e6e6e6',
                borderLeft: '1px solid #e6e6e6'
              }}
            >
              <thead>
                <tr>
                  <td className='td'>核算时间</td>
                  <td className='td'>核算确认</td>
                  <td className='td'>确认时间</td>
                  <td className='td'>员工确认</td>
                  <td className='td'>确认时间</td>
                  <td className='td' />
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>2019-1-1 14:00:00</td>
                  <td className='td'>已确认</td>
                  <td className='td'>2019-1-1 14:40:00</td>
                  <td className='td'>待确认</td>
                  <td className='td' />
                  <td className='td' />
                </tr>
              </tbody>
            </table>
          </div>
          {/* 薪资核算 */}
          <div style={{ marginTop: 16 }}>
            <p>
              <span>
                薪资核算 （
                <span style={{ color: 'red' }}>
                  根据薪资模板规则自动核算，可修改；员工确认后，不可修改。
                </span>
                ）
              </span>
              {this.state.isEditState ? (
                <Button
                  style={{ marginLeft: 186 }}
                  onClick={this.saveSalary}
                  type='primary'
                >
                  保存
                </Button>
              ) : (
                <Button
                  style={{ marginLeft: 186 }}
                  onClick={this.editSalary}
                  type='primary'
                >
                  修改
                </Button>
              )}
            </p>
            <table
              style={{
                width: '100%',
                borderTop: '1px solid #e6e6e6',
                borderLeft: '1px solid #e6e6e6'
              }}
            >
              <thead>
                <tr>
                  <td className='td'>基本工资</td>
                  <td className='td'>绩效工资</td>
                  <td className='td'>岗位津贴</td>
                  <td className='td'>差旅补贴</td>
                  <td className='td'>通讯补贴</td>
                  <td className='td'>餐饮补贴</td>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                </tr>
              </tbody>
              <thead>
                <tr>
                  <td className='td'>其他补贴</td>
                  <td className='td'>迟到扣款</td>
                  <td className='td'>早退扣款</td>
                  <td className='td'>旷工扣款</td>
                  <td className='td'>事假扣款</td>
                  <td className='td'>病假扣款</td>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                </tr>
              </tbody>
              <thead>
                <tr>
                  <td className='td'>工作日加班补贴</td>
                  <td className='td'>休息日加班补贴</td>
                  <td className='td'>节假日加班补贴</td>
                  <td className='td' />
                  <td className='td' />
                  <td className='td' />
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td' />
                  <td className='td' />
                  <td className='td' />
                </tr>
              </tbody>
              <thead>
                <tr>
                  <td className='td'>个人所得税</td>
                  <td className='td'>代扣医保</td>
                  <td className='td'>代扣养老金</td>
                  <td className='td'>代扣公积金</td>
                  <td className='td'>代扣失业金</td>
                  <td className='td' />
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td' />
                </tr>
              </tbody>
              <thead>
                <tr>
                  <td className='td'>税前工资</td>
                  <td className='td'>计税工资</td>
                  <td className='td'>税后工资</td>
                  <td className='td'>应发工资</td>
                  <td className='td'>实发工资</td>
                  <td className='td' />
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td' />
                </tr>
              </tbody>
            </table>
          </div>
          {/* 考勤情况 */}
          <div style={{ marginTop: 16, marginBottom: 20 }}>
            <p>考勤情况（2018.12.01~2018.12.31） </p>
            <table
              style={{
                width: '100%',
                borderTop: '1px solid #e6e6e6',
                borderLeft: '1px solid #e6e6e6'
              }}
            >
              <thead>
                <tr>
                  <td className='td'>出勤天数</td>
                  <td className='td'>休息天数</td>
                  <td className='td'>工作总时长</td>
                  <td className='td'>迟到次数</td>
                  <td className='td'>早退次数</td>
                  <td className='td'>漏卡次数</td>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                </tr>
              </tbody>
              <thead>
                <tr>
                  <td className='td'>缺勤天数</td>
                  <td className='td'>工作日加班</td>
                  <td className='td'>休息日加班</td>
                  <td className='td'>节假日加班</td>
                  <td className='td'>事假时长</td>
                  <td className='td'>病假时长</td>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td className='td'>111</td>
                  <td className='td'>3434</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                  <td className='td'>444</td>
                  <td className='td'>555</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    );
  }
}
