import React, { PureComponent } from 'react';
import { Spin } from 'antd';
import style from 'styled-components';

const store = require('store');
const welcomeImg = require('../../assets/images/welcome.jpg');

export default class System extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      loading: false
    };
  }

  componentDidMount = () => {
    // 隐藏左侧菜单栏
    document.querySelector('.ant-layout-sider').style.display = 'none';
    document.querySelector('.ant-layout-content').style.margin = '0px';
    document.querySelector('.oneKeySearchHidden').style.display = 'none';
    window.open(store.get('PublicSafetySystemURL')['PublicSafetySystemURL'])
    // 判断iframe是否加载完毕
    // const iframe = this.refs.iframe;
    // const that = this;
    // if (iframe.attachEvent) {
    //   iframe.attachEvent('onload', function() {
    //     that.setState({
    //       loading: false
    //     });
    //   });
    // } else {
    //   iframe.onload = function() {
    //     that.setState({
    //       loading: false
    //     });
    //   };
    // }
  };

  componentWillUnmount() {
    // 显示左侧菜单栏
    document.querySelector('.ant-layout-sider').style.display = 'block';
    document.querySelector('.ant-layout-content').style.margin = '16px';
    document.querySelector('.oneKeySearchHidden').style.display = 'block';
  }

  render() {
    return (
      <Spin spinning={this.state.loading}>
        <Container>
          {store.get('PublicSafetySystemURL') !== undefined ? (
            <div style={{ height: 'inherit' }}>
              <div style={{width:'100%',height:'600px',display:'block',margin:'50px auto',textAlign:'center'}}>
                <img src={welcomeImg} />
                <div style={{fontSize: '18px',marginTop: '30px',color: '#666'}}>{`请前往新窗口查看`}</div>
              </div>
              {/* <iframe
                title="风险评估"
                src={
                  store.get('PublicSafetySystemURL')['PublicSafetySystemURL']
                }
                width="100%"
                height="100%"
                frameBorder="0"
                allowFullScreen={true}
                // allowTranSparency='true'
                style={{ height: 'calc(100vh - 77px)',display:'none' }}
                ref="iframe"
              >
                您的浏览器不支持iframe，请升级
              </iframe> */}
            </div>
          ) : (
            ''
          )}
        </Container>
      </Spin>
    );
  }
}

const Container = style.div`
  width:100%;
  height:100%;
`;
