import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Table,
  Select,
  Alert,
  DatePicker,
  notification,
  Modal
} from 'antd';
import moment from "moment";
import { withRouter } from 'dva/router';
import PTable from '../../../../components/Pro/PTable';
import DownloadXls from '../../../../components/DownloadXls'
import { getCommitBayzgzSbList, systemComDepartGetTreeDepart, revokeBayzgzSbApply } from '../../../../services/api';
import SubDrawer from './SubDrawer';
const { Option } = Select;
const { RangePicker } = DatePicker;
const dateFormat = "YYYY-MM-DD";
@connect(state => ({
  global: state.global
}))
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //刷新数据
      name: '',  //姓名
      mobilePhone: '',//手机号
      idCardNo: '',//身份证
      approvalStatus: '',//审核状态
      examResult: '',//考试结果
      startDate: '',//开始日期
      endDate: '',//结束日期
      payStatus: '', //缴费状态
      // 搜索部分
      searchData: {  // 表格数据请求参数
        name: '',  //姓名
        mobilePhone: '',//手机号
        idCardNo: '',//身份证
        approvalStatus: '',//审核状态
        examResult: '',//考试结果
        payStatus: '',//缴费状态
        startDate: '',//开始日期
        endDate: '',//结束日期
        pageNumber: 1,  // 页	
        pageSize: 10  //条目
      },
      // keyWord: '', //关键字
      // departId: '', //部门id
      // treeData: [  // 部门数据
      //   //树
      //   { title: '', key: '' }
      // ],
      approvaltList: [{ label: '全部', value: '' }, 
      // { label: '未提交', value: '001' }, 
      { label: '待审批', value: '002' }, { label: '审批通过', value: '003' }, { label: '审批不通过', value: '004' }, { label: '审批中', value: '005' }],
      examList: [{ label: '全部', value: '' }, { label: '考试不通过', value: '0' }, { label: '考试通过', value: '1' }, { label: '未考试', value: '2' }],
      // 表格部分
      tableList: [], // 表格数据
      pagination: {  //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true,
        pageSizeOptions: ['10', '50', '100', '500'],
      },
      //抽屉
      drawerVisble: false,
      bayzgzSbId: null,
      currentPtableData: [],//当前表格显示的人员信息
    };
  }

  componentDidMount() {

  }
  _renderCancel(record) {
    const _this = this;
    //payStatus 0 未缴费 1已缴费
    //approvalStatus 未提交001 待审批002 审批通过 003 审批不通过004 审批中005
    // backgroundScreenStatus 未筛查001 筛查通过003 筛选不通过004 未审查''
    const { payStatus, bayzgzSbId, approvalStatus, backgroundScreenStatus } = record;
    if (payStatus == '0' && (approvalStatus == '002' || approvalStatus == '005') && backgroundScreenStatus == '003') {
      return (
        <span style={{ color: 'red', cursor: 'pointer', }}
          onClick={() => {
            // const _this = this;
            Modal.confirm({
              title: '确定撤销？',
              okText: '确定',
              cancelText: '取消',
              maskClosable: true,
              // content: <p stype={{padding: 15}}>确定撤销？</p>,
              onOk() {
                revokeBayzgzSbApply({ bayzgzSbIds: bayzgzSbId, revokeReason: '报名方撤销申报' }).then(res => {
                  const { failList } = res.data;
                  if (failList.length > 0) {
                    notification.error({
                      message: failList[0].message
                    });
                  } else {
                    _this.setState({
                      forceUpdate: true
                    }, () => {
                      _this.setState({
                        forceUpdate: false
                      });
                    });
                    notification.success({
                      message: '操作成功'
                    });
                  }
                });
              },
              onCancel() { }
            });
          }}
        >撤销</span>
      );
    }
    return '';
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '手机号码',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone',
        render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo',
        render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
      },
      {
        title: '报名时间',
        dataIndex: 'submitTime',
        key: 'submitTime'
      },
      {
        title: '背景筛查',
        dataIndex: 'backgroundScreenStatus',
        key: 'backgroundScreenStatus',
        render: (text, record) => {
          return <span style={{ color: text === '004' ? 'red' : '' }}>{text === '001' ? '未筛查' : text === '003' ? '筛查通过' : text === '004' ? '筛选不通过' : '未审查'}</span>;
        }
      },
      {
        title: '审批状态',
        dataIndex: 'approvalStatus',
        key: 'approvalStatus',
        render: (text, record) => {
          return <span style={{ color: text === '004' ? 'red' : '' }}>{text === '001' ? '未提交' : text === '002' ? '待审批' : text === '003' ? '审批通过' : text === '004' ? '审批不通过' : text === '005' ? '审批中' : text}</span>;
        }
      },
      {
        title: '缴费状态',
        dataIndex: 'payStatus',
        key: 'payStatus',
        render: (text, record) => {
          return <span>{text === '0' ? '未缴费' : text === '1' ? '已缴费' : '未缴费'}</span>;
        }
      },
      {
        title: '考试安排',
        dataIndex: 'isArrangeExam',
        key: 'isArrangeExam',
        render: (text, record) => {
          return <span>{text === '0' ? '未安排考试' : text === '1' ? '已安排考试' : '未安排'}</span>;
        }
      },
      {
        title: '考试结果',
        dataIndex: 'examResult',
        key: 'examResult',
        render: (text, record) => {
          let color = '';
          let txt = '-';
          if(text === '0') {
            color = 'red';
            txt = '考试不通过';
          }else if(text === '1') {
            color = 'green';
            txt = '考试通过';
          }else if(text === '2') {
            color = '#999';
            txt = '未考试';
          }
          return <span style={{color}}>{txt}</span>;
        }
      },
      {
        title: '理论成绩',
        dataIndex: 'writtenScore',
        key: 'writtenScore',
        render: (text, record) => {
          return <span>{text ? text : '-'}</span>;
        }
      },
      {
        title: '实操成绩',
        dataIndex: 'operateScore',
        key: 'operateScore'
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        render: (text, record) => (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                console.log(record)
                // this.setState({
                //   drawerVisble: true
                // });
                // this.props.history.push('/PoliceDeclare/sign-up/fill-in');
                this.setState({
                  drawerVisble: true,
                  bayzgzSbId: record.bayzgzSbId
                });
              }}
            >
              查看
            </span>
            {this._renderCancel(record)}
            {/* {(() => {
              const _this = this;
              //payStatus 0 未缴费 1已缴费
              //approvalStatus 未提交001 待审批002 审批通过 003 审批不通过004 审批中005
              // backgroundScreenStatus 未筛查001 筛查通过003 筛选不通过004 未审查''
              const { payStatus, bayzgzSbId, approvalStatus, backgroundScreenStatus } = record;
              if (payStatus == '0' && (approvalStatus == '002' || approvalStatus == '005') && backgroundScreenStatus == '003') {
                return (
                  <span style={{ color: 'red', cursor: 'pointer', }}
                    onClick={() => {
                      // const _this = this;
                      Modal.confirm({
                        title: '确定撤销？',
                        okText: '确定',
                        cancelText: '取消',
                        maskClosable: true,
                        // content: <p stype={{padding: 15}}>确定撤销？</p>,
                        onOk() {
                          revokeBayzgzSbApply({ bayzgzSbIds: bayzgzSbId, revokeReason: '报名方撤销申报' }).then(res => {
                            const { failList } = res.data;
                            if (failList.length > 0) {
                              notification.error({
                                message: failList[0].message
                              });
                            } else {
                              _this.setState({
                                forceUpdate: true
                              }, () => {
                                _this.setState({
                                  forceUpdate: false
                                });
                              });
                              notification.success({
                                message: '操作成功'
                              });
                            }
                          });
                        },
                        onCancel() { }
                      });
                    }}
                  >撤销</span>
                );
              }
              return '';
            })()} */}
          </div>
        )
      }
    ];
    return (
      <div>
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="getCommitBayzgzSbList"
          // url="getNoCommitBayzgzSbList"
          pageParm={this.state.searchData}
          forceUpdate={this.state.forceUpdate}
          dateChange={(e) => { this.setState({ currentPtableData: e.data }) }}
        />
      </div>
    );
  };

  render() {
    const { approvalStatus, examResult, startDate, endDate, name, mobilePhone, idCardNo, payStatus } = this.state.searchData;
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>人员若存在待提交/待审批/审批中/审批通过的报名记录，则无法再重新报名；审核不通过的需要重新提交报名申报。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className="form">
          <label style={{ marginRight: 18 }}>
            姓名：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入姓名"
              value={this.state.name}
              onChange={(e) => {
                this.setState({
                  name: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          <label style={{ marginRight: 18 }}>
            手机号：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入手机号码"
              value={this.state.mobilePhone}
              onChange={(e) => {
                this.setState({
                  mobilePhone: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          <label style={{ marginRight: 18 }}>
            身份证：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入身份证"
              value={this.state.idCardNo}
              onChange={(e) => {
                this.setState({
                  idCardNo: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          <label style={{ marginRight: 18 }}>
            审核状态：
            <Select style={{ width: '200px' }} placeholder="全部" value={this.state.approvalStatus} onChange={(e) => {
              this.setState({
                approvalStatus: e
              })
            }}>
              {
                this.state.approvaltList.map((val) => {
                  return <Option key={val.label} value={val.value}>{val.label}</Option>;
                })
              }
            </Select>
          </label>
          <label style={{ marginRight: 18 }}>
            考试结果：
            <Select style={{ width: '200px' }} placeholder="全部" value={this.state.examResult} onChange={(e) => {
              this.setState({
                examResult: e
              })
            }}>
              {
                this.state.examList.map((val) => {
                  return <Option key={val.label} value={val.value}>{val.label}</Option>;
                })
              }
            </Select>
          </label>
          <br/>
          <label style={{ marginRight: 18 }}>
           缴费状态： 
            <Select style={{ width: '200px' }} placeholder="全部" value={this.state.payStatus} onChange={(e) => {
              this.setState({
                payStatus: e
              })
            }}>
              <Option value={''}>全部</Option>
              <Option value={'0'}>未缴费</Option>
              <Option value={'1'}>已缴费</Option>
            </Select>
          </label>
          <label style={{ marginRight: 18 }}>
            报名时间：
            <RangePicker
              format={dateFormat}
              onChange={(e, dateString) => {
                this.setState({
                  startDate: dateString[0],
                  endDate: dateString[1]
                })
              }}
              value={[
                this.state.startDate
                  ? moment(this.state.startDate, dateFormat)
                  : null,
                this.state.endDate ? moment(this.state.endDate, dateFormat) : null
              ]}
            />
          </label>
          <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              this.setState({
                searchData: {
                  name: this.state.name,  //关键字
                  mobilePhone: this.state.mobilePhone,
                  idCardNo: this.state.idCardNo,
                  approvalStatus: this.state.approvalStatus,//审核状态
                  examResult: this.state.examResult,//考试结果
                  payStatus: this.state.payStatus,//缴费状态
                  startDate: this.state.startDate,//开始日期
                  endDate: this.state.endDate,//结束日期
                  pageNumber: 1,  // 页	
                  pageSize: 10,  //条目
                },
                forceUpdate: true //对列表进行刷新
              }, () => {
                this.setState({
                  forceUpdate: false
                });
              });
              // this.__getTable(this.state.searchData);
            }}
          >
            搜索
          </Button>
          <Button
            onClick={() => {
              this.setState({
                name: '',  //姓名
                mobilePhone: '',//手机号
                idCardNo: '',//身份证
                approvalStatus: '',//审核状态
                examResult: '',//考试结果
                startDate: '',//开始日期
                endDate: '',//结束日期
                payStatus: '',
                searchData: {
                  name: '',  //姓名
                  mobilePhone: '',//手机号
                  idCardNo: '',//身份证
                  approvalStatus: '',//审核状态
                  examResult: '',//考试结果
                  payStatus: '',//缴费状态
                  startDate: '',//开始日期
                  endDate: '',//结束日期
                  pageNumber: 1,  // 页	
                  pageSize: 10,  //条目
                },
                forceUpdate: true, //对列表进行刷新
              }, () => {
                this.setState({
                  forceUpdate: false,
                })
              });
            }}
            style={{
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
          >
            重置
          </Button>
        </div>
        <div>
        <Button type="primary" style={{marginRight: 15}} onClick={() => {
            this.props.history.push({
              pathname: '/PoliceDeclare/sign-up/fill-in',
              bayzgzSbId: ''
            });
          }}>新增报名</Button>
          <DownloadXls
            method="post"
            buttonName='导出筛选结果'
            visible={!this.state.currentPtableData.length > 0}
            url='/public/bayzgz-sb/export-committed-bayzgz-sb-info'
            searchData={{
              approvalStatus,
              examResult,
              payStatus,
              startDate,
              endDate,
              name,
              mobilePhone,
              idCardNo
            }}
            fileName={`[` + this.props.global.companyInfo.comName + `]_报名数据_[` + moment().format('YYYY-MM-DD HH:mm:ss') + `].xls`}>
          </DownloadXls>
        </div>
        <div className="receive-list">
        </div>
        {this.renderOrderList()}

        {/* 修改弹窗 */}
        <SubDrawer
          visible={this.state.drawerVisble}
          value={this.state.bayzgzSbId}
          close={() => {
            this.setState({
              drawerVisble: false,
              bayzgzSbId: null
            });
          }}
        />
      </div >
    );
  }
}
