import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Alert,
  TreeSelect,
  Modal
} from 'antd';
import "moment/locale/zh-cn";
import PTable from '../../../../components/Pro/PTable';
import { withRouter } from 'dva/router';
import { systemComDepartGetTreeDepart, getConfigBayzgzSb, publicBayzgzSbDeleteBayzgzTemp } from '../../../../services/api';
import $modal from '../../../../utils/modal';
import '../../declaration.less';
@connect(state => ({
  global: state.global
}))
@withRouter
export default class NotSubmitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //刷新数据
      keyWord: '', //关键字
      departId: null, //部门id
      // 搜索部分
      searchData: {  // 表格数据请求参数
        keyword: '',  //关键字
        departId: null, //部门id
        pageNumber: 1,  // 页	
        pageSize: 10  //条目
      },
      // treeData: [  // 部门数据
      //   //树
      //   { title: '', key: '' }
      // ],
      // 表格部分
      // tableList: [], // 表格数据
      declareNotice: '',//指南
      pagination: {  //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true,
        pageSizeOptions: ['10', '50', '100', '500'],
      },
    };
  }

  componentDidMount() {
    //获取部门树数据
    // this.__getDepart();
    this.__getConfigBayzgzSb()
  }

  //获取部门树数据
  __getDepart = (cb) => {
    //获取部门树数据
    systemComDepartGetTreeDepart().then(
      response => {
        let { data } = response;
        data = JSON.parse(
          JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
        );
        data.unshift({
          title: '全部',
          value: '0'
        });
        this.setState({
          treeData: data
        }, () => {
          cb && cb();
        });
      },
      err => {
        console.log(err, 'getTreeDepart-选择部门-err');
      }
    );
  }
  //获取保安员指南
  __getConfigBayzgzSb() {
    getConfigBayzgzSb().then(
      res => {
        if (res.retType === '0') {
          this.setState({
            declareNotice: res.data.declareNotice
          })
        }
      }
    )
  }
  // 获取表格信息
  // __getTable = (data, cb) => {
  //   getNoCommitBayzgzSbList(data).then(res => {
  //     console.log(res)
  //     console.log("1111")
  //     console.log(data)
  //     const { comName } = this.props.global.companyInfo;
  //     const tableList = res.data.data.map(item => {
  //       if (item.departName == '-') {
  //         item.departName = comName;
  //       }
  //       return item;
  //     });
  //     this.setState({
  //       tableList,
  //     }, () => {
  //       cb && cb(res.data);
  //       // this.props.refresh();
  //     });
  //   });
  // }

  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name'
      },
      {
        title: '手机号',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone',
        render: text => text.replace(/(\d{3})\d{4}(\d{4})/,'$1****$2')
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo',
        render: text => text.replace(/(\d{4}).*(\d{3})/,'$1***********$2')
      },
      // {
      //   title: '部门',
      //   dataIndex: 'departName',
      //   key: 'departName',
      //   render: (text, record) => {
      //     if (record.departName) {
      //       return <span>{record.departName}</span>;
      //     } else {
      //       return <span>{this.state.treeData[1].label}</span>;
      //     }
      //   }
      // },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        render: (text, record) => (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.props.history.push({
                  pathname: '/PoliceDeclare/sign-up/fill-in',
                  bayzgzSbId: record.bayzgzSbId
                });
              }}
            >
              修改
            </span>
            <span
              style={{
                color: '#D9001B',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                const { bayzgzSbId, name } = record;
                $modal(`确定删除${name}的暂存记录？`, '', [
                  { text: '确定', type: 'primary', onPress: () => {
                    publicBayzgzSbDeleteBayzgzTemp({bayzgzSbId}).then(res=> {
                      this.setState({
                        forceUpdate: true
                      }, () => {
                        this.setState({
                          forceUpdate: false
                        });
                      });
                    });

                  } },
                  { text: '取消' }
                ]);
              }}
            >
              删除
            </span>
          </div>
        )
      }
    ];
    // if(!this.state.treeData) {
    //   return null;
    // }
    return (
      <div>
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="getNoCommitBayzgzSbList"
          pageParm={this.state.searchData}
          forceUpdate={this.state.forceUpdate}
        />
      </div>
    );
  };

  render() {
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>报名前请仔细阅读
              <a onClick={() => {
                Modal.info({
                  className: 'anbao-modal',
                  maskClosable: true,
                  // title: '保安员资格考试报名办理指南',
                  content: (
                    <div dangerouslySetInnerHTML={{
                      __html: this.state.declareNotice
                    }} />
                  )
                });
              }}>《保安员资格考试报名办理指南》</a>，了解相关章程及规定。</span>
            <br />
            <span>本页面为待提交页面，新增报名记录暂存的，将显示在本页面，若人员离职，暂存记录将被删除。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className="form">
          <label style={{ marginRight: 16 }}>
            关键字：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入姓名/手机号码/身份证"
              value={this.state.keyWord}
              onChange={(e) => {
                this.setState({
                  keyWord: e.target.value
                });
              }}
              maxLength={20}
            />
          </label>
          {/* <label style={{ marginRight: 16 }}>
            部门：
            <TreeSelect
              style={{ width: 240 }}
              // className="w-400 ipt-h"
              dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
              treeData={this.state.treeData}
              placeholder="全部"
              treeDefaultExpandAll
              value={this.state.departId}
              onChange={value => {
                this.setState({
                  departId: value
                });
              }}
            />
          </label> */}
          <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              this.setState({
                searchData: {
                  keyWord: this.state.keyWord,
                  departId: this.state.departId,
                  pageNumber: 1,  // 页	
                  pageSize: 10  //条目
                },
                forceUpdate: true //对列表进行刷新
              }, () => {
                this.setState({
                  forceUpdate: false
                });
              });
            }}
          >
            搜索
          </Button>
          <Button
            onClick={() => {
              this.setState({
                keyWord: '',  //关键字
                departId: null,
                searchData: {
                  keyword: '',  //关键字
                  departId: null,
                  pageNumber: 1,  // 页	
                  pageSize: 10,  //条目
                },
                forceUpdate: true, //对列表进行刷新
              }, () => {
                this.setState({
                  forceUpdate: false,
                })
              });
            }}
            style={{
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
          >
            重置
          </Button>
        </div>
        <div className="add">
          <Button type="primary" onClick={() => {
            this.props.history.push({
              pathname: '/PoliceDeclare/sign-up/fill-in',
              bayzgzSbId: ''
            });
          }}>新增报名</Button>
        </div>
        <div className="receive-list">
        </div>
        {this.renderOrderList()}
      </div >
    );
  }
}
