import React, { Component } from 'react';
import { connect } from 'dva';
import { withRouter } from 'dva/router';

import PTable from '../../../../components/Pro/PTable';
import columnsFun from './contractColumn';
// import { systemComDepartGetTreeDepart } from '../../../../services/api';
import {
  Alert,
  Button,
  Modal
} from "antd";
@connect(state => ({
  global: state.global
}))
@withRouter
export default class NoCert extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: { //任务列表请求参数
        pageSize: '10',
        pageNumber: '1'
      },
      paramsInit: false, //参数是否准备好
    }
  }


  componentWillReceiveProps(props) {
    const { perId } = props;
    if(!!perId && perId != this.state.pageParm.perId) {
      this.setState({
        pageParm: {
          ...this.state.pageParm,
          perId
        }
      });
    }
    if(!!perId) {
      this.setState({
        paramsInit: true
      });
    }else {
      this.setState({
        paramsInit: false
      });
    }
  }
  componentDidMount() {

  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <Modal
        title="关联合同"
        width={'70%'}
        okText="确定"
        footer={null}
        visible={!!this.props.perId}
        {...this.props}
        // onCancel={this.props.onCancel}
      >
        <Alert
          message={<div>
            <span>
              若您需要新增/编辑合同信息，请到【合同管理】中操作。
            </span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        {
          this.state.paramsInit && 
          <PTable
            style={{ marginTop: 20 }}
            columns={columns}
            url="getComContractListByPerId"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{ showTotal: total => `总共 ${total} 条` }}
          />
        }
      </Modal>
    );
  }
}
