import React, { Component } from "react";
import { connect } from "dva";

import Submitted from './Submitted';
import UnSubmits from './UnSubmits';
import { gup } from '../../../utils/utils';
import { Tabs, Modal } from "antd";
import declare from '../../../utils/hoc/declare';
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
@declare
export default class GradeCertificate extends Component {
  constructor(props, context) {
    super(props, context);
    this.state={
      tab: '1'
    };
  }

  componentWillMount(){
    const tab = gup('tab');
    if(tab) {
      this.setState({
        tab
      });
    }
  }
  componentDidMount() {
  }
  render() {
    if(this.props.showModal) {
      return '';
    }
    return (
      <div  style={{paddingTop:'10px'}}>
       <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          defaultActiveKey={this.state.tab}
        >
          
          <TabPane forceRender
            tab={`已提交`}
            key="1"
          >
            <Submitted></Submitted>
          </TabPane>
          <TabPane forceRender
            tab={'未报名'}
            key="2"
          >
            <UnSubmits></UnSubmits>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
