
import { Badge } from 'antd';
export function contranctCol() {
  return [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
    },
    {
      title: '合同类型',
      dataIndex: 'contractType',
      key: 'contractType',
    },
    {
      title: '企业档案编号',
      dataIndex: 'comFileNo',
      key: 'comFileNo',
    },
    // {
    //   title: '甲方名称',
    //   dataIndex: 'firstPartyName',
    //   key: 'firstPartyName',
    // },
    {
      title: '乙方名称',
      dataIndex: 'secondPartyName',
      key: 'secondPartyName',
    },
    // {
    //   title: '丙方名称',
    //   dataIndex: 'thirdPartyName',
    //   key: 'thirdPartyName',
    // },
    {
      title: '合同有效期',
      dataIndex: 'effectEndDate',
      render: (text, record) => {
        return `${record.effectStartDate}~${record.effectEndDate}`;
      }
    },
    {
      title: '合同状态',
      dataIndex: 'contractEffect',
      key: 'contractEffect',
      // width: 100,
      render: (text, record) => {
        let status = '';
        switch (true) {
          case text == '未生效':
            status = 'warning';
            break;
          case text == '有效':
            status = 'success';
            break;
          case text == '终止':
            status = 'error';
        }

        return (
          <div>
            <Badge status={status} />
            <span>{text}</span>
          </div>
        );
      }
    },
    // {
    //   title: '操作',
    //   dataIndex: 'op',
    //   key: 'op',
    //   render: () => {
    //     return (
    //       <a>移除关联</a>
    //     )
    //   }
    // },
  ];
}
export function familyCol() {
  return [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
      width: '15%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayFamilyMemberDtoList',
                e.target.value,
                'name',
                record.familyMemberId,
                'familyMemberId'
              )
            }
            placeholder="请输入姓名"
            maxLength={10}
          />
        );
      }
    },
    {
      title: '成员关系',
      dataIndex: 'relation',
      key: 'relation',
      width: '15%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            // autoFocus
            onChange={e =>
              this.$handleFieldChange(
                'bayFamilyMemberDtoList',
                e.target.value,
                'relation',
                record.familyMemberId,
                'familyMemberId'
              )
            }
            placeholder="请输入成员关系"
            maxLength={10}
          />
        );
      }
    },
    {
      title: '证件类型',
      dataIndex: 'idCardType',
      key: 'idCardType',
      width: '15%',
      render: (text, record) => {
        return (
          <PSelect
            type="idCardType_bak"
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayFamilyMemberDtoList',
                e,
                'idCardType',
                record.familyMemberId,
                'familyMemberId'
              )
            }
          />
        );
      }
    },
    {
      title: '证件号码',
      dataIndex: 'idCardNo',
      key: 'idCardNo',
      width: '25%',
      render: (text, record) => {
        console.log(record);
        return (
          <Form.Item style={{ marginBottom: 0 }}>
            {getFieldDecorator(record.familyMemberId + 'idCardNo', {
              initialValue: text,
              rules: [
                {
                  required: false
                },
                {
                  pattern:
                    record.idCardType === '1'
                      ? /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/
                      : null,
                  message: '证件格式错误'
                }
              ]
            })(
              <Input
                value={text}
                // autoFocus
                onChange={e =>
                  this.$handleFieldChange(
                    'bayFamilyMemberDtoList',
                    e.target.value,
                    'idCardNo',
                    record.familyMemberId,
                    'familyMemberId'
                  )
                }
                placeholder="请输入证件号码"
                maxLength={20}
              />
            )}
          </Form.Item>
        );
      }
    },
    {
      title: '联系电话',
      dataIndex: 'contactPhone',
      key: 'contactPhone',
      width: '20%',
      render: (text, record) => {
        return (
          // <Input
          //   value={text}
          //   onChange={e => this.$handleFieldChange("bayFamilyMemberDtoList", e.target.value, 'contactPhone', record.familyMemberId, 'familyMemberId')}
          //   placeholder="请输入联系电话"
          //   maxLength={11}
          // />
          <Form.Item style={{ marginBottom: 0 }}>
            {getFieldDecorator(record.familyMemberId + 'contactPhone', {
              initialValue: text,
              rules: [
                {
                  required: false
                },
                {
                  validator: this.checkPhone
                }
              ]
            })(
              <Input
                // value={text}
                onChange={e =>
                  this.$handleFieldChange(
                    'bayFamilyMemberDtoList',
                    e.target.value,
                    'contactPhone',
                    record.familyMemberId,
                    'familyMemberId'
                  )
                }
                placeholder="请输入联系电话"
                maxLength={11}
              />
            )}
          </Form.Item>
        );
      }
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      width: '20%',
      render: (text, record) => (
        <div>
          <span
            style={{
              color: '#D9001B',
              cursor: 'pointer',
              marginRight: '20px'
            }}
          >
            <Popconfirm
              title="是否要删除此行？"
              onConfirm={e =>
                this.$remove(
                  'bayFamilyMemberDtoList',
                  record.familyMemberId,
                  'familyMemberId'
                )
              }
            >
              <a>删除</a>
            </Popconfirm>
          </span>
        </div>
      )
    }
  ];
}


export function workCol() {
  return [
    {
      title: '公司名称',
      dataIndex: 'comName',
      key: 'comName',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                e.target.value,
                'comName',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            // onKeyPress={e => this.handleKeyPress(e, record.key)}
            placeholder="请输入公司名称"
            maxLength={40}
          />
        );
      }
    },
    {
      title: '职务',
      dataIndex: 'position',
      key: 'position',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                e.target.value,
                'position',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入职务"
            maxLength={30}
          />
        );
      }
    },
    {
      title: '工作内容',
      dataIndex: 'workContent',
      key: 'workContent',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                e.target.value,
                'workContent',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入工作内容"
            maxLength={50}
          />
        );
      }
    },
    {
      title: '入职时间',
      dataIndex: 'entryDate',
      key: 'entryDate',
      width: '17%',
      render: (text, record) => {
        return (
          <DatePicker
            disabledDate={current => {
              return current && current > moment(parseInt(sessionStorage.getItem('requestDate'))).endOf('day');
            }}
            format={dateFormat}
            defaultValue={text ? moment(text, dateFormat) : null}
            onChange={(e, date) =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                date,
                'entryDate',
                record.workExperienceId,
                'workExperienceId'
              )
            }
          />
        );
      }
    },
    {
      title: '离职时间',
      dataIndex: 'leaveDate',
      key: 'leaveDate',
      width: '17%',
      render: (text, record) => {
        return (
          <DatePicker
            format={dateFormat}
            defaultValue={text ? moment(text, dateFormat) : null}
            onChange={(e, date) =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                date,
                'leaveDate',
                record.workExperienceId,
                'workExperienceId',
                record.entryDate
              )
            }
          />
        );
      }
    },
    {
      title: '离职原因',
      dataIndex: 'leaveReason',
      key: 'leaveReason',
      width: '14%',
      render: (text, record) => {
        return (
          <Input
            value={text}
            onChange={e =>
              this.$handleFieldChange(
                'bayWorkExperienceDtoList',
                e.target.value,
                'leaveReason',
                record.workExperienceId,
                'workExperienceId'
              )
            }
            placeholder="请输入离职原因"
            maxLength={50}
          />
        );
      }
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      render: (text, record) => (
        <div>
          <span
            style={{
              color: '#D9001B',
              cursor: 'pointer',
              marginRight: '20px'
            }}
          >
            <Popconfirm
              title="是否要删除此行？"
              onConfirm={e =>
                this.$remove(
                  'bayWorkExperienceDtoList',
                  record.workExperienceId,
                  'workExperienceId'
                )
              }
            >
              <a>删除</a>
            </Popconfirm>
          </span>
        </div>
      )
    }
  ];
}