import React, { PureComponent } from 'react';
import { Tabs, Modal } from 'antd';
import style from "styled-components";
import { connect } from "dva";
import NoAuthority from '../../common/NoAuthority';
const store = require("store");
import declare from '../../utils/hoc/declare';
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
@declare
export default class DeclarationList extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      modalVisible: false
    };
  }

  componentDidMount = () => {
    //sessionId
    console.log(store.get("DeclarationListURL")["DeclarationListURL"])
    console.log('百课堂＝＝store.get("saas")["sessionId"]', store.get("saas")["sessionId"]);
  }
  render() {
    if (this.props.showModal) {
      return '';
    }
    return <Container>
        <Tabs>
          <TabPane tab="公安机关通知" key="1" />
        </Tabs>
        {store.get("policeNoticeURL") !== undefined ? (
          <iframe title="公安机关通知" src={store.get("policeNoticeURL")["policeNoticeURL"]} width="100%" height="100%" frameBorder="0">
            您的浏览器不支持iframe，请升级
            </iframe>
        ) : (
            <NoAuthority></NoAuthority>
          )}
      </Container>
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
