import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import {
  Input,
  Button,
  Table,
  Select,
  Alert,
  DatePicker,
  notification,
  Modal,
  Tooltip
} from 'antd';
import moment from "moment";
import { withRouter } from 'dva/router';
import BTable from '../../../../components/Pro/BTable';
import DownloadXls from '../../../../components/DownloadXls';
import SearchForm from './SearchForm';
import columnFun from './columns';
import store from 'store';
import { getCommitBayzgzSbList, systemComDepartGetTreeDepart, revokeBayzgzSbApply } from '../../../../services/api';
import SubDrawer from './SubDrawer';

@connect(state => ({
  global: state.global,
  companyInfo: state.global.companyInfo
}))
@withRouter
export default class Submitted extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //刷新数据
      // 搜索部分
      searchData: {  // 表格数据请求参数
        pageNumber: 1,  // 页	
        pageSize: 10  //条目
      },
      //抽屉
      drawerVisble: false,
      personApplyId: '',  //当前选中的id
    };
  }

  // 判断是否是北京地区(北京地区隐藏劳动合同、户籍类型、户籍所在地三个字段)
  checkBeijinCode() {
    let regProvince = String(this.props.companyInfo.regProvince);
    return regProvince && regProvince.indexOf('110') == 0
  }
  // 判断是否为商洛地区
  checkSRAreaCode = () => {
    let regCity = String(this.props.companyInfo.regCity);
    return regCity && regCity.indexOf('611000') == 0
  }

  componentDidMount() {
    //获取部门树数据
    // this.__getDepart();
    // this.__getTable(this.state.searchData, data => {
    // });
  }



  _search = values => {
    this.setState({
      searchData: {
        ...this.state.searchData,
        ...values
      },
      isInit: true
    }, () => {
      // console.log(this.state.searchData, 'sss-->')
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  // 表格渲染
  _renderList = () => {
    const columns = columnFun.call(this);
    if (!this.state.isInit) return;
    return (
      <BTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="trainGradeApplyLearnPage"
        // url="getNoCommitBayzgzSbList"
        pageParm={this.state.searchData}
        forceUpdate={this.state.forceUpdate}
        scroll={{ x: '3200px' }}
        dateChange={(e) => { }}
      />
    );
  };

  render() {
    return (
      <div className="tab_inner">
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>本页面为已提交保安等级证报名记录，您可查看人员的报名记录情况；</span>
            <br />
            <span>每个人员仅可同时报名一条记录，当申报状态为“申报不通过/已撤销”时，可重新报名；人员的学习进度跟实习记录不会被清除，下次报名时，将同步获取上一次学习实习数据。</span>

            {/* <span>本页面为已提交保安等级证报名记录；当报名记录状态为“可报名”时，可访问【培训】-【课程列表】选择保安员等级证。</span> */}
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          onSearch={this._search}
        />
        <Btns>
        {this.checkBeijinCode()?'':
          <Button style={{ marginRight: 15 }} onClick={() => {
            this.props.history.push('/PoliceDeclare/grade-certificate/add');
          }} type="primary">新增报名</Button>
        } 
          <Button
            type="primary"
            onClick={() => {
              const { searchData } = this.state;
              let queryStr = '';
              Object.keys(searchData).forEach(key => {
                queryStr += `${key}=${searchData[key]}&`;
              });
              queryStr = '?' + queryStr.slice(0, -1);
              window.open('/bkt_api/train/grade/apply/export/learn/apply' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
            }}
          >
            导出数据
          </Button>
        </Btns>
        {/* 表格 */}
        {this._renderList()}

        {/* 修改弹窗 */}
        <SubDrawer
          // visible={!!this.state.personApplyId}
          personApplyId={this.state.personApplyId}
          onClose={() => {
            this.setState({
              personApplyId: ''
            });
          }}
        />
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;