
// import { Input } from 'antd';
import AppealModal from './AppealModal';
import { trainGradeApplyCancel, trainGradeApplyAppeal } from '../../../../services/bkt/apis';
import $pModal from '../../../../utils/modal/pModal';
import $nModal from '../../../../utils/modal/nModal';
import $modal from '../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {

  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      width: 80,
      fixed: 'left'
    },
    {
      title: '姓名',
      dataIndex: 'fullName',
      key: 'fullName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '身份证号',
      dataIndex: 'identityNumber',
      key: 'identityNumber',
      width: 200,
      fixed: 'left',
      render: value => value || '-'
    }, 
    {
      title: '部门',
      dataIndex: 'departName',
      key: 'departName',
      render: value => value || '-'
    },
    {
      title: '报名时间',
      dataIndex: 'applyDate',
      key: 'applyDate',
      render: value => value || '-'
    },
    {
      title: '是否补考',
      dataIndex: 'isMakeUp',
      key: 'isMakeUp',
      render: value => value=='1'?'是' : '否'
    },
    {
      title: '申报状态',
      dataIndex: 'applyStatus',
      key: 'applyStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '申报中';
            color = warnColor;
            break;
          case value == 1:
            text = '申报通过';
            color = okColor;
            break;
          case value == 2:
            text = '申报不通过';
            color = errColor;
            break;
          case value == 3:
            text = '已撤销';
            color = errColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '背景筛查状态',
      dataIndex: 'backgroundStatus',
      key: 'backgroundStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            text = '审核中';
            color = warnColor;
            break;
          case value == 1:
            text = '正常';
            color = okColor;
            break;
          case value == 2:
            color = errColor;
            text = '关注';
            break;
          case value == 3:
            color = okColor;
            text = '申诉通过';
            break;
          case value == 4:
            color = errColor;
            text = '申诉不通过';
            break;
          case value == 5:
            color = warnColor;
            text = '申诉中';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '缴费状态',
      dataIndex: 'orderStatus',
      key: 'orderStatus',
      render: (value) => {
        let text = '未缴费';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未缴费';
            break;
          case value == 1:
            color = okColor;
            text = '已缴费';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '材料核对状态',
      dataIndex: 'materialApproveStatus',
      key: 'materialApproveStatus',
      render: (value) => {
        let text = '未核对';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未核对';
            break;
          case value == 1:
            color = okColor;
            text = '核对通过';
            break;
          case value == 2:
            color = errColor;
            text = '核对不通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '开班状态',
      dataIndex: 'classOpenStatus',
      key: 'classOpenStatus',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '未开班';
            break;
          case value == 1:
            color = okColor;
            text = '已开班';
            break;
          default:
            text = '未开班';
            color = warnColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },{
      title: '结业考试状态',
      dataIndex: 'graduateTestState',
      key: 'graduateTestState',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未通过';
            break;
          case value == 1:
            color = okColor;
            text = '已通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '鉴定考试状态',
      dataIndex: 'identifyTestState',
      key: 'identifyTestState',
      render: (value) => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == 0:
            color = errColor;
            text = '未通过';
            break;
          case value == 1:
            color = okColor;
            text = '已通过';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '理论学习进度',
      dataIndex: 'progress',
      key: 'progress',
      render: value => {
        if (value) {
          return value + '%';
        } else {
          return '0%'
        }
      }
    },
    {
      title: '实习状态',
      dataIndex: 'internStatus',
      key: 'internStatus',
      render: (value) => {
        let text = '未实习';
        let color = '';
        switch (true) {
          case value == 0:
            color = warnColor;
            text = '实习中';
            break;
          case value == 1:
            color = okColor;
            text = '已完成';
            break;
          // case value == 2:
          //   color = okColor;
          //   text = '已完成';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '报名保安公司',
      dataIndex: 'learnName',
      key: 'learnName',
      render: value => value || '-'
    },
    {
      title: '培训机构名称',
      dataIndex: 'organName',
      key: 'organName',
      render: value => value || '-'
    },
    {
      title: '缴费时间',
      dataIndex: 'payDate',
      key: 'payDate',
      render: value => value || '-'
    },
    {
      title: '开班名称',
      dataIndex: 'className',
      key: 'className',
      render: value => value || '-'
    },
    // {
    //   title: '开班时间',
    //   dataIndex: 'classStartDate',
    //   key: 'classStartDate',
    //   // render: value => value || '-'
    //   render: (text,record)=>{
    //     return (
    //     <span>{text?record.classStartDate+"~"+record.classEndDate:'-'}</span>
    //     )
    //   }
    // },
    {
      title: '实操培训开班时间',
      dataIndex: 'particeStartDate',
      key: 'particeStartDate',
      render: (value, record) => {
        const { practiceStartDate, practiceEndDate } = record;
        if (!!practiceStartDate) {
          return `${practiceStartDate}~${practiceEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '实习天数',
      dataIndex: 'internDayTotal',
      key: 'internDayTotal',
      render: value => value || '0'
    },
    {
      title: '实习时长',
      dataIndex: 'internHourTotal',
      key: 'internHourTotal',
      render: value => {
        if (value) {
          return (value / 1).toFixed(1);
        } else {
          return '0';
        }
      }
    },
    {
      title: '结业-理论成绩',
      dataIndex: 'graduateComputerScore',
      key: 'graduateComputerScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '结业-实操成绩',
      dataIndex: 'graduatePracticeScore',
      key: 'graduatePracticeScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    
    {
      title: '鉴定-理论成绩',
      dataIndex: 'identifyComputerScore',
      key: 'identifyComputerScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    {
      title: '鉴定-实操成绩',
      dataIndex: 'identifyPracticeScore',
      key: 'identifyPracticeScore',
      render: value => {
        if (value !== null) {
          return value;
        }
        return '-'
      }
    },
    // {
    //   title: '手机号码',
    //   dataIndex: 'mobile',
    //   key: 'mobile',
    //   render: value => value || '-'
    // },
    // {
    //   title: '公安处理意见',
    //   dataIndex: 'policeResponse',
    //   key: 'policeResponse',
    //   render: value => {
    //     return value || '-';
    //   }
    // },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 130,
      fixed: 'right',
      render: (text, record) => {
        const { classOpenStatus, personApplyId, backgroundStatus, fullName, applyStatus } = record;
        return (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.setState({
                  personApplyId
                });
              }}
            >
              查看
          </span>
            {
              // 1、申报状态为 申报中
              // 2、背景筛查状态为 关注
              applyStatus == '0' && backgroundStatus == '2' && 
              <span
                style={{
                  color: '#108EE9',
                  cursor: 'pointer',
                  marginRight: '20px'
                }}
                onClick={() => {
                  let appealForm = null;
                  $nModal({
                    width: 800,
                    title: `${fullName}-背景筛查申诉`,
                    content: <AppealModal
                      personApplyId={personApplyId}
                      onGetForm={(form) => {
                        appealForm = form;
                      }}
                    />,
                    okText: '确定',
                    cancelText: '取消',
                    onOk: close => {
                      // const values = appealForm.getFieldsValue();
                      appealForm.validateFields((err, values) => {
                        if (err) return;
                        const { appealContext, appealInfoArr } = values;
                        const appealInfo = appealInfoArr[appealInfoArr.length - 1];
                        const infos = appealInfo ? appealInfo.split(' ') : [];

                        // 没有选完整
                        if (infos[infos.length - 1] == 'false') {
                          return $modal(
                            '请选择具体的申诉机构',
                            ''
                          );
                        }

                        const appealOrgId = infos[0];
                        const appealOrgName = infos[1];
                        const appealOrgAreaCode = infos[2];

                        trainGradeApplyAppeal({ data: { personApplyId, appealContext, appealOrgId, appealOrgName, appealOrgAreaCode } }).then(res => {
                          this._updateTable();
                          close();
                          $modal('提交成功！', '请等待公安人员进行审核，审核状态可刷新页面查看。', null, 'success');
                        });
                      });
                    }
                  });
                }}
              >
                申诉
            </span>
            }
            {
              // 1、申报状态为 申报中
              // 2、背景筛查状态≠审查中或申诉中
              // 3、开班状态为 未开班
              classOpenStatus == '0' && 
              applyStatus == '0' && 
              backgroundStatus != '0' &&
              backgroundStatus != '5' &&
              // (backgroundStatus == '1' || backgroundStatus == '5') &&
              <span
                style={{
                  color: '#D9001B',
                  cursor: 'pointer',
                  marginRight: '20px'
                }}
                onClick={() => {
                  $pModal(
                    `即将撤销${fullName}的报名记录，是否继续？`,
                    <em style={{ color: '#F04134' }}>撤销后，该人员将无法继续学习课程。所学的课程学时、实习记录不会删除，重新报名后，数据会自动关联。</em>,
                    [{ text: '确定', type: 'primary', promiseType: 'ok' }, { text: '取消' }],
                  ).then(modal => {
                    if (modal.type == 'ok') {
                      trainGradeApplyCancel({ data: { personApplyId } }).then(res => {
                        this._updateTable();
                        $pModal(
                          '撤销成功',
                          '该人员无法继续在App端查看学习课程。',
                          [{ text: '确定', type: 'primary', promiseType: 'ok' }],
                          'success'
                        );
                      });
                    }
                  });
                }}
              >
                撤销
            </span>
            }


          </div>
        );

      }
    }
  ];
}