import React, { Component } from "react";

import {
  Button,
  Modal
} from "antd";

import BTable from '../../../../../components/Pro/BTable';
// import $pModal from '../../../../../utils/modal/pModal';
import columnFun from './columns';

export default class InternshipRecord extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
        // uid: this.props.uid
      },
      searchDataReady: false, //筛选参数是否准备就绪
    };
  }
  componentDidMount() {

  }
  componentWillReceiveProps(props) {
    const { uid } = props;
    if (uid) {
      this.setState({
        pageParm: {
          ...this.state.pageParm,
          uid
        }
      });
    }
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = columnFun.call(this);
    const { uid } = this.state.pageParm;
    return (
      <Modal
        title={`${this.props.name}-实习记录`}
        visible={this.props.visible}
        okText="确定"
        cancelText="取消"
        width={'80%'}
        destroyOnClose={true}
        onOk={() => {
          this.props.onClose && this.props.onClose();
        }}
        onCancel={() => {
          this.props.onClose && this.props.onClose();
        }}
      >
        {/* <Alert
          message={<div>本页面显示的是您通过平台购买保险时，投保的人员未导入到系统中的人员信息，您只可通过此页面为其进行减员保全。</div>}
          type="warning"
          showIcon
        /> */}

        <BTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="trainInternInternLinePage"
          pageParm={this.state.pageParm}
          forceUpdate={this.state.forceUpdate}
          scroll={{ x: '2500px' }}
          pagination={{
            showTotal: total => `总共 ${total} 条`
          }}
        // dateChange={
        // }
        />
      </Modal>
    );
  }
}
