
/* *
*@params personApplyId
*@params onClose
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import { Button, Drawer, Form, Input, notification } from 'antd';
import PSelect from '../../../../components/Pro/PSelect';
import { adapt_trainAdaptApplyInfo } from '../../../../services/bkt/apis';

import { 
  publicCommonFileFilePreview 
  } from '../../../../services/api';

const formItemLayout = {
  labelCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 7
    }
  },
  wrapperCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 20
    },
    md: {
      span: 16
    }
  }
};
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()
export default class SubDrawer extends Component {
  constructor(props) {
    super(props);
    this.state = {
      comName: this.props.companyInfo.comName,
      info: null,  //申报详情
      // contracInfo: {},  //合同详情
      certInfo: {}, //证书详情
      imgs: []
    };
  }
  componentWillMount() {
    // this.__getDistrict();
  }
  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    if (!!nextProps.personApplyId) {
      this.__getDetailInfo(nextProps.personApplyId);
    }
  }

  __getDetailInfo = (personApplyId) => {
    adapt_trainAdaptApplyInfo({ data: { personApplyId } }).then(res => {
      this.setState({
        info: res.data
      });
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const { info } = this.state;
    return (
      <Drawer
        title="报名详情"
        width={600}
        visible={!!this.props.personApplyId}
        onClose={this.props.onClose}
      // visible={true}
      >
        {info &&
          <div>
            {
              info.materialApproveStatus == '2' &&
              <p style={{ color: '#D9001B', marginLeft: 21 }}>材料核对不通过原因: {info.materialApproveFailReason}</p>
            }
            {
              info.approveStatus == '2' &&
              <p style={{ color: '#D9001B', marginLeft: 21 }}>审核不通过原因: {info.approveFailReason}</p>
            }
          </div>
        }
        {/* form表单 */}
        {
          info &&
          <Form style={{ marginBottom: '50px' }} layout="horizontal">
            <Form.Item {...formItemLayout} label="姓名">
              {getFieldDecorator('fullname', {
                initialValue: info.fullname
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>

            <Form.Item {...formItemLayout} label="身份证号">
              {getFieldDecorator('identitynumber', {
                initialValue: info.identitynumber
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>

            <Form.Item {...formItemLayout} label="户籍类型">
              {getFieldDecorator('residentType', {
                initialValue: info.residentType
              })(<PSelect disabled style={{ width: '100%' }} type="residentType" />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label="户籍所在地">
              {getFieldDecorator('residentPlaceType', {
                initialValue: info.residentPlaceType
              })(<PSelect disabled style={{ width: '100%' }} type="residentPlaceType" />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label="户籍地址">
              {getFieldDecorator('householdAddress', {
                initialValue: info.householdAddress
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label="现住地址">
              {getFieldDecorator('actualAddress', {
                initialValue: info.actualAddress
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>
            <Form.Item>
              <span style={{marginRight: 8}}>
                {/* <em style={{ color: '#f5222d', marginRight: 4 }}>*</em> */}
                该人员在本企业连续3个月及以上社保缴费凭证:
              </span>
              <a
                onClick={() => {
                  if(info.socialSecurityProveUrl) {
                    publicCommonFileFilePreview({
                      url: info.socialSecurityProveUrl,
                      isLoad: '1'
                    })
                    .then(data => {
                      if (data.data) {
                        window.open(data.data);
                      }
                    });
                  }else {
                    notification.warning({
                      message: '该合同未上传附件！',
                      description: '请先上传合同文件，方可查看。'
                    });
                  }
                }}
              >
                点击查看
              </a>
              <a
                style={{marginLeft: 15}}
                href={info.socialSecurityProveUrl}
                target="_blank"
                download
              >
                点击下载
              </a>
              {/* {getFieldDecorator('contractUrl' , {
                initialValue: info.contractUrl
              })(
                <PFromUpload
                  key={moment().valueOf()}
                  disabled={true}
                  num={1}
                  disabled
                />
              )} */}
            </Form.Item>
            {/* --------------- */}
            <h3>合同信息</h3>
            <Form.Item {...formItemLayout} label="合同名称">
              {getFieldDecorator('contractName', {
                initialValue: info.contractName
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label="有效期">
              {getFieldDecorator('effectStartDate', {
                initialValue: `${info.effectStartDate}~${info.effectEndDate}` 
              })(<Input placeholder="" maxLength={30} disabled={true} />)}
            </Form.Item>
            <Form.Item {...formItemLayout} label="合同文件">
              <a
                onClick={() => {
                  if(info.contractUrl) {
                    publicCommonFileFilePreview({
                      url: info.contractUrl,
                      isLoad: '1'
                    })
                    .then(data => {
                      if (data.data) {
                        window.open(data.data);
                      }
                    });
                  }else {
                    notification.warning({
                      message: '该合同未上传附件！',
                      description: '请先上传合同文件，方可查看。'
                    });
                  }
                }}
              >
                点击查看
              </a>
              <a
                style={{marginLeft: 15}}
                href={info.contractUrl}
                target="_blank"
                download
              >
                点击下载
              </a>
              {/* {getFieldDecorator('contractUrl' , {
                initialValue: info.contractUrl
              })(
                <PFromUpload
                  key={moment().valueOf()}
                  disabled={true}
                  num={1}
                  disabled
                />
              )} */}
            </Form.Item>
            
            <h3>报名承诺</h3>
            <section>
                <span style={{
                  color: '#f5222d',
                  // text-indent  
                }}>*</span>
                我司（ <span style={{ color: '#F59A23' }}>{info.learnName||this.props.companyInfo.comName}</span> ）承诺，由我司报名代理人{info.agentName}（{info.agentIdCardNo},{info.agentPhone}）提交的报名信息真实有效，对因填报信息错误造成不符合培训及补贴申报条件的，由本企业自行承担相应责任和损失。
              </section>
          </Form>
        }


        {/* 底部提交按钮 */}
        <div
          style={{
            position: 'absolute',
            bottom: 0,
            width: '100%',
            borderTop: '1px solid #e8e8e8',
            padding: '10px 16px',
            textAlign: 'left',
            left: 0,
            background: '#fff',
            borderRadius: '0 0 4px 4px'
          }}
        >
          <Button
            style={{
              marginRight: 8
            }}
            onClick={this.props.onClose}
          >
            返回
          </Button>
        </div>
      </Drawer>
    );
  }
}
