import React, { PureComponent } from 'react';
// import { connect } from 'dva';
import moment from 'moment';
import "moment/locale/zh-cn";
import style from "styled-components";
import { Select, Input, Button, DatePicker } from 'antd';
import ReceiveResumeRemarks from "./ReceiveResumeRemarks";
// import ProTable from "../../../components/Pro/ProTable";
import PTable from "../../../components/Pro/PTable";
// import PSelect from "../../../components/Pro/PSelect";
import {
  enterprisePerResumePage, //获取收到的简历
} from "../../../services/api";

const { Option } = Select;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';

// @connect(state => ({
//   monitor: state.monitor,
// }))
export default class Receive extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      /**
       * 抽屉需要
       */
      // visiable: false,
      open: false,
      currentId: '',
      number: 0,
      start: false,
      end: false,
      forceUpdate: false,
      pageParm: {
        // comId: '1',
        pageSize: '10',
        pageNumber: '1',
        keyWord: "",
        isRead: "",
        startTime: '',//开始时间
        endTime: '',//结束时间
      },
      keyWord: "",
      isRead: "",
      startTime: '',//开始时间
      endTime: '',//结束时间
    };

  }

  /************************生命周期********************************* */
  // componentDidMount() {
  //   this.getReceiveResume();//获取收到的简历

  // }
  // /************************ajax请求********************************* */
  // //获取收到的简历
  // getReceiveResume = () => {
  //   // const comId = 1;
  //   const pageSize = 10;
  //   const pageNumber = 1;
  //   enterprisePerResumePage({ pageSize, pageNumber }).then((res) => {
  //     console.log("获取收到的简历成功:", res);
  //   }, (err) => {
  //     console.log("获取收到的简历失败:", err);
  //   });
  // }

  //备注抽屉
  changeDrawer = (open, currentId) => {
    console.log(open);
    console.log("当前Id", currentId);
    this.setState({ open, currentId });
  }

  //table 数据变化
  dateTableChange = (data) => {
    console.log(data);
    this.setState({ number: data.total });
  };
  //过去关键字
  inputTracknameChange = (e) => {
    console.log(e.target.value.trim());
    this.setState({ keyWord: e.target.value.trim() });
  };
  //搜索日期
  onChangeTime = (date, dateString) => {
    if (dateString[0] !== '') {
      this.setState({
        start: true,
        end: true,
        startTime: dateString[0],
        endTime: dateString[1],
      });
    } else {
      this.setState({
        start: false,
        end: false,
        startTime: '',
        endTime: '',
      });
    }
  };
  handleChangeIsRead = (value) => {
    console.log(`Select状态 ${value}`);
    this.setState({
      isRead: value,
    });
  };
  //点击搜索
  search = () => {
    const pageParm = { ...this.state.pageParm };
    pageParm.keyWord = this.state.keyWord;
    pageParm.isRead = this.state.isRead;
    pageParm.startTime = this.state.startTime;
    pageParm.endTime = this.state.endTime;

    this.setState({
      pageParm,
      // forceUpdate: true,
    });
    console.log(pageParm.startTime + "," + pageParm.endTime);
  }
  //重置
  reset = () => {
    this.setState({
      keyWord: '',
      isRead: '',
      forceUpdate: true,
      start: false,
      end: false,
    },
    () => {
      this.search();
    }
  );
  };
  renderTable = () => {
    const columns = [
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
      },
      {
        title: '性别',
        dataIndex: 'sexName',
        key: 'sexName',
      },
      {
        title: '年龄',
        render: (age) => (
          <div>
            {age}岁
          </div>
        ),
        dataIndex: 'age',
        key: 'age',
      },
      {
        title: '工作年限',
        dataIndex: 'workTime',
        render: (workTime) => (
          <div>
            {workTime === 0 ? "不满一年" : workTime + "年工作经验"}
          </div>
        ),
        key: 'workTime',
      },
      {
        title: '投递职位',
        dataIndex: 'positionName',
        key: 'positionName',
      },
      {
        title: '投递时间',
        dataIndex: 'createTime',
        key: 'createTime',
      },
      {
        title: '状态',
        dataIndex: 'isReadName',
        key: 'isReadName',
      },
      {
        title: '操作',
        dataIndex: 'd',
        key: 'd',
        render: (text, record) => (
          // render: () => (
          <div>
            <Opton
              onClick={() => {
                this.props.history.push(`/PersonnelRecruitment/ListContainer/ResumeDetails/${record.sendResumeId}/1`);
              }}
            >
              查看
            </Opton>
            <Opton onClick={this.changeDrawer.bind(this, true, record.sendResumeId)}>备注</Opton>
          </div>
        ),
      }
    ];


    // return <Table dataSource={dataSource} columns={columns} />;
    return (
      <PTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="enterprisePerResumePage"
        pageParm={this.state.pageParm}
        dateChange={this.dateTableChange}
        forceUpdate={this.state.forceUpdate}
        showTotal={total => `共搜索到${total}条数据`}
      // showTotal
      />
    );
  }



  render() {

    return (
      <Content>
        {/* 搜索条件面板 */}
        <h2 style={{ display: "none" }}>共检索到<span>{this.state.number}</span>条数据</h2>
        <div className="searchpanel">
          <span>关键字：</span>
          <Input
            style={{ marginBottom: "10px", width: 214 }}
            onChange={this.inputTracknameChange}
            value={this.state.keyWord}
          />
          <span className="post">状态:</span>
          <Select value={this.state.isRead} onChange={this.handleChangeIsRead} style={{ width: 214 }}>
            <Option value="">全部</Option>
            <Option value="0">未读</Option>
            <Option value="1">已读</Option>
          </Select>
          <span className="post">投递日期:</span>
          <RangePicker
            style={{ width: 214 }}
            format={dateFormat}
            onChange={this.onChangeTime}
            value={[this.state.start ? moment(this.state.startTime, dateFormat) : null, this.state.end ? moment(this.state.endTime, dateFormat) : null]}

          />
          <Button onClick={this.search} type="primary" style={{ marginLeft: 17 }}>搜索</Button>
          <Button style={{ marginLeft: 16, marginBottom: '16px' }} onClick={this.reset}>重置</Button>
        </div>
        {this.renderTable()}
        <ReceiveResumeRemarks
          onChange={(open) => { this.setState({ open }); }}
          visiable={this.state.open}
          currentId={this.state.currentId}
        />
      </Content>

    );
  }
}

/************************样式************************/

const Content = style.div`{
  font-size: 14px;
  color: rgba(0,0,0,0.65);
  .searchpanel{
     margin-bottom:16px;
    .post{
      margin:0 8px 0 16px;
    }
  }
  .btns{
    margin-top:16px;
  }
}`;

const Opton = style.span`{
  font-size: 12px;
  color: #0F71FF;
  cursor:pointer;
  margin-right:8px;
}`;
