import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Form,
  Input,
  Button,
  message,
  TreeSelect,
  DatePicker,
  Modal,
  Breadcrumb
} from 'antd';
import moment from 'moment';
import "moment/locale/zh-cn";
import "moment/locale/zh-cn";
import PTable from '../../../components/Pro/PTable';
import './less/medical.less';
import * as ajax from '../../../services/api';
import PartmentButton from '../../../components/PartmentButton';

const monthFormat = 'YYYY/MM';
const { RangePicker } = DatePicker;
const { confirm } = Modal;
const FormItem = Form.Item;

@connect(state => ({
  profile: state.profile
}))
@Form.create()

/**
 * 缴费设置新增和修改
 */
export default class PayBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      loading: false,
      forceUpdate: false,
      mapData: [],
      treeData: [],
      userIdArrays: [],
      pageParm: {
        pageSize: '10',
        pageNumber: '1',
        paySchemeId: this.props.match.params.schemeId //传过来的方案id
      },
      checkNick: true,
      schemeId: this.props.match.params.schemeId, //传过来的方案id
      intercalate: true, //新增缴交比例的下方返回，添加人员按钮的显示
      mode: ['month', 'month'],
      schemeDetail: [
        {
          socialInsType: '', //社保险种
          comPayProp: '', //公司缴交比例
          perPayProp: '', //个人缴交比例
          socialInsBase: '' //缴费基数
        },
        {
          socialInsType: '', //社保险种
          comPayProp: '', //公司缴交比例
          perPayProp: '', //个人缴交比例
          socialInsBase: '' //缴费基数
        },
        {
          socialInsType: '', //社保险种
          comPayProp: '', //公司缴交比例
          perPayProp: '', //个人缴交比例
          socialInsBase: '' //缴费基数
        },
        {
          socialInsType: '', //社保险种
          comPayProp: '', //公司缴交比例
          perPayProp: '', //个人缴交比例
          socialInsBase: '' //缴费基数
        },
        {
          socialInsType: '', //社保险种
          comPayProp: '', //公司缴交比例
          perPayProp: '', //个人缴交比例
          socialInsBase: '' //缴费基数
        }
      ],
      scheme: {
        schemeName: '', //方案名称
        startYears: '', //方案开始日期
        endYears: '' //方案结束日期
      },
      selectedRowKeys: [], //需要删除的信息key值集合
      selectedRowIds: [], //需要删除的信息id值集合
      visibleuser: false //添加人员弹窗
    };
  }

  componentDidMount() {
    //获取部门数据Map列表
    ajax.getTreeperBydepartMap({}).then(data => {
      this.setState({ mapData: data.data });
      // console.log('部门人员信息列表>>>>>>>>>>>>>>>>', data.data);
      // console.log('部门人员信息列表>>>>>>>>>>>>>>>>', data.data["1"]);
    });
    //获取部门树数据
    ajax.getTreeperBydepart({}).then(data => {
      this.setState({ treeData: data.data });
      // console.log('部门信息', data.data);
    });
    this.getPaymentSet(); //缴交方案详情查询，通过缴交方案ID
    this.getSelectPerson(); //缴交方案的已选人员列表
  }

  cancelConfirm = () => {
    const that = this;
    confirm({
      title: '当前信息未保存，是否确认返回?',
      okText: '确认',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        // console.log(">>>>>>>>>>>>>>>>",this.props);
        that.props.history.push('/salarymanagement/proportion');
      },
      onCancel() {
        console.log('Cancel');
      }
    });
  };

  getInitValue = (type, str) => {
    let retval = {};
    this.state.schemeDetail.map((val, i) => {
      if (type === val.socialInsType) {
        retval = val;
      }
      return i;
    });
    // console.log('>>>>>>>>>>>>>>>>>>>>>>>>>>',retval);
    return retval[str];
  };

  getPaymentSet = () => {
    if (this.state.schemeId !== '00') {
      ajax
        .getPaymentSettingById({ paySchemeId: this.state.schemeId })
        .then(data => {
          if (data.data) {
            // console.log('缴交方案详情查询，通过缴交方案ID',data.data.SchemeDetail);
            this.setState({
              scheme: data.data.Scheme,
              schemeDetail: data.data.SchemeDetail
            });
          }
        });
    }
  };

  //人员列表刷新的ajax请求
  getSelectPerson = () => {
    const pageParm = { ...this.state.pageParm };
    this.setState({ pageParm, forceUpdate: true }, () => {
      this.setState({ forceUpdate: false });
    });
    // ajax.getSelectedPersonPage({
    //   pageSize:50,
    //   pageNumber:1,
    //   paySchemeId:this.state.schemeId
    // }).then((json) => {
    //   if(json.retType === '0'){
    //     console.log('缴交方案的已选人员列表',json.data.data);
    //     this.setState({
    //       listPage:json.data.data,
    //       total:json.data.total
    //     });
    //   }
    // });
  };

  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, val) => {
      const values = val; //转换为本地变量
      if (!err) {
        const rangeValue = values['rangeTimePicker'];
        values.startYears = rangeValue[0].format('YYYY-MM');
        values.endYears = rangeValue[1].format('YYYY-MM');
        console.log('startYears', values.startYears);
        console.log('endYears', values.endYears);
        delete values.rangeTimePicker;
        values.schemeDetailsList = [{}, {}, {}, {}, {}, {}];
        values.schemeDetailsList[0] = {
          comPayProp: values.yanglao2,
          perPayProp: values.yanglao3,
          socialInsBase: values.yanglao1,
          socialInsType: '110'
        };
        values.schemeDetailsList[1] = {
          comPayProp: values.yiliao2,
          perPayProp: values.yiliao3,
          socialInsBase: values.yiliao1,
          socialInsType: '310'
        };
        values.schemeDetailsList[2] = {
          comPayProp: values.shiye2,
          perPayProp: values.shiye3,
          socialInsBase: values.shiye1,
          socialInsType: '210'
        };
        values.schemeDetailsList[3] = {
          comPayProp: values.gongzuo2,
          perPayProp: values.gongzuo3,
          socialInsBase: values.gongzuo1,
          socialInsType: '410'
        };
        values.schemeDetailsList[4] = {
          comPayProp: values.shengyu2,
          perPayProp: values.shengyu3,
          socialInsBase: values.shengyu1,
          socialInsType: '510'
        };
        values.schemeDetailsList[5] = {
          comPayProp: values.gongjijin2,
          perPayProp: values.gongjijin3,
          socialInsBase: values.gongjijin1,
          socialInsType: '810'
        };
        values.schemeDetails = JSON.stringify(values.schemeDetailsList); //把数组转换为json方便后台保存
        //提交前去除多余的字段
        delete values.schemeDetailsList;
        delete values.yanglao1;
        delete values.yanglao2;
        delete values.yanglao3;
        delete values.yiliao1;
        delete values.yiliao2;
        delete values.yiliao3;
        delete values.shiye1;
        delete values.shiye2;
        delete values.shiye3;
        delete values.gongzuo1;
        delete values.gongzuo2;
        delete values.gongzuo3;
        delete values.shengyu1;
        delete values.shengyu2;
        delete values.shengyu3;
        delete values.gongjijin1;
        delete values.gongjijin2;
        delete values.gongjijin3;
        console.log('提交的值集合', values);
        if (this.state.schemeId === '00') {
          //就是新增的标记
          this.setState({ loading: true });
          ajax.paymentSettingSavePaymentSetting({ ...values }).then(
            json => {
              // message.success('提交成功！');
              this.setState({
                visibleuser: true,
                schemeId: json.data,
                pageParm: {
                  pageSize: '10',
                  pageNumber: '1',
                  paySchemeId: json.data
                }
              }); //把返回的ID赋值缓存
              this.setState({ loading: false });
            },
            () => {
              this.setState({ loading: false });
              // message.warning(error);
            }
          );
        } else {
          values.paySchemeId = this.state.schemeId;
          this.setState({ loading: true });
          ajax.paymentSettingSavePaymentSetting({ ...values }).then(
            () => {
              const that = this;
              confirm({
                title: '缴交设置保存成功！',
                okText: '确认',
                cancelText: '取消',
                onOk() {
                  that.setState({ loading: false });
                  that.props.history.push('/salarymanagement/proportion');
                },
                onCancel() {
                  that.setState({ loading: false });
                  console.log('Cancel');
                }
              });
            },
            () => {
              this.setState({ loading: false });
              // message.warning(error);
            }
          );
        }
      }
    });
  };

  //时间选择
  handlePanelChange = (value, mode) => {
    this.setState({
      mode: [
        mode[0] === 'date' ? 'month' : mode[0],
        mode[1] === 'date' ? 'month' : mode[1]
      ]
    });
    console.log('mode', mode);
    console.log('value', value);
    const { form } = this.props;
    form.setFieldsValue({ rangeTimePicker: value });
  };

  // 验证基数
  checkJiShu = (rule, value, callback) => {
    if (value && !/^[1-9]\d{0,9}$|^[1-9]\d{0,9}\.{1}\d{1,2}$/g.test(value)) {
      callback('请输入9位整数，并且小数点后面最多输入2位！');
    } else {
      callback();
    }
  };
  checkJiShuMore = (rule, value, callback) => {
    if (value && value > 100) {
      callback('输入的数应小于或等于100！');
    } else if (
      value &&
      // !/^[1-9]\d{0,2}$|^[1-9]\d{0,2}\.{1}\d{1,2}$/g.test(value)
      !/^(([1-9][0-9]{0,9})|(([0]\.\d{1,2}|[1-9][0-9]{0,9}\.\d{1,2})))$/g.test(value)
    ) {
      // }else if(value && !(/^([1-9][0-9]*|0)\.([0-9]{2})$/).test(value)){
      callback('输入不正确,请保留两位小数！');
    } else {
      callback();
    }
  };
  checkJiShuMore1 = (rule, value, callback) => {
    if (value && value > 100) {
      callback('输入的数应小于或等于100！');
    } else if (
      value &&
      // !/^[0-9]\d{0,2}$|^[1-9]\d{0,2}\.{1}\d{1,2}$/g.test(value)
      !/^(([1-9][0-9]{0,9})|(([0]\.\d{1,2}|[1-9][0-9]{0,9}\.\d{1,2})))$/g.test(value)
    ) {
      // }else if(value && !(/^([1-9][0-9]*|0)\.([0-9]{2})$/).test(value)){
      callback('输入不正确,请保留两位小数！');
    } else {
      callback();
    }
  };

  // 批量删除
  handleDeleteList = () => {
    const self = this;
    const keyNumber = this.state.selectedRowKeys.length;
    const keyId = this.state.selectedRowIds;
    if (keyNumber <= 0) {
      message.warning('请选择需要移除的人员！');
    } else {
      // console.log(this.state.selectedRowIds);
      confirm({
        title:
          '共选择' +
          keyNumber +
          '名人员，被移除人员下月将不计算医社保缴交金额。是否确认移除？',
        okText: '确认',
        cancelText: '取消',
        onOk() {
          self.orderDelete(keyId);
        },
        onCancel() {
          console.log('Cancel');
        }
      });
    }
  };

  // 删除
  orderDelete = orderID => {
    ajax
      .paymentSettingDelPerson({
        perIds: orderID,
        paySchemeId: this.state.schemeId
      })
      .then(
        data => {
          // console.log("方案删除", data);
          this.setState({
            selectedRowIds: [],
            selectedRowKeys: []
          });
          this.getSelectPerson();
        },
        err => {
          // console.log("方案删除失败", err);
          message.warning('方案删除失败！' + err);
        }
      );
  };

  //选择完人员的回调方法
  callbackSavePersons = checkedkeys => {
    // console.log(checkedkeys, 'createpublish');
    ajax
      .paymentSettingAddPerson({
        //保存
        perIds: checkedkeys,
        paySchemeId: this.state.schemeId
      })
      .then(
        data => {
          // console.log('保存人员成功' , data);
          // message.success(data.msg);
          this.setState({ visibleuser: false, checkedkeys }); //隐藏人员选择窗口
          this.getSelectPerson(); //查询缴交方案的已选人员列表
        },
        err => {
          // console.log("保存人员成功", err);
          // message.warning('保存人员失败' + err);
          this.setState({ visibleuser: false, checkedkeys }); //隐藏人员选择窗口
          this.getSelectPerson(); //查询缴交方案的已选人员列表
        }
      );
  };

  // 表格渲染
  renderOrderList = () => {
    // const pageInitStudent = {//分页器
    //   defaultPageSize: 10,
    //   showQuickJumper: true,
    //   pageSizeOptions: ["5", "10", "15", "20", "25"],
    //   showSizeChanger: true,
    //   showTotal: () => { return '共 ' + this.state.total + ' 条数据'; }
    // };

    const selectedRowKey = this.state.selectedRowKeys;
    const rowSelection = {
      //行被选择的事件内容如下：
      selectedRowKeys: selectedRowKey,

      onChange: selectedRowKeys => {
        // console.log('selectedRowKeys',selectedRowKeys);

        this.setState(
          {
            selectedRowKeys //key和value的值一样时，可以只写一个
          },
          () => {
            // console.log('selectedRowKeys-more',this.state.selectedRowKeys);
          }
        );
      },
      onSelect: (record, selected, selectedRows) => {
        const selectId = this.state.selectedRowIds;
        if (selected === true) {
          selectId.push(record.perId);
        } else {
          for (let i = 0; i < selectId.length; i++) {
            if (selectId[i] === record.perId) {
              selectId.splice(i, 1);
              break;
            }
          }
        }
        this.setState({
          selectedRowIds: selectId
        });
        // console.log(`record:`,record.perId,`selected:`, selected,`selectedRows:`, selectedRows);
      },
      onSelectAll: (selected, selectedRows, changeRows) => {
        let selectId = [];
        if (selected === true) {
          for (let i = 0; i < selectedRows.length; i++) {
            selectId.push(selectedRows[i].perId);
          }
        } else {
          selectId = [];
        }
        this.setState({
          selectedRowIds: selectId
        });
        // console.log(`selected:`,selected,`selectedRows:`,selectedRows,`changeRows:`, changeRows);
      }
    };

    const columns = [
      { title: '姓名', dataIndex: 'name', key: 'name' },
      { title: '身份证号', dataIndex: 'idCardNo', key: 'idCardNo' },
      { title: '手机号', dataIndex: 'contactPhone', key: 'contactPhone' }
    ];

    // const tmp = this.state.listPage.map((val, i) => { //为Table组件准备的行唯一标识
    //   const value = val;
    //   value.key = i + 1;
    //   return value;
    // });

    return (
      <PTable
        // dataSource={tmp}
        // pagination={pageInitStudent}
        style={{ marginTop: '16px' }}
        forceUpdate={this.state.forceUpdate}
        url='getSelectedPersonPage'
        columns={columns}
        pageParm={this.state.pageParm}
        showTotal
        rowSelection={rowSelection}
      />
    );
  };

  //弹窗关闭按钮
  handleMessageCancel = () => {
    this.setState({ visibleuser: false });
  };

  //弹窗保存按钮
  handleMessageOk = () => {
    //通过value区分部门的ID
    //通过value区分部门的ID
    const filterUserIdArrays = this.state.userIdArrays.filter(val => {
      // console.log(val);
      if (this.state.mapData[val] === undefined) {
        return false;
      } else {
        return true;
      }
    });
    this.callbackSavePersons(filterUserIdArrays);
    this.setState({ visibleuser: false });
  };
  //树选中事件
  treeSelectOnChangeHandler = (value, label, extra) => {
    // console.log('选中的值',value,label,extra);
    this.setState({ userIdArrays: value });
  };
  render() {
    const { getFieldDecorator } = this.props.form;
    const tProps = {
      treeData: this.state.treeData,
      value: this.state.userIdArrays,
      onChange: this.treeSelectOnChangeHandler,
      treeCheckable: true,
      // labelInValue:true,
      allowClear: true,
      treeNodeFilterProp: 'label',
      showCheckedStrategy: TreeSelect.SHOW_CHILD,
      searchPlaceholder: '请选择',
      style: {
        width: 560,
        background: '#f5f5f5'
      }
    };

    return (
      <div className='pay-set' style={{background:'white'}}>
        <Breadcrumb
          style={{ borderBottom: '1px solid #E9E9E9', paddingBottom: '10px' }}
        >
          <Breadcrumb.Item>
            <a
              onClick={() => {
                this.props.history.push(`/salarymanagement/medicalrecord`);
              }}
            >
              五险一金设置
            </a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>
            <a
              onClick={() => {
                this.props.history.push('/salarymanagement/proportion');
              }}
            >
              缴纳比例管理
            </a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>
            {this.state.schemeId === '00' && <span>新增缴纳比例</span>}
            {this.state.schemeId !== '00' && <span>缴纳比例详情</span>}
          </Breadcrumb.Item>
        </Breadcrumb>
        <Form onSubmit={this.handleSubmit} style={{ marginTop: 24 }}>
          <h2>缴交信息</h2>
          <FormItem label='方案名称' style={{ marginTop: 24 }}>
            {getFieldDecorator('schemeName', {
              initialValue: this.state.scheme.schemeName,
              rules: [
                // {
                //   pattern: /^[\u4e00-\u9fa5A-Za-z0-9]{1,10}$/,
                //   message: '请输汉字最大10位!'
                // },
                {
                  required: true,
                  message: '方案名称不能为空'
                }
              ]
            })(
              <Input
                placeholder='请输入方案名称'
                maxLength={50}
                style={{ width: '400px' }}
              />
            )}
          </FormItem>

          {this.state.schemeId === '00' ? ( //三目表达式，新增
            <FormItem label='有效日期'>
              {getFieldDecorator('rangeTimePicker', {
                rules: [
                  { type: 'array', required: true, message: '有效日期不能为空' }
                ]
              })(
                <RangePicker
                  placeholder={['开始月份', '结束月份']}
                  format='YYYY-MM'
                  mode={this.state.mode}
                  onPanelChange={this.handlePanelChange}
                  style={{ width: '400px' }}
                />
              )}
            </FormItem> //三目表达式，修改
          ) : (
            <FormItem label='有效日期'>
              {getFieldDecorator('rangeTimePicker', {
                initialValue: [
                  moment(this.state.scheme.startYears, monthFormat),
                  moment(this.state.scheme.endYears, monthFormat)
                ],
                rules: [
                  { type: 'array', required: true, message: '有效日期不能为空' }
                ]
              })(
                <RangePicker
                  placeholder={['开始月份', '结束月份']}
                  format='YYYY-MM'
                  mode={this.state.mode}
                  onPanelChange={this.handlePanelChange}
                  style={{ width: '400px' }}
                />
              )}
            </FormItem>
          )}
          <div className='Pay-information clearfix'>
            <div className='pay-head'>
              <ul className='clearfix'>
                <li className=''>
                  <span>项目</span>
                </li>
                <li className='w200'>
                  <span>缴费基数</span>
                </li>
                <li className='w200'>
                  <span>公司缴交比例</span>
                </li>
                <li className='w200'>
                  <span>个人缴交比例</span>
                </li>
              </ul>
            </div>
            <div className='pay-body'>
              <ul className='clearfix'>
                <li className=''>
                  <span>养老保险：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yanglao1', {
                      initialValue: this.getInitValue('110', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '养老保险缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yanglao2', {
                      initialValue: this.getInitValue('110', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '养老保险公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yanglao3', {
                      initialValue: this.getInitValue('110', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '养老保险个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
              <ul className='clearfix'>
                <li className=''>
                  <span>医疗保险：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yiliao1', {
                      initialValue: this.getInitValue('310', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '医疗保险缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yiliao2', {
                      initialValue: this.getInitValue('310', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '医疗保险公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('yiliao3', {
                      initialValue: this.getInitValue('310', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '医疗保险个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
              <ul className='clearfix'>
                <li className=''>
                  <span>失业保险：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shiye1', {
                      initialValue: this.getInitValue('210', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '失业保险缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shiye2', {
                      initialValue: this.getInitValue('210', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '失业保险公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shiye3', {
                      initialValue: this.getInitValue('210', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '失业保险个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
              <ul className='clearfix'>
                <li className=''>
                  <span>工伤保险：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongzuo1', {
                      initialValue: this.getInitValue('410', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '工伤保险缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongzuo2', {
                      initialValue: this.getInitValue('410', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '工作保险公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongzuo3', {
                      initialValue: this.getInitValue('410', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '工作保险个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore1
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
              <ul className='clearfix'>
                <li className=''>
                  <span>生育保险：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shengyu1', {
                      initialValue: this.getInitValue('510', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '生育保险缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shengyu2', {
                      // initialValue:this.getInitValue('410','comPayProp'),
                      initialValue: this.getInitValue('510', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '生育保险公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('shengyu3', {
                      // initialValue:this.state.schemeDetail[4].perPayProp,
                      initialValue: this.getInitValue('510', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '生育保险个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore1
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
              <ul className='clearfix'>
                <li className=''>
                  <span>&nbsp;&nbsp;&nbsp;&nbsp;公积金：</span>
                </li>
                <li className='w200'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongjijin1', {
                      initialValue: this.getInitValue('810', 'socialInsBase'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '公积金缴费基数不能为空!'
                        },
                        {
                          validator: this.checkJiShu
                        }
                      ]
                    })(<Input style={{ width: '150px' }} maxLength={9} />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongjijin2', {
                      // initialValue:this.getInitValue('410','comPayProp'),
                      initialValue: this.getInitValue('810', 'comPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '公积金公司缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
                <li className='w200 bg-bai'>
                  <FormItem style={{ width: '100%' }}>
                    {getFieldDecorator('gongjijin3', {
                      // initialValue:this.state.schemeDetail[4].perPayProp,
                      initialValue: this.getInitValue('810', 'perPayProp'),
                      rules: [
                        {
                          required: this.state.checkNick,
                          message: '公积金个人缴费比例不能为空!'
                        },
                        {
                          validator: this.checkJiShuMore
                        }
                      ]
                    })(<Input style={{ width: '150px' }} className='bai' />)}
                  </FormItem>
                </li>
              </ul>
            </div>
          </div>
          {this.state.schemeId === '00' ? (
            <div>
              {this.state.intercalate === true ? (
                <FormItem label=' ' colon={false}>
                  <Button
                    style={{ marginRight: '8px' }}
                    onClick={this.cancelConfirm}
                  >
                    返回
                  </Button>
                  <Button type='primary' htmlType='submit'>
                    添加人员
                  </Button>
                </FormItem>
              ) : (
                ''
              )}
            </div>
          ) : (
            <div>
              <h2>缴交人员</h2>
              <div className='set-table' style={{ marginTop: '24px' }}>
                <div className='set-but' style={{ marginBottom: '24px' }}>
                  <Button
                    type='primary'
                    style={{ marginRight: '8px' }}
                    onClick={() => {
                      this.setState({ visibleuser: true, userIdArrays: [] });
                    }}
                  >
                    +添加人员
                  </Button>
                  <Button type='danger' ghost onClick={this.handleDeleteList}>
                    移除人员
                  </Button>
                </div>
                {this.renderOrderList()}
              </div>
              <FormItem label=' ' colon={false}>
                <Button
                  style={{ marginRight: '8px' }}
                  onClick={this.cancelConfirm}
                >
                  返回
                </Button>
                <Button
                  type='primary'
                  htmlType='submit'
                  loading={this.state.loading}
                >
                  保存
                </Button>
              </FormItem>
            </div>
          )}
        </Form>

        {/*添加人员弹窗*/}
        <Modal
          width={700}
          title='添加人员'
          centered
          maskClosable={false}
          visible={this.state.visibleuser}
          onOk={this.handleMessageOk}
          onCancel={this.handleMessageCancel}
        >
          <div>
            {/* <label style={{ display: "inline-block", width: '130px', textAlign: "right" }}>选择的人员列表：</label> */}
            <TreeSelect dropdownStyle={{
              maxHeight: 300,
            }} {...tProps} />
          </div>
          {/* <div style={{ position: 'relative' }}>
                <label style={{ display: "inline-block", width: '80px', textAlign: "right", marginTop: "26px" }}>标题：</label>
                <Input style={{ width: 560, paddingRight: "60px" }}
                  placeholder="请输入"
                  maxLength={20}
                  onChange={this.inputMessageName}
                  value={this.state.input_wed}
                />
                <span style={{ position: 'absolute', top: '28px', right: '20px', color: '#999', fontSize: '12px' }}>{this.state.titleLength}/20</span>
              </div>
              <div className="clearfix">
                <label style={{ display: "inline-block", width: '80px', textAlign: "right", marginTop: "26px", float: 'left' }}>内容：</label>
                <div className="Rich-text">
                  <LzEditor
                    uploadProps={uploadProps}
                    active
                    video={false}
                    audio={false}
                    image={false}
                    cbReceiver={this.receiveHtml}
                    importContent={stateDataSource.briefIntroduce}
                    key="LzEditor"
                  />
                </div>
              </div> */}
        </Modal>

        {/* {this.state.visibleuser && <PartmentButton
        onCheck={this.callbackSavePersons}
        value={this.state.checkedkeys}
        visible={this.state.visibleuser} />} */}
      </div>
    );
  }
}
