import React, { Component } from 'react';
import { connect } from 'dva';
import { Alert, Form, Button, message, Modal, Breadcrumb } from 'antd';
import PTable from '../../../components/Pro/PTable';

import './less/medical.less';
import * as ajax from '../../../services/api';

const { confirm } = Modal;

@connect(state => ({
  profile: state.profile
}))
@Form.create()

/**
 * 缴费设置列表
 */
export default class PayBasic extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      selectedRowIds: [], //需要删除的信息id值集合
      selectedRowNames: '', //需要删除的信息id值集合
      // listPage:[],//表格数据
      selectedRowKeys: [],
      forceUpdate: false,
      pageParm: {
        pageSize: '10',
        pageNumber: '1'
      }
    };
  }

  componentDidMount() {
    this.getRecList();
  }

  //列表从后台获取数据，刷新分页列表
  getRecList = () => {
    const pageParm = { ...this.state.pageParm };
    this.setState({ pageParm }, () => {
      this.setState({ forceUpdate: false });
    });
  };

  // 删除
  orderDelete = orderID => {
    ajax.delPaymentSetting({ paySchemeIds: orderID }).then(
      data => {
        console.log('方案删除', data);
        this.setState({
          selectedRowIds: [],
          selectedRowKeys: []
        });
        // this.getRecList();
        this.setState({ forceUpdate: true }, () => {
          this.setState({ forceUpdate: false });
        });
      },
      err => {

        console.log('方案删除失败', err);
        //message.warning('方案删除失败！' + err);
      }
    );
  };

  // 批量删除
  handleDeleteList = () => {
    const self = this;
    const keyNumber = this.state.selectedRowIds.length;
    const keyId = this.state.selectedRowIds;
    console.log('id集合' + keyId);
    if (keyNumber <= 0) {
      message.warning('请选择需要删除的方案！');
    } else {
      console.log(this.state.selectedRowIds);
      confirm({
        title:
          '删除方案' +
          this.state.selectedRowNames +
          '，删除后方案不可找回。是否确认删除？',
        okText: '确认',
        cancelText: '取消',
        onOk() {
          self.orderDelete(keyId);
        },
        onCancel() {
          console.log('Cancel');
        }
      });
    }
  };

  //表格渲染
  checkPayContent = () => {
    // const pageInitStudent = {
    //   defaultPageSize: 10,
    //   showQuickJumper: true,
    //   pageSizeOptions: ["5", "10", "15", "20", "25"],
    //   showSizeChanger: true,
    //   showTotal: () => { return '共 ' + this.state.total + ' 条数据'; }
    // };

    const columns = [
      {
        title: '方案名称',
        dataIndex: 'schemeName',
        key: 'schemeName',
        render: text => <span>{text}</span>
      },
      {
        title: '员工数',
        dataIndex: 'perCnt',
        key: 'perCnt'
      },
      {
        title: '有效期',
        dataIndex: 'deadline',
        key: 'deadline'
      },
      {
        title: '状态',
        dataIndex: 'isEffect',
        key: 'isEffect',
        render: (text, record) => (
          <div>
            <span
              className={record.isEffect === 1 ? 'activated' : 'inactivated'}
            >
              ·
            </span>
            <span className='status'>
              {record.isEffect === 1 ? '正常' : '过期'}
            </span>
          </div>
        )
      },
      {
        title: '添加时间',
        dataIndex: 'createTime'
      },
      {
        title: '操作',
        render: (text, record) => (
          <span
            style={{ color: '#108EE9', cursor: 'pointer' }}
            onClick={() => {
              this.props.history.push(
                `/salarymanagement/proporset/${record.paySchemeId}`
              );
            }}
          >
            修改
          </span>
        )
      }
    ];
    const selectedRowKey = this.state.selectedRowKeys;

    //行绑定事件，根据TABLE的API进行设置
    const rowSelection = {
      selectedRowKeys: selectedRowKey,

      onChange: selectedRowKeys => {
        console.log('OnChange事件：', selectedRowKeys);
        this.setState(
          {
            selectedRowKeys
          },
          () => {
            console.log('selectedRowKeys-more', this.state.selectedRowKeys);
          }
        );
      },
      onSelect: (record, selected, selectedRows) => {
        const selectId = this.state.selectedRowIds;
        if (selected === true) {
          selectId.push(record.paySchemeId);
        } else {
          for (let i = 0; i < selectId.length; i++) {
            if (selectId[i] === record.paySchemeId) {
              selectId.splice(i, 1);
              break;
            }
          }
        }
        //根据选中的列表，进行获取列表名称
        let names = this.state.selectedRowNames;
        //最后一个去悼，不需要、
        names = '';
        let i = 0;
        selectedRows.map((val, key) => {
          if (i == 0) {
            names += '[' + val.schemeName + ']';
          } else {
            names += '、[' + val.schemeName + ']';
          }
          i++;
        });

        this.setState({
          selectedRowIds: selectId,
          selectedRowNames: names
        });
        console.log(`选中的名称:`, names);
        console.log(
          `record:`,
          record.paySchemeId,
          `selected:`,
          selected,
          `selectedRows:`,
          selectedRows
        );
      },
      onSelectAll: (selected, selectedRows, changeRows) => {
        let selectId = [];

        if (selected === true) {
          for (let i = 0; i < selectedRows.length; i++) {
            selectId.push(selectedRows[i].paySchemeId);
          }
        } else {
          selectId = [];
          // selectedRowKeys:selectedRowKey
        }

        //根据选中的列表，进行获取列表名称
        let names = this.state.selectedRowNames;
        names = '';
        selectedRows.map((val, key) => {
          names += '[' + val.schemeName + ']、';
        });
        this.setState({
          selectedRowIds: selectId,
          selectedRowNames: names
        });
        console.log(`ALL选中的名称:`, names);
        console.log(
          `selected:`,
          selected,
          `selectedRows:`,
          selectedRows,
          `changeRows:`,
          changeRows
        );
      }
    };

    // const tmp = this.state.listPage.map((val, i) => {
    //   const value = val;
    //   value.key = i + 1;
    //   return value;
    // });

    return (
      <PTable
        style={{ marginTop: '16px' }}
        forceUpdate={this.state.forceUpdate}
        url='getPaymentSettingListPage'
        columns={columns}
        pageParm={this.state.pageParm}
        showTotal
        rowSelection={rowSelection}
        // dataSource={tmp}
        // pagination={pageInitStudent}
      />
    );
  };

  render() {
    return (
      <div className='medical-pay'>
        <Breadcrumb
          style={{ borderBottom: '1px solid #E9E9E9', paddingBottom: '10px' }}
        >
          <Breadcrumb.Item>
            <a
              onClick={() => {
                this.props.history.push(`/salarymanagement/medicalrecord`);
              }}
            >
              五险一金设置
            </a>
          </Breadcrumb.Item>
          <Breadcrumb.Item>缴纳比例管理</Breadcrumb.Item>
        </Breadcrumb>
        <Alert
          style={{ marginTop: '14px' }}
          message='设置缴交比例方案后，需要添加员工至方案方可生效。设置成功后次月自动生成五险一金费用记录！'
          type='warning'
          showIcon
        />
        <div className='pay-button'>
          <Button
            style={{ marginRight: '8px' }}
            onClick={() => {
              this.props.history.push(`/salarymanagement/medicalrecord`);
            }}
          >
            返回
          </Button>
          <Button
            type='primary'
            style={{ marginRight: '8px' }}
            onClick={() => {
              this.props.history.push(`/salarymanagement/proporset/${'00'}`);
            }}
          >
            新增缴纳比例
          </Button>
          <Button type='danger' ghost onClick={this.handleDeleteList}>
            删除
          </Button>
        </div>
        {this.checkPayContent()}
      </div>
    );
  }
}
