import React, { PureComponent } from "react";
import { connect } from "dva";
import style from "styled-components";
import { Tabs } from "antd";
import Incentive from "./Incentive";
import Punishment from "./Punishment";
import GoodDeeds from "./GoodDeeds";

const { TabPane } = Tabs;
// const { Option } = Select;

@connect(state => ({
  monitor: state.monitor
}))
export default class ListContainer extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      shows: [true, false, false, false] //各个 tab 内容是否显示，这里按需加载
    };
  }

  tabChange = e => {
    //各个 tab 内容是否显示，这里按需加载
    const shows = [...this.state.shows];
    shows[e] = true;
    this.setState({ shows });
  };

  render() {
    return (
      <Container>
        <Tabs onChange={this.tabChange}>
          <TabPane tab="员工奖励" key="1">
            {this.state.shows[0] && <Incentive />}
          </TabPane>
          <TabPane tab="员工处罚" key="2">
            {this.state.shows[0] && <Punishment />}
          </TabPane>
          <TabPane tab="好人好事" key="3">
            {this.state.shows[0] && <GoodDeeds />}
          </TabPane>
        </Tabs>
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
`;
