/**
 * 加入会议
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Input, Modal, Spin } from "antd";
import "../meeting.less";
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 8 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 10 }
  }
};
@connect(state => ({
  client: state.client.client,
  comName: state.global.companyInfo.comName,
  username: state.user.currentUser.name,
  joinMeetingStatus: state.client.joinMeetingStatus,
  isSuccessJoinMeeting: state.client.isSuccessJoinMeeting
}))
@Form.create()
export default class Join extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      joinVisible: this.props.joinVisible, //是否展示模态框的状态
      joinMeetingStatus: this.props.joinMeetingStatus
    };
  }
  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    this.setState({
      joinVisible: nextProps.joinVisible
    });
    if (nextProps.joinMeetingStatus !== this.state.joinMeetingStatus) {
      this.setState({
        joinMeetingStatus: nextProps.joinMeetingStatus
      });
    }
    //加入会议成功之后，关掉模态框并重置输入框数据
    if (
      nextProps.isSuccessJoinMeeting !== this.props.isSuccessJoinMeeting &&
      nextProps.isSuccessJoinMeeting
    ) {
      this.props.form.resetFields();
      this.props.changeJoinStatus(false);
    }
  }
  handleSubmit() {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: `client/setJoinMeetingStatus`,
          payload: {
            joinMeetingStatus: true
          }
        });
        var joinConfParam = {
          conferenceId: values.conferenceId.trim(),
          accessNumber: "+991117",
          confPasswd:
            values.confPasswd === undefined
              ? values.confPasswd
              : values.confPasswd.trim()
        };
        const _this = this;
        window.setHweiMeeingNickname = values.nickname;
        this.props.client.joinConference(joinConfParam, function(ret) {
          if (ret.result) {
            _this.props.dispatch({
              type: `client/setCurrentConferID`,
              payload: {
                currentConferID: values.conferenceId
              }
            });
          }
        });
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="meeting">
        <Modal
          title="加入会议"
          visible={this.state.joinVisible}
          onOk={() => this.handleSubmit()}
          okText="加入"
          onCancel={() => {
            this.props.changeJoinStatus(false);
          }}
        >
          <Spin tip="正在加入会议..." spinning={this.state.joinMeetingStatus}>
            <Form>
              <Form.Item {...formItemLayout} label="会议ID">
                {getFieldDecorator("conferenceId", {
                  rules: [{ required: true, message: "请输入会议ID" }]
                })(<Input placeholder="请输入会议ID" />)}
              </Form.Item>
              <Form.Item {...formItemLayout} label="会议密码">
                {getFieldDecorator(
                  "confPasswd",
                )(<Input placeholder="请输入会议密码" />)}
              </Form.Item>
              <Form.Item {...formItemLayout} label="用户昵称" extra={<span className="placeholder">提示：请输入姓名+公司名称</span>}>
                {getFieldDecorator("nickname", {
                  initialValue: this.props.username + "+" + this.props.comName
                })(<Input placeholder="请输入姓名+公司名称" maxLength={127}/>)}
              </Form.Item>
            </Form>
            <p id="callState"></p>
          </Spin>
        </Modal>
      </div>
    );
  }
}
